/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhem.testpopulator.internal.util;

import com.github.anhem.testpopulator.exception.PopulateException;
import com.github.anhem.testpopulator.internal.util.PopulateUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;

public class ImmutablesUtil {
    static final String ADD_PREFIX = "add";
    static final String ADD_ALL_PREFIX = "addAll";
    static final String PUT_PREFIX = "put";
    static final String PUT_ALL_PREFIX = "putAll";
    private static final String ADD_METHOD_PATTERN = String.format("%s%s", "add", "\\p{Lu}.*");
    private static final String ADD_ALL_METHOD_PATTERN = String.format("%s%s", "addAll", "\\p{Lu}.*");
    private static final String PUT_METHOD_PATTERN = String.format("%s%s", "put", "\\p{Lu}.*");
    private static final String PUT_ALL_METHOD_PATTERN = String.format("%s%s", "putAll", "\\p{Lu}.*");
    public static final String CLASS_PREFIX = "Immutable";
    public static final String DOT = ".";
    public static final String FAILED_TO_FIND_CLASS = "Unable to find Immutables generated class for %s";

    private ImmutablesUtil() {
    }

    public static <T> List<Method> getMethodsForImmutablesBuilder(Class<T> clazz, Object builderObject, List<String> blacklistedMethods) {
        List<Method> declaredMethods = PopulateUtil.getDeclaredMethods(builderObject.getClass(), blacklistedMethods);
        return ImmutablesUtil.removeMethodsDoingTheSameThing(declaredMethods).stream().filter(PopulateUtil::hasAtLeastOneParameter).filter(method -> !PopulateUtil.isDeclaringJavaBaseClass(method)).filter(method -> !ImmutablesUtil.isSameMethodParameterAsClass(clazz, method)).collect(Collectors.toList());
    }

    public static Class<?> getImmutablesGeneratedClass(Class<?> clazz) {
        if (clazz.isInterface() || ImmutablesUtil.isAbstract(clazz)) {
            try {
                String packageName = clazz.getName().substring(0, clazz.getName().lastIndexOf(DOT));
                String className = String.format("%s.%s%s", packageName, CLASS_PREFIX, clazz.getSimpleName());
                return Class.forName(className);
            }
            catch (Exception e) {
                throw new PopulateException(String.format(FAILED_TO_FIND_CLASS, clazz.getName()), e);
            }
        }
        return clazz;
    }

    private static List<Method> removeMethodsDoingTheSameThing(List<Method> methods) {
        List methodNames = methods.stream().map(Method::getName).collect(Collectors.toList());
        List methodsToRemove = methods.stream().filter(ImmutablesUtil::isMatchingAnyMethodPrefixes).filter(method -> !methodNames.contains(ImmutablesUtil.getMethodNameWithoutPrefix(method))).collect(Collectors.toList());
        return methods.stream().filter(method -> !methodsToRemove.contains(method)).collect(Collectors.toList());
    }

    static <T> boolean isSameMethodParameterAsClass(Class<T> clazz, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0].isAssignableFrom(clazz);
    }

    private static String getMethodNameWithoutPrefix(Method method) {
        return method.getName().replace(ADD_ALL_PREFIX, "").replace(ADD_PREFIX, "").replace(PUT_ALL_PREFIX, "").replace(PUT_PREFIX, "");
    }

    private static boolean isMatchingAnyMethodPrefixes(Method method) {
        return ImmutablesUtil.isAddMethod(method) || ImmutablesUtil.isAddAllMethod(method) || ImmutablesUtil.isPutMethod(method) || ImmutablesUtil.isPutAllMethod(method);
    }

    private static boolean isAddMethod(Method method) {
        return method.getName().matches(ADD_METHOD_PATTERN);
    }

    private static boolean isAddAllMethod(Method method) {
        return method.getName().matches(ADD_ALL_METHOD_PATTERN);
    }

    private static boolean isPutMethod(Method method) {
        return method.getName().matches(PUT_METHOD_PATTERN);
    }

    private static boolean isPutAllMethod(Method method) {
        return method.getName().matches(PUT_ALL_METHOD_PATTERN);
    }

    private static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }
}

