/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhem.testpopulator.internal.util;

import com.github.anhem.testpopulator.internal.util.PopulateUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LombokUtil {
    private static final String CLEAR_METHOD_PATTERN = String.format("%s%s", "clear", "\\p{Lu}.*");

    private LombokUtil() {
    }

    public static Map<Integer, List<Method>> getMethodsForLombokBuilderGroupedByInvokeOrder(Class<?> clazz, List<String> blacklistedMethods) {
        return PopulateUtil.getDeclaredMethods(clazz, blacklistedMethods).stream().filter(method -> !PopulateUtil.isDeclaringJavaBaseClass(method)).collect(Collectors.groupingBy(LombokUtil::lombokMethodInvokeOrder));
    }

    public static int calculateExpectedChildren(Map<Integer, List<Method>> builderObjectMethodsGroupedByInvokeOrder) {
        return builderObjectMethodsGroupedByInvokeOrder.entrySet().stream().filter(e -> (Integer)e.getKey() > 0).map(e -> ((List)e.getValue()).size()).reduce(0, Integer::sum);
    }

    private static int lombokMethodInvokeOrder(Method method) {
        if (Arrays.stream(method.getParameterTypes()).anyMatch(PopulateUtil::isCollection)) {
            return 3;
        }
        if (LombokUtil.isClearMethod(method)) {
            return 2;
        }
        if (PopulateUtil.hasAtLeastOneParameter(method)) {
            return 1;
        }
        return 0;
    }

    private static boolean isClearMethod(Method method) {
        return method.getName().matches(CLEAR_METHOD_PATTERN) && method.getParameterTypes().length == 0;
    }
}

