/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhem.testpopulator.internal.util;

import com.github.anhem.testpopulator.config.BuilderPattern;
import com.github.anhem.testpopulator.config.ConstructorType;
import com.github.anhem.testpopulator.config.Strategy;
import com.github.anhem.testpopulator.internal.carrier.ClassCarrier;
import com.github.anhem.testpopulator.internal.carrier.CollectionCarrier;
import com.github.anhem.testpopulator.internal.util.ImmutablesUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PopulateUtil {
    static final String MATCH_FIRST_CHARACTER_UPPERCASE = "\\p{Lu}.*";
    private static final String JAVA_BASE = "java.base";
    private static final String NO_CONSTRUCTOR_FOUND = "Could not find public constructor for %s";

    private PopulateUtil() {
    }

    public static List<Type> toArgumentTypes(Parameter parameter) {
        return Arrays.stream(((ParameterizedType)parameter.getParameterizedType()).getActualTypeArguments()).map(type -> type instanceof WildcardType ? ((WildcardType)type).getUpperBounds()[0] : type).collect(Collectors.toList());
    }

    public static <T> List<Field> getDeclaredFields(Class<T> clazz, List<String> blacklistedFields) {
        List<Field> declaredFields = PopulateUtil.getAllDeclaredFields(clazz, new ArrayList<Field>());
        return PopulateUtil.removeUnwantedFields(declaredFields, blacklistedFields);
    }

    public static <T> List<Method> getDeclaredMethods(Class<T> clazz, List<String> blacklistedMethods) {
        List<Method> declaredMethods = PopulateUtil.getAllDeclaredMethods(clazz, new ArrayList<Method>());
        return PopulateUtil.removeUnwantedMethods(declaredMethods, blacklistedMethods);
    }

    public static <T> List<Method> getSetterMethods(Class<T> clazz, List<String> blacklistedMethods, List<String> setterPrefixes) {
        List<String> setterMethodFormats = PopulateUtil.getSetterMethodFormats(setterPrefixes);
        return PopulateUtil.getDeclaredMethods(clazz, blacklistedMethods).stream().filter(method -> PopulateUtil.isSetterMethod(method, setterMethodFormats)).collect(Collectors.toList());
    }

    public static <T> List<Method> getMutatorMethods(Class<T> clazz, List<String> blacklistedMethods) {
        return PopulateUtil.getDeclaredMethods(clazz, blacklistedMethods).stream().filter(method -> PopulateUtil.isMutatorMethod(method, clazz)).collect(Collectors.toList());
    }

    public static <T> boolean isSet(Class<T> clazz) {
        return Set.class.isAssignableFrom(clazz);
    }

    public static <T> boolean isMap(Class<T> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public static <T> boolean isMapEntry(Class<T> clazz) {
        return Map.Entry.class.isAssignableFrom(clazz);
    }

    public static <T> boolean isCollection(Class<T> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Iterable.class.isAssignableFrom(clazz) || Map.Entry.class.isAssignableFrom(clazz);
    }

    public static <T> boolean isCollectionCarrier(ClassCarrier<T> classCarrier) {
        return classCarrier instanceof CollectionCarrier;
    }

    public static <T> boolean isJavaBaseClass(Class<T> clazz) {
        return clazz.getModule() != null && JAVA_BASE.equals(clazz.getModule().getName());
    }

    static boolean isDeclaringJavaBaseClass(Method method) {
        return PopulateUtil.isJavaBaseClass(method.getDeclaringClass());
    }

    static boolean hasAtLeastOneParameter(Method method) {
        return method.getParameters().length > 0;
    }

    public static <T> boolean isMatchingSetterStrategy(Strategy strategy, Class<T> clazz, List<String> setterPrefixes, boolean accessNonPublicConstructor) {
        if (strategy.equals((Object)Strategy.SETTER) && PopulateUtil.hasConstructorWithoutArguments(clazz, accessNonPublicConstructor)) {
            List<String> setterMethodFormats = PopulateUtil.getSetterMethodFormats(setterPrefixes);
            return PopulateUtil.getAllDeclaredMethods(clazz, new ArrayList<Method>()).stream().filter(method -> !PopulateUtil.isWaitMethod(method)).anyMatch(method -> PopulateUtil.isSetterMethod(method, setterMethodFormats));
        }
        return false;
    }

    public static <T> boolean isMatchingMutatorStrategy(Strategy strategy, Class<T> clazz, boolean accessNonPublicConstructor, ConstructorType constructorType) {
        if (strategy.equals((Object)Strategy.MUTATOR) && PopulateUtil.hasAccessibleConstructor(clazz, accessNonPublicConstructor, constructorType)) {
            return PopulateUtil.getAllDeclaredMethods(clazz, new ArrayList<Method>()).stream().filter(method -> !PopulateUtil.isWaitMethod(method)).anyMatch(method -> PopulateUtil.isMutatorMethod(method, clazz));
        }
        return false;
    }

    public static <T> boolean isMatchingConstructorStrategy(Strategy strategy, Class<T> clazz, boolean accessNonPublicConstructor) {
        return strategy.equals((Object)Strategy.CONSTRUCTOR) && PopulateUtil.hasConstructorWithArguments(clazz, accessNonPublicConstructor);
    }

    public static <T> boolean isMatchingFieldStrategy(Strategy strategy, Class<T> clazz, boolean accessNonPublicConstructor) {
        return strategy.equals((Object)Strategy.FIELD) && PopulateUtil.hasConstructorWithoutArguments(clazz, accessNonPublicConstructor);
    }

    public static <T> boolean isMatchingBuilderStrategy(Strategy strategy, Class<T> clazz, BuilderPattern builderPattern) {
        if (strategy.equals((Object)Strategy.BUILDER)) {
            try {
                if (builderPattern.equals((Object)BuilderPattern.IMMUTABLES)) {
                    ImmutablesUtil.getImmutablesGeneratedClass(clazz).getDeclaredMethod("builder", new Class[0]);
                } else {
                    clazz.getDeclaredMethod("builder", new Class[0]);
                }
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return false;
    }

    private static <T> boolean hasAccessibleConstructor(Class<T> clazz, boolean canAccessNonPublicConstructor, ConstructorType constructorType) {
        try {
            PopulateUtil.getConstructor(clazz, canAccessNonPublicConstructor, constructorType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, boolean canAccessNonPublicConstructor, ConstructorType constructorType) {
        switch (constructorType) {
            case SMALLEST: {
                return PopulateUtil.getSmallestConstructor(clazz, canAccessNonPublicConstructor);
            }
            case LARGEST: {
                return PopulateUtil.getLargestConstructor(clazz, canAccessNonPublicConstructor);
            }
        }
        return PopulateUtil.getNoArgsConstructor(clazz, canAccessNonPublicConstructor);
    }

    private static <T> Constructor<T> getSmallestConstructor(Class<T> clazz, boolean canAccessNonPublicConstructor) {
        return Arrays.stream(clazz.getDeclaredConstructors()).filter(constructor -> canAccessNonPublicConstructor || Modifier.isPublic(constructor.getModifiers())).filter(constructor -> constructor.getParameterCount() != 0).min(Comparator.comparingInt(Constructor::getParameterCount)).orElseGet(() -> PopulateUtil.getNoArgsConstructor(clazz, canAccessNonPublicConstructor));
    }

    public static <T> Constructor<T> getLargestConstructor(Class<T> clazz, boolean canAccessNonPublicConstructor) {
        return Arrays.stream(clazz.getDeclaredConstructors()).filter(constructor -> canAccessNonPublicConstructor || Modifier.isPublic(constructor.getModifiers())).filter(constructor -> constructor.getParameterCount() != 0).max(Comparator.comparingInt(Constructor::getParameterCount)).orElseGet(() -> PopulateUtil.getNoArgsConstructor(clazz, canAccessNonPublicConstructor));
    }

    private static <T> Constructor<T> getNoArgsConstructor(Class<T> clazz, boolean canAccessNonPublicConstructor) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (canAccessNonPublicConstructor || Modifier.isPublic(constructor.getModifiers())) {
                return constructor;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new RuntimeException(String.format(NO_CONSTRUCTOR_FOUND, clazz.getName()));
    }

    static boolean isBlackListed(Method method, List<String> blacklistedMethods) {
        return blacklistedMethods.contains(method.getName());
    }

    static boolean isBlackListed(Field field, List<String> blacklistedFields) {
        return blacklistedFields.contains(field.getName());
    }

    private static boolean isSetterMethod(Method method, List<String> setterMethodFormats) {
        return setterMethodFormats.stream().anyMatch(setMethodFormat -> PopulateUtil.isSetterMethod(method, setMethodFormat));
    }

    private static boolean isSetterMethod(Method method, String setMethodFormat) {
        if (setMethodFormat.isBlank()) {
            return method.getReturnType().equals(Void.TYPE) && method.getParameters().length == 1;
        }
        return method.getName().matches(setMethodFormat) && method.getReturnType().equals(Void.TYPE) && method.getParameters().length == 1;
    }

    private static <T> boolean isMutatorMethod(Method method, Class<T> clazz) {
        return (method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(clazz)) && method.getParameters().length > 0;
    }

    public static <T> void setAccessible(Constructor<T> constructor, boolean canAccessNonPublicConstructor) {
        if (canAccessNonPublicConstructor && !constructor.canAccess(null)) {
            constructor.setAccessible(true);
        }
    }

    public static <T> void setAccessible(Method method, T object) {
        if (!method.canAccess(object)) {
            method.setAccessible(true);
        }
    }

    public static <T> void setAccessible(Field field, T object) {
        if (!field.canAccess(object)) {
            field.setAccessible(true);
        }
    }

    public static <T> boolean hasConstructors(CollectionCarrier<T> collectionCarrier) {
        return collectionCarrier.getClazz().getConstructors().length > 0;
    }

    public static <T> boolean alreadyVisited(ClassCarrier<T> classCarrier, boolean nullOnCircularDependency) {
        return nullOnCircularDependency && !PopulateUtil.isJavaBaseClass(classCarrier.getClazz()) && !classCarrier.addVisited();
    }

    private static <T> boolean hasConstructorWithoutArguments(Class<T> clazz, boolean canAccessNonPublicConstructor) {
        return Arrays.stream(clazz.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 0).anyMatch(constructor -> PopulateUtil.isAccessible(canAccessNonPublicConstructor, constructor));
    }

    private static <T> boolean hasConstructorWithArguments(Class<T> clazz, boolean canAccessNonPublicConstructor) {
        return Arrays.stream(clazz.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() > 0).anyMatch(constructor -> PopulateUtil.isAccessible(canAccessNonPublicConstructor, constructor));
    }

    private static <T> List<Field> getAllDeclaredFields(Class<T> clazz, List<Field> declaredFields) {
        declaredFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            PopulateUtil.getAllDeclaredFields(clazz.getSuperclass(), declaredFields);
        }
        return declaredFields;
    }

    private static <T> List<Method> getAllDeclaredMethods(Class<T> clazz, List<Method> declaredMethods) {
        declaredMethods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        if (clazz.getSuperclass() != null) {
            PopulateUtil.getAllDeclaredMethods(clazz.getSuperclass(), declaredMethods);
        }
        return declaredMethods;
    }

    private static List<String> getSetterMethodFormats(List<String> setterPrefixes) {
        return setterPrefixes.stream().map(PopulateUtil::getSetterMethodFormat).collect(Collectors.toList());
    }

    private static String getSetterMethodFormat(String setterPrefix) {
        return setterPrefix.isEmpty() ? "" : String.format("%s%s", setterPrefix, MATCH_FIRST_CHARACTER_UPPERCASE);
    }

    private static List<Field> removeUnwantedFields(List<Field> declaredFields, List<String> blacklistedFields) {
        return declaredFields.stream().filter(field -> !PopulateUtil.isBlackListed(field, blacklistedFields)).collect(Collectors.toList());
    }

    private static List<Method> removeUnwantedMethods(List<Method> declaredMethods, List<String> blacklistedMethods) {
        return declaredMethods.stream().filter(method -> {
            if (PopulateUtil.isBlackListed(method, blacklistedMethods)) {
                return false;
            }
            if (PopulateUtil.isNativeMethod(method)) {
                return false;
            }
            return !PopulateUtil.isWaitMethod(method);
        }).collect(Collectors.toList());
    }

    private static boolean isNativeMethod(Method method) {
        return Modifier.isNative(method.getModifiers());
    }

    private static boolean isWaitMethod(Method method) {
        boolean isWaitName;
        boolean isFinal = Modifier.isFinal(method.getModifiers());
        boolean bl = isWaitName = method.getName().equals("wait") || method.getName().equals("wait0") && Modifier.isNative(method.getModifiers());
        if (isFinal && isWaitName) {
            return method.getParameters().length == 0 || method.getParameters().length == 1 && method.getParameters()[0].getType().equals(Long.TYPE) || method.getParameters().length == 2 && method.getParameters()[0].getType().equals(Long.TYPE) && method.getParameters()[1].getType().equals(Integer.TYPE);
        }
        return false;
    }

    private static <T> boolean isAccessible(boolean canAccessNonPublicConstructor, Constructor<T> constructor) {
        if (canAccessNonPublicConstructor) {
            return true;
        }
        return Modifier.isPublic(constructor.getModifiers());
    }
}

