/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhem.testpopulator.internal.util;

import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Random;

public class RandomUtil {
    private static final int RANDOM_INT_MAX_VALUE = 1000000;
    private static final int LEFT_LIMIT = 97;
    private static final int RIGHT_LIMIT = 122;
    static final int STRING_LENGTH = 10;
    private static final Random random = new SecureRandom();

    private RandomUtil() {
    }

    public static int getRandomInt() {
        return random.nextInt(1000000);
    }

    public static short getRandomShort() {
        return (short)random.nextInt(32768);
    }

    public static Float getRandomFloat() {
        return Float.valueOf(random.nextFloat());
    }

    public static String getRandomString() {
        return random.ints(97, 123).limit(10L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static Boolean getRandomBoolean() {
        return random.nextBoolean();
    }

    public static LocalDate getRandomLocalDate() {
        return RandomUtil.getRandomLocalDateTime().toLocalDate();
    }

    public static LocalDateTime getRandomLocalDateTime() {
        return LocalDateTime.now().minusYears(1L).plusDays(random.nextInt(365));
    }

    public static Character getRandomCharacter() {
        return Character.valueOf(RandomUtil.getRandomString().charAt(0));
    }

    public static <T> T getRandomEnum(Class<T> clazz) {
        List<T> enumValues = List.of(clazz.getEnumConstants());
        return enumValues.get(random.nextInt(enumValues.size()));
    }

    public static Byte getRandomByte() {
        byte[] bytes = new byte[1];
        random.nextBytes(bytes);
        return bytes[0];
    }
}

