/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhem.testpopulator.internal.value;

import com.github.anhem.testpopulator.config.OverridePopulate;
import com.github.anhem.testpopulator.exception.PopulateException;
import com.github.anhem.testpopulator.internal.util.RandomUtil;
import com.github.anhem.testpopulator.internal.value.TypeSupplier;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class ValueFactory {
    static final String UNSUPPORTED_TYPE = "Failed to find type to create value for %s. Not implemented?";
    private static final LocalDateTime LOCAL_DATE_TIME = LocalDateTime.of(1970, 1, 1, 0, 0, 0, 0);
    private static final ZonedDateTime ZONED_DATE_TIME = LOCAL_DATE_TIME.atZone(ZoneId.of("UTC"));
    private static final Instant INSTANT = ZONED_DATE_TIME.toInstant();
    private static final LocalDate LOCAL_DATE = LOCAL_DATE_TIME.toLocalDate();
    private static final Date DATE = Date.from(INSTANT);
    private static final String STRING = "string";
    private static final Boolean BOOLEAN = Boolean.TRUE;
    private static final Long LONG = 1L;
    private static final Double DOUBLE = 1.0;
    private static final Integer INTEGER = 1;
    private static final Character CHARACTER = Character.valueOf('c');
    private static final String UUID_STRING = "43c6e27d-c0c6-43d6-8462-34ac04c1d5f3";
    private static final BigDecimal BIG_DECIMAL = BigDecimal.ONE;
    private static final byte BYTE = 1;
    private static final short SHORT = 1;
    private static final float FLOAT = 1.0f;
    private final boolean setRandomValues;
    private final Map<Class<?>, TypeSupplier<?>> typeSuppliers;

    public ValueFactory(boolean setRandomValues, Map<Class<?>, OverridePopulate<?>> overridePopulates) {
        this.setRandomValues = setRandomValues;
        this.typeSuppliers = this.getDefaultTypeSuppliers();
        this.typeSuppliers.putAll(overridePopulates);
    }

    private Map<Class<?>, TypeSupplier<?>> getDefaultTypeSuppliers() {
        HashMap typeSuppliers = new HashMap();
        typeSuppliers.put(Integer.class, this::getInteger);
        typeSuppliers.put(Integer.TYPE, this::getInteger);
        typeSuppliers.put(Long.class, this::getLong);
        typeSuppliers.put(Long.TYPE, this::getLong);
        typeSuppliers.put(Double.class, this::getDouble);
        typeSuppliers.put(Double.TYPE, this::getDouble);
        typeSuppliers.put(Short.class, this::getShort);
        typeSuppliers.put(Short.TYPE, this::getShort);
        typeSuppliers.put(Float.class, this::getFloat);
        typeSuppliers.put(Float.TYPE, this::getFloat);
        typeSuppliers.put(Boolean.class, this::getBoolean);
        typeSuppliers.put(Boolean.TYPE, this::getBoolean);
        typeSuppliers.put(BigDecimal.class, this::getBigDecimal);
        typeSuppliers.put(String.class, this::getString);
        typeSuppliers.put(LocalDate.class, this::getLocalDate);
        typeSuppliers.put(LocalDateTime.class, this::getLocalDateTime);
        typeSuppliers.put(ZonedDateTime.class, this::getZonedDateTime);
        typeSuppliers.put(Instant.class, this::getInstant);
        typeSuppliers.put(Date.class, this::getDate);
        typeSuppliers.put(Character.class, this::getChar);
        typeSuppliers.put(Character.TYPE, this::getChar);
        typeSuppliers.put(UUID.class, this::getUUID);
        typeSuppliers.put(Byte.TYPE, this::getByte);
        typeSuppliers.put(Byte.class, this::getByte);
        return typeSuppliers;
    }

    public <T> T createValue(Class<T> clazz) {
        if (clazz.isEnum()) {
            return this.getEnum(clazz);
        }
        return (T)Optional.ofNullable(this.typeSuppliers.get(clazz)).map(supplier -> supplier.create()).orElseThrow(() -> new PopulateException(String.format(UNSUPPORTED_TYPE, clazz.getTypeName())));
    }

    public boolean hasType(Class<?> clazz) {
        return clazz.isEnum() || this.typeSuppliers.containsKey(clazz);
    }

    private <T> T getEnum(Class<T> clazz) {
        if (this.setRandomValues) {
            return RandomUtil.getRandomEnum(clazz);
        }
        return clazz.getEnumConstants()[0];
    }

    private Integer getInteger() {
        return this.setRandomValues ? Integer.valueOf(RandomUtil.getRandomInt()) : INTEGER;
    }

    private Long getLong() {
        return this.setRandomValues ? Long.valueOf(RandomUtil.getRandomInt()) : LONG;
    }

    private Double getDouble() {
        return this.setRandomValues ? Double.valueOf(RandomUtil.getRandomInt()) : DOUBLE;
    }

    private Short getShort() {
        return this.setRandomValues ? RandomUtil.getRandomShort() : (short)1;
    }

    private Float getFloat() {
        return Float.valueOf(this.setRandomValues ? RandomUtil.getRandomFloat().floatValue() : 1.0f);
    }

    private Boolean getBoolean() {
        return this.setRandomValues ? RandomUtil.getRandomBoolean() : BOOLEAN;
    }

    private BigDecimal getBigDecimal() {
        return this.setRandomValues ? BigDecimal.valueOf(RandomUtil.getRandomInt()) : BIG_DECIMAL;
    }

    private String getString() {
        return this.setRandomValues ? RandomUtil.getRandomString() : STRING;
    }

    private LocalDateTime getLocalDateTime() {
        return this.setRandomValues ? RandomUtil.getRandomLocalDateTime() : LOCAL_DATE_TIME;
    }

    private ZonedDateTime getZonedDateTime() {
        return this.setRandomValues ? RandomUtil.getRandomLocalDateTime().atZone(ZoneId.systemDefault()) : ZONED_DATE_TIME;
    }

    private Instant getInstant() {
        return this.setRandomValues ? RandomUtil.getRandomLocalDateTime().atZone(ZoneId.systemDefault()).toInstant() : INSTANT;
    }

    private Date getDate() {
        return this.setRandomValues ? Date.from(RandomUtil.getRandomLocalDateTime().atZone(ZoneId.systemDefault()).toInstant()) : DATE;
    }

    private LocalDate getLocalDate() {
        return this.setRandomValues ? RandomUtil.getRandomLocalDateTime().toLocalDate() : LOCAL_DATE;
    }

    private Character getChar() {
        return this.setRandomValues ? RandomUtil.getRandomCharacter() : CHARACTER;
    }

    private UUID getUUID() {
        return this.setRandomValues ? UUID.randomUUID() : UUID.fromString(UUID_STRING);
    }

    private Byte getByte() {
        return this.setRandomValues ? RandomUtil.getRandomByte() : (byte)1;
    }
}

