/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.github.anicolaspp.ojai.InMemoryMutation;
import com.github.anicolaspp.ojai.MultiPathProjector;
import com.github.anicolaspp.ojai.ResultDocumentStream;
import com.mapr.db.impl.ConditionEvaluator;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.ojai.store.impl.OjaiQuery;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.MutationOp;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import org.ojai.store.exceptions.MultiOpException;
import org.ojai.store.exceptions.StoreException;
import scala.Tuple2;

public class InMemoryStore
implements DocumentStore {
    private Connection connection;
    private ArrayList<Document> documents = new ArrayList();
    private String storeName;
    private boolean clearStoreOnClose;

    public InMemoryStore(String string, Connection connection, boolean bl) {
        this.storeName = string;
        this.connection = connection;
        this.clearStoreOnClose = bl;
    }

    public InMemoryStore(String string, Connection connection) {
        this(string, connection, true);
    }

    public String toString() {
        return "InMemoryStore:" + this.storeName;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void flush() throws StoreException {
    }

    public void beginTrackingWrites() throws StoreException {
    }

    public void beginTrackingWrites(String string) throws StoreException {
    }

    public String endTrackingWrites() throws StoreException {
        return null;
    }

    public void clearTrackedWrites() throws StoreException {
    }

    public Document findById(String string) throws StoreException {
        return this.documents.stream().filter(document -> document.getIdString().equals(string)).findFirst().orElse(null);
    }

    public Document findById(Value value) throws StoreException {
        return this.findById(value.getString());
    }

    public Document findById(String string, String ... stringArray) throws StoreException {
        Document document = this.findById(string);
        if (document == null) {
            return null;
        }
        return this.project(document, stringArray);
    }

    public Document findById(String string, FieldPath ... fieldPathArray) throws StoreException {
        return this.findById(string, (String[])Arrays.stream(fieldPathArray).map(FieldPath::getName).toArray(String[]::new));
    }

    public Document findById(Value value, String ... stringArray) throws StoreException {
        return this.findById(value.getString(), stringArray);
    }

    public Document findById(Value value, FieldPath ... fieldPathArray) throws StoreException {
        return this.findById(value.getString(), fieldPathArray);
    }

    public Document findById(String string, QueryCondition queryCondition) throws StoreException {
        return Stream.generate(this.find(this.connection.newQuery().where(queryCondition).build()).iterator()::next).filter(document -> document.getIdString().equals(string)).findFirst().orElse(null);
    }

    public Document findById(Value value, QueryCondition queryCondition) throws StoreException {
        return this.findById(value.getString(), queryCondition);
    }

    public Document findById(String string, QueryCondition queryCondition, String ... stringArray) throws StoreException {
        return Stream.generate(this.find(this.connection.newQuery().where(queryCondition).select(stringArray).build()).iterator()::next).filter(document -> document.getIdString().equals(string)).findFirst().orElse(null);
    }

    public Document findById(String string, QueryCondition queryCondition, FieldPath ... fieldPathArray) throws StoreException {
        return this.findById(string, queryCondition, (String[])Arrays.stream(fieldPathArray).map(FieldPath::asJsonString).toArray(String[]::new));
    }

    public Document findById(Value value, QueryCondition queryCondition, String ... stringArray) throws StoreException {
        return this.findById(value.getString(), queryCondition, stringArray);
    }

    public Document findById(Value value, QueryCondition queryCondition, FieldPath ... fieldPathArray) throws StoreException {
        return this.findById(value.getString(), queryCondition, fieldPathArray);
    }

    public QueryResult find(Query query) throws StoreException {
        OjaiQuery ojaiQuery = (OjaiQuery)query;
        ConditionImpl conditionImpl = ojaiQuery.getCondition();
        long l = ojaiQuery.getLimit();
        String[] stringArray = (String[])ojaiQuery.getProjectedFieldSet().stream().map(FieldPath::asJsonString).toArray(String[]::new);
        Stream<Tuple2> stream = ojaiQuery.getOrderByFields().stream().map(fieldPath -> new Tuple2(fieldPath, (Object)ojaiQuery.getFieldOrdering(fieldPath)));
        Stream<Document> stream2 = this.withCondition(this.documents.stream(), conditionImpl).map(document -> this.project((Document)document, stringArray));
        return new ResultDocumentStream(this.withLimit(stream2, l), this.connection);
    }

    private Stream<Document> withCondition(Stream<Document> stream, ConditionImpl conditionImpl) {
        if (conditionImpl == null || conditionImpl.getRoot() == null) {
            return stream;
        }
        return stream.filter(document -> new ConditionEvaluator(conditionImpl.getRoot(), this.connection).evalOn((Document)document));
    }

    private Stream<Document> withLimit(Stream<Document> stream, long l) {
        if (l >= 0L) {
            return stream.limit(l);
        }
        return stream;
    }

    public DocumentStream find() throws StoreException {
        return new ResultDocumentStream(this.documents.stream(), this.connection);
    }

    public DocumentStream findQuery(Query query) throws StoreException {
        return this.find(query);
    }

    public DocumentStream findQuery(String string) throws StoreException {
        return this.find(this.connection.newQuery(string).build());
    }

    public DocumentStream find(String ... stringArray) throws StoreException {
        return this.find(this.connection.newQuery().select(stringArray).build());
    }

    public DocumentStream find(FieldPath ... fieldPathArray) throws StoreException {
        return this.find(this.connection.newQuery().select(fieldPathArray).build());
    }

    public DocumentStream find(QueryCondition queryCondition) throws StoreException {
        return this.find(this.connection.newQuery().where(queryCondition).build());
    }

    public DocumentStream find(QueryCondition queryCondition, String ... stringArray) throws StoreException {
        return this.find(this.connection.newQuery().where(queryCondition).select(stringArray).build());
    }

    public DocumentStream find(QueryCondition queryCondition, FieldPath ... fieldPathArray) throws StoreException {
        return this.find(this.connection.newQuery().where(queryCondition).select(fieldPathArray).build());
    }

    public void insertOrReplace(Document document) throws StoreException {
        this.replace(document);
    }

    public void insertOrReplace(String string, Document document) throws StoreException {
        this.replace(string, document);
    }

    public void insertOrReplace(Value value, Document document) throws StoreException {
        this.replace(value, document);
    }

    public void insertOrReplace(Document document, FieldPath fieldPath) throws StoreException {
        this.replace(document, fieldPath);
    }

    public void insertOrReplace(Document document, String string) throws StoreException {
        this.replace(document, string);
    }

    public void insertOrReplace(DocumentStream documentStream) throws MultiOpException {
        this.replace(documentStream);
    }

    public void insertOrReplace(DocumentStream documentStream, FieldPath fieldPath) throws MultiOpException {
        this.replace(documentStream, fieldPath);
    }

    public void insertOrReplace(DocumentStream documentStream, String string) throws MultiOpException {
        this.replace(documentStream, string);
    }

    public void update(String string, DocumentMutation documentMutation) throws StoreException {
        InMemoryMutation inMemoryMutation = (InMemoryMutation)documentMutation;
        Iterator<MutationOp> iterator = inMemoryMutation.iterator();
        while (iterator.hasNext()) {
            MutationOp mutationOp = iterator.next();
            Document document = this.findById(string);
            if (document == null) {
                document = this.connection.newDocument().set("_id", string);
            }
            this.delete(string);
            if (mutationOp.getType() == MutationOp.Type.INCREMENT) {
                this.mutationIncrement(string, mutationOp, document);
                continue;
            }
            if (mutationOp.getType() == MutationOp.Type.DELETE) {
                this.mutationDelete(string, mutationOp, document);
                continue;
            }
            if (mutationOp.getType() == MutationOp.Type.APPEND) {
                this.mutationAppend(string, mutationOp, document);
                continue;
            }
            this.setFromValue(mutationOp.getFieldPath().asPathString(), mutationOp.getOpValue(), document);
            this.insert(string, document);
        }
    }

    public void update(Value value, DocumentMutation documentMutation) throws StoreException {
        this.update(value.getString(), documentMutation);
    }

    public void delete(String string) throws StoreException {
        int n = this.index(string);
        if (n >= 0) {
            this.documents.remove(n);
        }
    }

    public void delete(Value value) throws StoreException {
        this.delete(value.getString());
    }

    public void delete(Document document) throws StoreException {
        this.delete(document.getId());
    }

    public void delete(Document document, FieldPath fieldPath) throws StoreException {
        this.delete(document.getValue(fieldPath));
    }

    public void delete(Document document, String string) throws StoreException {
        this.delete(document.getValue(string));
    }

    public void delete(DocumentStream documentStream) throws MultiOpException {
        documentStream.forEach(this::delete);
    }

    public void delete(DocumentStream documentStream, FieldPath fieldPath) throws MultiOpException {
        documentStream.forEach(document -> this.delete((Document)document, fieldPath));
    }

    public void delete(DocumentStream documentStream, String string) throws MultiOpException {
        documentStream.forEach(document -> this.delete((Document)document, string));
    }

    public void insert(String string, Document document) throws StoreException {
        this.checkId(string);
        if (this.index(string) < 0) {
            this.documents.add(document.set("_id", string));
        }
    }

    public void insert(Value value, Document document) throws StoreException {
        this.checkId(value);
        if (this.index(value) < 0) {
            this.documents.add(document.set("_id", value));
        }
    }

    public void insert(Document document) throws StoreException {
        this.insert(document.getId(), document);
    }

    public void insert(Document document, FieldPath fieldPath) throws StoreException {
        this.insert(document.getValue(fieldPath), document);
    }

    public void insert(Document document, String string) throws StoreException {
        this.insert(document.getValue(string), document);
    }

    public void insert(DocumentStream documentStream) throws MultiOpException {
        documentStream.forEach(this::insert);
    }

    public void insert(DocumentStream documentStream, FieldPath fieldPath) throws MultiOpException {
        documentStream.forEach(document -> this.insert(document.getValue(fieldPath), (Document)document));
    }

    public void insert(DocumentStream documentStream, String string) throws MultiOpException {
        documentStream.forEach(document -> this.insert(document.getValue(string), (Document)document));
    }

    public void replace(String string, Document document) throws StoreException {
        this.delete(string);
        this.documents.add(document);
    }

    public void replace(Value value, Document document) throws StoreException {
        this.replace(value.getString(), document);
    }

    public void replace(Document document) throws StoreException {
        this.replace(document.getId(), document);
    }

    public void replace(Document document, FieldPath fieldPath) throws StoreException {
        this.replace(document.getValue(fieldPath), document);
    }

    public void replace(Document document, String string) throws StoreException {
        this.replace(document.getValue(string), document);
    }

    public void replace(DocumentStream documentStream) throws MultiOpException {
        documentStream.forEach(this::replace);
    }

    public void replace(DocumentStream documentStream, FieldPath fieldPath) throws MultiOpException {
        documentStream.forEach(document -> this.replace(document.getValue(fieldPath), (Document)document));
    }

    public void replace(DocumentStream documentStream, String string) throws MultiOpException {
        documentStream.forEach(document -> this.replace(document.getValue(string), (Document)document));
    }

    public void increment(String string, String string2, byte by) throws StoreException {
        Document document = this.findById(string);
        if (document != null) {
            if (document.getValue(string2) == null) {
                document.set(string2, by);
            } else if (document.getValue(string2).getType() == Value.Type.BYTE) {
                byte by2 = document.getByte(string2);
                by2 = (byte)(by2 + by);
                document.set(string2, by2);
            }
        }
    }

    public void increment(String string, String string2, short s) throws StoreException {
        Document document = this.findById(string);
        if (document != null) {
            if (document.getValue(string2) == null) {
                document.set(string2, s);
            } else if (document.getValue(string2).getType() == Value.Type.SHORT) {
                short s2 = document.getShort(string2);
                s2 = (short)(s2 + s);
                document.set(string2, s2);
            }
        }
    }

    public void increment(String string, String string2, int n) throws StoreException {
        Document document = this.findById(string);
        if (document != null) {
            if (document.getValue(string2) == null) {
                document.set(string2, n);
            } else if (document.getValue(string2).getType() == Value.Type.INT) {
                int n2 = document.getInt(string2);
                document.set(string2, n2 += n);
            }
        }
    }

    public void increment(String string, String string2, long l) throws StoreException {
        Document document = this.findById(string);
        if (document != null) {
            if (document.getValue(string2) == null) {
                document.set(string2, l);
            } else if (document.getValue(string2).getType() == Value.Type.LONG) {
                long l2 = document.getLong(string2);
                document.set(string2, l2 += l);
            }
        }
    }

    public void increment(String string, String string2, float f) throws StoreException {
        Document document = this.findById(string);
        if (document != null) {
            if (document.getValue(string2) == null) {
                document.set(string2, f);
            } else if (document.getValue(string2).getType() == Value.Type.FLOAT) {
                float f2 = document.getFloat(string2);
                document.set(string2, f2 += f);
            }
        }
    }

    public void increment(String string, String string2, double d) throws StoreException {
        Document document = this.findById(string);
        if (document != null) {
            if (document.getValue(string2) == null) {
                document.set(string2, d);
            } else if (document.getValue(string2).getType() == Value.Type.DOUBLE) {
                double d2 = document.getDouble(string2);
                document.set(string2, d2 += d);
            }
        }
    }

    public void increment(String string, String string2, BigDecimal bigDecimal) throws StoreException {
        Document document = this.findById(string);
        if (document != null) {
            if (document.getValue(string2) == null) {
                document.set(string2, bigDecimal);
            } else if (document.getValue(string2).getType() == Value.Type.DECIMAL) {
                BigDecimal bigDecimal2 = document.getDecimal(string2);
                document.set(string2, bigDecimal2.add(bigDecimal));
            }
        }
    }

    public void increment(Value value, String string, byte by) throws StoreException {
        this.increment(value.getString(), string, by);
    }

    public void increment(Value value, String string, short s) throws StoreException {
        this.increment(value.getString(), string, s);
    }

    public void increment(Value value, String string, int n) throws StoreException {
        this.increment(value.getString(), string, n);
    }

    public void increment(Value value, String string, long l) throws StoreException {
        this.increment(value.getString(), string, l);
    }

    public void increment(Value value, String string, float f) throws StoreException {
        this.increment(value.getString(), string, f);
    }

    public void increment(Value value, String string, double d) throws StoreException {
        this.increment(value.getString(), string, d);
    }

    public void increment(Value value, String string, BigDecimal bigDecimal) throws StoreException {
        this.increment(value.getString(), string, bigDecimal);
    }

    private boolean checkAndApply(String string, QueryCondition queryCondition, Consumer<Document> consumer) {
        Document document = this.findById(string, queryCondition);
        if (document != null) {
            consumer.accept(document);
            return true;
        }
        return false;
    }

    public boolean checkAndMutate(String string, QueryCondition queryCondition, DocumentMutation documentMutation) throws StoreException {
        return this.checkAndApply(string, queryCondition, document -> this.update(string, documentMutation));
    }

    public boolean checkAndMutate(Value value, QueryCondition queryCondition, DocumentMutation documentMutation) throws StoreException {
        return this.checkAndMutate(value.getString(), queryCondition, documentMutation);
    }

    public boolean checkAndDelete(String string, QueryCondition queryCondition) throws StoreException {
        return this.checkAndApply(string, queryCondition, document -> this.delete(string));
    }

    public boolean checkAndDelete(Value value, QueryCondition queryCondition) throws StoreException {
        return this.checkAndDelete(value.getString(), queryCondition);
    }

    public boolean checkAndReplace(String string, QueryCondition queryCondition, Document document2) throws StoreException {
        return this.checkAndApply(string, queryCondition, document -> this.replace(string, (Document)document));
    }

    public boolean checkAndReplace(Value value, QueryCondition queryCondition, Document document) throws StoreException {
        return this.checkAndReplace(value.getString(), queryCondition, document);
    }

    public void close() throws StoreException {
        if (this.clearStoreOnClose) {
            this.documents.clear();
        }
    }

    private void checkId(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("Missing _id");
        }
    }

    private void checkId(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Missing _id");
        }
    }

    private void setFromValue(String string, Value value, Document document) {
        switch (value.getType()) {
            case BOOLEAN: {
                value.getBoolean();
                break;
            }
            case STRING: {
                document.set(string, value.getString());
                break;
            }
            case BYTE: {
                document.set(string, value.getByte());
                break;
            }
            case SHORT: {
                document.set(string, value.getShort());
                break;
            }
            case INT: {
                document.set(string, value.getInt());
                break;
            }
            case LONG: {
                document.set(string, value.getLong());
                break;
            }
            case FLOAT: {
                document.set(string, value.getFloat());
                break;
            }
            case DOUBLE: {
                document.set(string, value.getDouble());
                break;
            }
            case DECIMAL: {
                document.set(string, value.getDecimal());
                break;
            }
            case DATE: {
                document.set(string, value.getDate());
                break;
            }
            case TIME: {
                document.set(string, value.getTime());
                break;
            }
            case TIMESTAMP: {
                document.set(string, value.getTimestamp());
                break;
            }
            case INTERVAL: {
                document.set(string, value.getInterval());
                break;
            }
            case BINARY: {
                document.set(string, value.getBinary());
                break;
            }
            case MAP: {
                document.set(string, value.getMap());
                break;
            }
            case ARRAY: {
                document.set(string, value.getList());
                break;
            }
            case NULL: {
                document.delete(string);
            }
        }
    }

    private void mutationAppend(String string, MutationOp mutationOp, Document document) {
        String string2 = mutationOp.getFieldPath().asPathString();
        if (mutationOp.getOpValue().getType() == Value.Type.STRING) {
            String string3 = mutationOp.getOpValue().getString();
            String string4 = document.getString(string2) + string3;
            document.set(string2, string4);
        } else {
            List<Object> list = this.getValueToAppend(mutationOp.getOpValue());
            List<Object> list2 = this.getValueToAppend(document.getValue(string2));
            List list3 = Stream.of(list2, list).flatMap(Collection::stream).collect(Collectors.toList());
            document.set(string2, list3);
        }
        this.insert(string, document);
    }

    private void mutationDelete(String string, MutationOp mutationOp, Document document) {
        document.delete(mutationOp.getFieldPath());
        this.insert(string, document);
    }

    private void mutationIncrement(String string, MutationOp mutationOp, Document document) {
        this.insert(string, document);
        if (mutationOp.getOpValue().getType() == Value.Type.INT) {
            int n = mutationOp.getOpValue().getInt();
            this.increment(string, mutationOp.getFieldPath().asPathString(), n);
        } else if (mutationOp.getOpValue().getType() == Value.Type.BYTE) {
            byte by = mutationOp.getOpValue().getByte();
            this.increment(string, mutationOp.getFieldPath().asPathString(), by);
        } else if (mutationOp.getOpValue().getType() == Value.Type.LONG) {
            long l = mutationOp.getOpValue().getLong();
            this.increment(string, mutationOp.getFieldPath().asPathString(), l);
        } else if (mutationOp.getOpValue().getType() == Value.Type.SHORT) {
            short s = mutationOp.getOpValue().getShort();
            this.increment(string, mutationOp.getFieldPath().asPathString(), s);
        } else if (mutationOp.getOpValue().getType() == Value.Type.FLOAT) {
            float f = mutationOp.getOpValue().getFloat();
            this.increment(string, mutationOp.getFieldPath().asPathString(), f);
        } else if (mutationOp.getOpValue().getType() == Value.Type.DOUBLE) {
            double d = mutationOp.getOpValue().getDouble();
            this.increment(string, mutationOp.getFieldPath().asPathString(), d);
        } else if (mutationOp.getOpValue().getType() == Value.Type.DECIMAL) {
            byte by = mutationOp.getOpValue().getByte();
            this.increment(string, mutationOp.getFieldPath().asPathString(), by);
        }
    }

    private int index(String string) {
        int n = -1;
        for (Document document : this.documents) {
            ++n;
            if (!document.getIdString().equals(string)) continue;
            return n;
        }
        return -1;
    }

    private int index(Value value) {
        int n = -1;
        for (Document document : this.documents) {
            ++n;
            if (!document.getId().equals(value)) continue;
            return n;
        }
        return -1;
    }

    private List<Object> getValueToAppend(Value value) {
        if (value.getType() == Value.Type.BINARY) {
            byte[] byArray = value.getBinary().array();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (byte by : byArray) {
                arrayList.add(by);
            }
            return arrayList;
        }
        return value.getList();
    }

    private Document project(Document document, String ... stringArray) {
        return new MultiPathProjector(document, this.connection).projectPath(stringArray);
    }
}

