/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.contrib.json.JsonLayoutBase;
import com.google.cloud.logging.HttpRequestContext;
import com.google.cloud.logging.TraceContext;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GoogleCloudLoggingV2Layout
extends JsonLayoutBase<ILoggingEvent> {
    private static final String TRACE_ID_FIELD_KEY = "logging.googleapis.com/trace";
    private static final String SPAN_ID_FIELD_KEY = "logging.googleapis.com/spanId";
    private static final String SOURCE_LOCATION_FIELD_KEY = "logging.googleapis.com/sourceLocation";
    private final ThrowableProxyConverter tpc;
    private String serviceName;
    private String serviceVersion;
    private boolean addTraceFields;
    private boolean addHttpRequestFields;
    private Map<String, String> _serviceContext;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public boolean getAddTraceFields() {
        return this.addTraceFields;
    }

    public void setAddTraceFields(boolean addTraceFields) {
        this.addTraceFields = addTraceFields;
    }

    public boolean getAddHttpRequestFields() {
        return this.addHttpRequestFields;
    }

    public void setAddHttpRequestFields(boolean addHttpRequestFields) {
        this.addHttpRequestFields = addHttpRequestFields;
    }

    public GoogleCloudLoggingV2Layout() {
        this("default", "default", true, true);
    }

    public GoogleCloudLoggingV2Layout(String serviceName, String serviceVersion, boolean addTraceFields, boolean addHttpRequestFields) {
        this.serviceName = serviceName;
        this.serviceVersion = serviceVersion;
        this.addTraceFields = addTraceFields;
        this.addHttpRequestFields = addHttpRequestFields;
        this.tpc = new ThrowableProxyConverter();
        this.tpc.setOptionList(Collections.singletonList("full"));
    }

    public void start() {
        this.tpc.start();
        super.start();
    }

    public void stop() {
        this.tpc.stop();
        super.stop();
    }

    protected Map toJsonMap(ILoggingEvent event) {
        Map<String, Object> sourceLocation;
        HashMap<String, Object> builder = new HashMap<String, Object>(2);
        builder.put("severity", GoogleCloudLoggingV2Layout.getSeverity(event));
        builder.put("timestamp", GoogleCloudLoggingV2Layout.getTime(event));
        builder.put("serviceContext", this.getServiceContext());
        builder.put("message", this.getMessage(event));
        if (this.addTraceFields || this.addHttpRequestFields) {
            TraceContext traceCtx = null;
            HttpRequestContext reqCtx = null;
            if (event.getArgumentArray() != null) {
                for (Object arg : event.getArgumentArray()) {
                    if (arg instanceof TraceContext) {
                        traceCtx = (TraceContext)arg;
                    }
                    if (!(arg instanceof HttpRequestContext)) continue;
                    reqCtx = (HttpRequestContext)arg;
                }
            }
            if (traceCtx != null) {
                if (!GoogleCloudLoggingV2Layout.isNullOrEmpty(traceCtx.getTraceId())) {
                    builder.put(TRACE_ID_FIELD_KEY, traceCtx.getTraceId());
                }
                if (!GoogleCloudLoggingV2Layout.isNullOrEmpty(traceCtx.getSpanId())) {
                    builder.put(SPAN_ID_FIELD_KEY, traceCtx.getSpanId());
                }
            }
            if (reqCtx != null) {
                builder.put("httpRequest", reqCtx.getFields());
            }
        }
        if (event.getMDCPropertyMap() != null && !event.getMDCPropertyMap().isEmpty()) {
            builder.put("details", event.getMDCPropertyMap());
        }
        if ((sourceLocation = GoogleCloudLoggingV2Layout.getSourceLocation(event)) != null && !sourceLocation.isEmpty()) {
            builder.put(SOURCE_LOCATION_FIELD_KEY, sourceLocation);
        }
        builder.put("thread", event.getThreadName());
        builder.put("logger", event.getLoggerName());
        return builder;
    }

    Map<String, String> getServiceContext() {
        if (this._serviceContext == null) {
            HashMap<String, String> serviceContext = new HashMap<String, String>(2);
            serviceContext.put("service", this.serviceName);
            serviceContext.put("version", this.serviceVersion);
            this._serviceContext = serviceContext;
        }
        return this._serviceContext;
    }

    String getMessage(ILoggingEvent event) {
        String message = event.getFormattedMessage();
        String stackTrace = this.tpc.convert(event);
        if (!GoogleCloudLoggingV2Layout.isNullOrEmpty(stackTrace)) {
            return message + "\n" + stackTrace;
        }
        return message;
    }

    static Map<String, Object> getSourceLocation(ILoggingEvent event) {
        StackTraceElement[] cda = event.getCallerData();
        HashMap<String, Object> sourceLocation = new HashMap<String, Object>();
        if (cda != null && cda.length > 0) {
            StackTraceElement ste = cda[0];
            sourceLocation.put("function", ste.getClassName() + "." + ste.getMethodName() + (ste.isNativeMethod() ? "(Native Method)" : ""));
            if (ste.getFileName() != null) {
                String pkg = ste.getClassName().replaceAll("\\.", "/");
                pkg = pkg.substring(0, pkg.lastIndexOf("/") + 1);
                sourceLocation.put("file", pkg + ste.getFileName());
            }
            sourceLocation.put("line", ste.getLineNumber());
        } else {
            sourceLocation.put("file", "?");
            sourceLocation.put("line", -1);
            sourceLocation.put("function", "?");
        }
        return sourceLocation;
    }

    static Map<String, Object> getTime(ILoggingEvent event) {
        HashMap<String, Object> time = new HashMap<String, Object>();
        Instant ts = Instant.ofEpochMilli(event.getTimeStamp());
        time.put("seconds", ts.getEpochSecond());
        time.put("nanos", ts.getNano());
        return time;
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static String getSeverity(ILoggingEvent event) {
        Level level = event.getLevel();
        if (level == Level.ALL) {
            return "DEBUG";
        }
        if (level == Level.TRACE) {
            return "DEBUG";
        }
        if (level == Level.DEBUG) {
            return "DEBUG";
        }
        if (level == Level.INFO) {
            return "INFO";
        }
        if (level == Level.WARN) {
            return "WARNING";
        }
        if (level == Level.ERROR) {
            return "ERROR";
        }
        return "DEFAULT";
    }
}

