/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpRequestContext {
    private final Map<String, Object> fields;

    public HttpRequestContext() {
        this(new LinkedHashMap<String, Object>());
    }

    public HttpRequestContext(Map<String, Object> fields) {
        this.fields = fields;
    }

    public HttpRequestContext(HttpServletRequest request, HttpServletResponse response) {
        this();
        if (request != null) {
            this.put("requestMethod", request.getMethod());
            this.put("requestUrl", HttpRequestContext.getRequestUrl(request));
            this.put("requestSize", String.valueOf(request.getContentLengthLong()));
            this.put("userAgent", request.getHeader("user-agent"));
            this.put("remoteIp", request.getHeader("X-Forwarded-For"));
            this.put("referer", request.getHeader("Referer"));
            this.put("protocol", request.getProtocol());
        }
        if (response != null) {
            this.put("status", String.valueOf(response.getStatus()));
        }
    }

    public void setLatency(double latencySeconds) {
        this.put("latency", String.valueOf(latencySeconds) + "s");
    }

    public void setCacheLookup(boolean cacheLookup) {
        this.put("cacheLookup", cacheLookup);
    }

    public void setCacheHit(boolean cacheHit) {
        this.put("cacheHit", cacheHit);
    }

    public void setCacheValidatedWithOriginServer(boolean cacheValidatedWithOriginServer) {
        this.put("cacheValidatedWithOriginServer", cacheValidatedWithOriginServer);
    }

    public void setCacheFillBytes(long cacheFillBytes) {
        this.put("cacheFillBytes", String.valueOf(cacheFillBytes));
    }

    public Object put(String key, Object value) {
        return this.fields.put(key, value);
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    private static String getRequestUrl(HttpServletRequest req) {
        String scheme = req.getScheme();
        int port = req.getServerPort();
        StringBuilder url = new StringBuilder(256);
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (!("http".equals(scheme) && (port == 0 || port == 80) || "https".equals(scheme) && port == 443)) {
            url.append(':');
            url.append(port);
        }
        url.append(req.getRequestURI());
        String qs = req.getQueryString();
        if (qs != null) {
            url.append('?');
            url.append(qs);
        }
        return url.toString();
    }
}

