/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.config;

import com.github.jaemon.dinger.core.DingerConfigurerAdapter;
import com.github.jaemon.dinger.core.DingerManagerBuilder;
import com.github.jaemon.dinger.core.DingerRobot;
import com.github.jaemon.dinger.core.entity.DingerProperties;
import com.github.jaemon.dinger.exception.ConfigurationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DingerRobot.class})
@EnableConfigurationProperties(value={DingerProperties.class})
public class DingerConfiguration {
    @Autowired
    private DingerProperties dingerProperties;

    @Bean
    @ConditionalOnMissingBean(value={DingerConfigurerAdapter.class})
    public DingerConfigurerAdapter dingerConfigurerAdapter() {
        return new DingerConfigurerAdapter();
    }

    @Bean
    public DingerManagerBuilder dingerManagerBuilder() {
        return new DingerManagerBuilder();
    }

    @Bean
    public DingerRobot dingerSender(DingerConfigurerAdapter dingerConfigurerAdapter, DingerManagerBuilder dingerManagerBuilder) {
        try {
            dingerConfigurerAdapter.configure(dingerManagerBuilder);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
        return new DingerRobot(this.dingerProperties, dingerManagerBuilder);
    }
}

