/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.core.DingerDefinition;
import com.github.jaemon.dinger.core.DingerDefinitionGenerator;
import com.github.jaemon.dinger.core.DingerDefinitionGeneratorContext;
import com.github.jaemon.dinger.core.DingerDefinitionGeneratorFactory;
import com.github.jaemon.dinger.core.annatations.DingerImageText;
import com.github.jaemon.dinger.core.annatations.DingerLink;
import com.github.jaemon.dinger.core.annatations.DingerScan;
import com.github.jaemon.dinger.core.annatations.Parameter;
import com.github.jaemon.dinger.core.entity.enums.DingerDefinitionType;
import com.github.jaemon.dinger.core.entity.enums.DingerType;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.listeners.DingerListenersProperty;
import com.github.jaemon.dinger.utils.DingerUtils;
import com.github.jaemon.dinger.utils.PackageUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class AbstractDingerDefinitionResolver
extends DingerListenersProperty {
    private static final Logger log = LoggerFactory.getLogger(AbstractDingerDefinitionResolver.class);
    protected Map<String, Class<? extends DingerDefinitionGenerator>> dingerDefinitionGeneratorMap = new HashMap<String, Class<? extends DingerDefinitionGenerator>>();
    protected Map<DingerType, DingerConfig> defaultDingerConfigs = new HashMap<DingerType, DingerConfig>();

    public AbstractDingerDefinitionResolver() {
        for (DingerDefinitionType dingerDefinitionType : DingerDefinitionType.dingerDefinitionTypes) {
            this.dingerDefinitionGeneratorMap.put((Object)((Object)dingerDefinitionType.dingerType()) + "." + (Object)((Object)dingerDefinitionType.messageMainType()) + "." + (Object)((Object)dingerDefinitionType.messageSubType()), dingerDefinitionType.dingerDefinitionGenerator());
        }
    }

    abstract void analysisDingerXml(Resource[] var1) throws Exception;

    abstract void analysisDingerAnnotation(List<Class<?>> var1) throws Exception;

    protected void dingerXmlResolver(String dingerLocations) throws Exception {
        boolean debugEnabled = log.isDebugEnabled();
        if (dingerLocations == null) {
            if (debugEnabled) {
                log.debug("dinger xml is not configured.");
            }
            return;
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources(dingerLocations);
        if (resources.length == 0) {
            log.warn("dinger xml is empty under {}.", (Object)dingerLocations);
            return;
        }
        this.analysisDingerXml(resources);
    }

    protected List<Class<?>> dingerAnnotationResolver() throws Exception {
        boolean debugEnabled = log.isDebugEnabled();
        DingerScan dingerScan = null;
        ArrayList dingerClasses = new ArrayList();
        for (Class<?> primarySource : DingerListenersProperty.primarySources()) {
            if (debugEnabled) {
                log.debug("ready to analysis primarySource[{}].", (Object)primarySource.getName());
            }
            if (!primarySource.isAnnotationPresent(DingerScan.class)) continue;
            if (dingerScan == null) {
                dingerScan = primarySource.getAnnotation(DingerScan.class);
                continue;
            }
            throw new DingerException(ExceptionEnum.MULTI_DINGER_SCAN_ERROR);
        }
        if (dingerScan != null) {
            String[] basePackages;
            for (String basePackage : basePackages = dingerScan.basePackages()) {
                if (debugEnabled) {
                    log.debug("ready to scan package[{}] for Dinger.", (Object)basePackage);
                }
                PackageUtils.classNames(basePackage, dingerClasses, true, new Class[0]);
            }
        } else {
            log.warn("annotation dingerScan is not configured and will execute Dinger scanner registrar.");
        }
        if (dingerClasses.isEmpty()) {
            if (debugEnabled) {
                log.debug("annotation dinger class is empty.");
            }
            return dingerClasses;
        }
        this.analysisDingerAnnotation(dingerClasses);
        return dingerClasses;
    }

    void registerDingerDefinition(String dingerName, Object source, String dingerDefinitionKey, DingerConfig dingerConfiguration, DingerMethod dingerMethod) {
        boolean debugEnabled = log.isDebugEnabled();
        for (DingerType dingerType : enabledDingerTypes) {
            DingerConfig defaultDingerConfig = this.defaultDingerConfigs.get((Object)dingerType);
            if (dingerConfiguration == null) {
                if (!debugEnabled) continue;
                log.debug("dinger={} not open and skip the corresponding dinger registration.", (Object)dingerType);
                continue;
            }
            String keyName = (Object)((Object)dingerType) + "." + dingerName;
            String key = (Object)((Object)dingerType) + "." + dingerDefinitionKey;
            Class<? extends DingerDefinitionGenerator> dingerDefinitionGeneratorClass = this.dingerDefinitionGeneratorMap.get(key);
            if (dingerDefinitionGeneratorClass == null) {
                if (!debugEnabled) continue;
                log.debug("\u5f53\u524dkey=%s\u5728DingerDefinitionType\u4e2d\u6ca1\u5b9a\u4e49", (Object)key);
                continue;
            }
            DingerDefinitionGenerator dingerDefinitionGenerator = DingerDefinitionGeneratorFactory.get(dingerDefinitionGeneratorClass.getName());
            DingerDefinition dingerDefinition = dingerDefinitionGenerator.generator(new DingerDefinitionGeneratorContext<Object>(keyName, source));
            if (dingerDefinition == null) {
                if (!debugEnabled) continue;
                log.debug("keyName={} dinger[{}] format is illegal.", (Object)keyName, (Object)dingerDefinitionKey);
                continue;
            }
            if (Container.INSTANCE.contains(keyName)) {
                throw new DingerException(ExceptionEnum.DINGER_REPEATED_EXCEPTION, keyName);
            }
            if (dingerMethod.check()) {
                throw new DingerException(ExceptionEnum.METHOD_DEFINITION_EXCEPTION, dingerMethod.methodName);
            }
            dingerDefinition.setMethodParams(dingerMethod.methodParams);
            dingerDefinition.setGenericIndex(dingerMethod.paramTypes);
            dingerDefinition.dingerConfig().merge(dingerConfiguration).merge(defaultDingerConfig);
            Container.INSTANCE.put(keyName, dingerDefinition);
            if (!debugEnabled) continue;
            log.debug("dinger definition={} has been registed.", (Object)keyName);
        }
    }

    protected Map<String, DingerMethod> dingerClassMethods(Class<?> dingerClass) {
        Method[] methods = dingerClass.getMethods();
        HashMap<String, DingerMethod> dingerMethodParams = new HashMap<String, DingerMethod>();
        for (Method method : methods) {
            String methodName = method.getName();
            String methodAllName = dingerClass.getSimpleName() + "." + methodName;
            int[] paramTypes = null;
            if (method.isAnnotationPresent(DingerImageText.class)) {
                paramTypes = DingerUtils.methodParamsGenericType(method, DingerImageText.clazz);
                if (paramTypes.length != 1) {
                    throw new DingerException(ExceptionEnum.IMAGETEXT_METHOD_PARAM_EXCEPTION, methodAllName);
                }
            } else if (method.isAnnotationPresent(DingerLink.class) && (paramTypes = DingerUtils.methodParamsType(method, DingerLink.clazz)).length != 1) {
                throw new DingerException(ExceptionEnum.LINK_METHOD_PARAM_EXCEPTION, methodAllName);
            }
            String[] methodParams = this.methodParams(method);
            dingerMethodParams.put(methodName, new DingerMethod(methodAllName, methodParams, paramTypes));
        }
        return dingerMethodParams;
    }

    protected String[] methodParams(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        java.lang.reflect.Parameter[] parameters = method.getParameters();
        String[] params = new String[parameterAnnotations.length];
        block0: for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] parameterAnnotation = parameterAnnotations[i];
            params[i] = parameters[i].getName();
            for (Annotation annotation : parameterAnnotation) {
                if (!Parameter.class.isInstance(annotation)) continue;
                Parameter dingerParam = (Parameter)annotation;
                params[i] = dingerParam.value();
                continue block0;
            }
        }
        return params;
    }

    protected static void clear() {
        Container.INSTANCE.container.clear();
    }

    String transferXml(String sourceXml) {
        return sourceXml.replaceAll("<!DOCTYPE.*>", "");
    }

    protected static enum Container {
        INSTANCE;

        private Map<String, DingerDefinition> container = new HashMap<String, DingerDefinition>(128);

        DingerDefinition get(String key) {
            return this.container.get(key);
        }

        void put(String key, DingerDefinition dingerDefinition) {
            this.container.put(key, dingerDefinition);
        }

        boolean contains(String key) {
            return this.container.containsKey(key);
        }
    }

    static class DingerMethod {
        String methodName;
        String[] methodParams;
        int[] paramTypes;

        public DingerMethod(String methodName, String[] methodParams, int[] paramTypes) {
            this.methodName = methodName;
            this.methodParams = methodParams;
            this.paramTypes = paramTypes;
        }

        boolean check() {
            if (this.paramTypes == null) {
                return false;
            }
            int length = this.methodParams.length;
            for (int index : this.paramTypes) {
                if (index < length) continue;
                return true;
            }
            return false;
        }
    }
}

