/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.AbstractDingerDefinitionResolver;
import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.core.annatations.AsyncExecute;
import com.github.jaemon.dinger.core.annatations.DingerConfiguration;
import com.github.jaemon.dinger.core.annatations.DingerImageText;
import com.github.jaemon.dinger.core.annatations.DingerLink;
import com.github.jaemon.dinger.core.annatations.DingerMarkdown;
import com.github.jaemon.dinger.core.annatations.DingerText;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.core.entity.enums.MessageMainType;
import com.github.jaemon.dinger.core.entity.enums.MessageSubType;
import com.github.jaemon.dinger.core.entity.xml.BeanTag;
import com.github.jaemon.dinger.core.entity.xml.MessageTag;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.utils.DingerUtils;
import com.github.jaemon.dinger.utils.XmlUtils;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class DingerDefinitionResolver
extends AbstractDingerDefinitionResolver {
    private static final Logger log = LoggerFactory.getLogger(DingerDefinitionResolver.class);
    protected static final String DINGER_PROPERTIES_PREFIX = "spring.dinger.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Class<?>> doAnalysis(ApplicationEnvironmentPreparedEvent event) throws Exception {
        try {
            ConfigurableEnvironment environment = event.getEnvironment();
            String DingerLocationsProp = "spring.dinger.dinger-locations";
            String dingerLocations = environment.getProperty(DingerLocationsProp);
            this.dingerXmlResolver(dingerLocations);
            List<Class<?>> list = this.dingerAnnotationResolver();
            return list;
        }
        finally {
            this.defaultDingerConfigs.clear();
            this.defaultDingerConfigs = null;
            this.dingerDefinitionGeneratorMap.clear();
            this.dingerDefinitionGeneratorMap = null;
        }
    }

    @Override
    synchronized void analysisDingerXml(Resource[] resources) throws Exception {
        boolean debugEnabled = log.isDebugEnabled();
        for (Resource resource : resources) {
            if (!resource.isReadable()) {
                if (!debugEnabled) continue;
                log.debug("Ignored because not readable: {} ", (Object)resource.getFilename());
                continue;
            }
            String xml = new String(FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream()), "UTF-8");
            BeanTag dingerBean = XmlUtils.xmlToJavaBean(xml = this.transferXml(xml), BeanTag.class);
            if (dingerBean == null) {
                if (!debugEnabled) continue;
                log.debug("dinger xml file: {} content is empty.", (Object)resource.getFilename());
                continue;
            }
            String namespace = dingerBean.getNamespace();
            Class<?> dingerClass = Class.forName(namespace);
            if (dingerClass == null) {
                throw new DingerException(ExceptionEnum.DINER_XML_NAMESPACE_INVALID, namespace);
            }
            Map<String, AbstractDingerDefinitionResolver.DingerMethod> dingerClassMethods = this.dingerClassMethods(dingerClass);
            DingerConfig dingerConfiguration = this.dingerConfiguration(dingerClass);
            List<MessageTag> messages = dingerBean.getMessages();
            for (MessageTag message : messages) {
                String methodName = message.getIdentityId();
                if (!dingerClassMethods.containsKey(methodName)) {
                    log.warn("namespace={}, messageId={} undefined in dingerClass.", (Object)namespace, (Object)methodName);
                    continue;
                }
                String dingerName = namespace + "." + methodName;
                String messageSubType = message.getDingerType();
                if (!MessageSubType.contains(messageSubType)) {
                    throw new DingerException(ExceptionEnum.DINER_XML_MSGTYPE_INVALID, dingerName, messageSubType);
                }
                String dingerDefinitionKey = (Object)((Object)MessageMainType.XML) + "." + message.getDingerType();
                this.registerDingerDefinition(dingerName, message, dingerDefinitionKey, dingerConfiguration, dingerClassMethods.get(methodName));
            }
        }
    }

    @Override
    synchronized void analysisDingerAnnotation(List<Class<?>> dingerClasses) throws Exception {
        for (Class<?> dingerClass : dingerClasses) {
            Method[] methods;
            DingerConfig dingerConfiguration = this.dingerConfiguration(dingerClass);
            String namespace = dingerClass.getName();
            for (Method method : methods = dingerClass.getMethods()) {
                MessageSubType messageSubType;
                Annotation source;
                String dingerName = namespace + "." + method.getName();
                String dingerDefinitionKey = (Object)((Object)MessageMainType.ANNOTATION) + ".";
                int[] paramTypes = null;
                if (method.isAnnotationPresent(DingerText.class)) {
                    source = method.getAnnotation(DingerText.class);
                    messageSubType = MessageSubType.TEXT;
                } else if (method.isAnnotationPresent(DingerMarkdown.class)) {
                    source = method.getAnnotation(DingerMarkdown.class);
                    messageSubType = MessageSubType.MARKDOWN;
                } else if (method.isAnnotationPresent(DingerImageText.class)) {
                    paramTypes = DingerUtils.methodParamsGenericType(method, DingerImageText.clazz);
                    if (paramTypes.length != 1) {
                        throw new DingerException(ExceptionEnum.IMAGETEXT_METHOD_PARAM_EXCEPTION, dingerName);
                    }
                    source = method.getAnnotation(DingerImageText.class);
                    messageSubType = MessageSubType.IMAGETEXT;
                } else if (method.isAnnotationPresent(DingerLink.class)) {
                    paramTypes = DingerUtils.methodParamsType(method, DingerLink.clazz);
                    if (paramTypes.length != 1) {
                        throw new DingerException(ExceptionEnum.LINK_METHOD_PARAM_EXCEPTION, dingerName);
                    }
                    source = method.getAnnotation(DingerLink.class);
                    messageSubType = MessageSubType.LINK;
                } else {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("register annotation dingerDefinition and skip method={}(possible use xml definition).", (Object)dingerName);
                    continue;
                }
                this.registerDingerDefinition(dingerName, source, dingerDefinitionKey + (Object)((Object)messageSubType), dingerConfiguration, new AbstractDingerDefinitionResolver.DingerMethod(dingerName, this.methodParams(method), paramTypes));
            }
        }
    }

    private DingerConfig dingerConfiguration(Class<?> dingerClass) {
        DingerConfiguration dingerConfiguration;
        String tokenId;
        DingerConfig dingerConfig = new DingerConfig();
        if (dingerClass.isAnnotationPresent(DingerConfiguration.class) && DingerUtils.isNotEmpty(tokenId = (dingerConfiguration = dingerClass.getAnnotation(DingerConfiguration.class)).tokenId())) {
            dingerConfig.setTokenId(tokenId);
            dingerConfig.setDecryptKey(dingerConfiguration.decryptKey());
            dingerConfig.setSecret(dingerConfiguration.secret());
        }
        if (dingerClass.isAnnotationPresent(AsyncExecute.class)) {
            dingerConfig.setAsyncExecute(true);
        }
        return dingerConfig;
    }
}

