/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.DingerDefinition;
import com.github.jaemon.dinger.core.DingerHelper;
import com.github.jaemon.dinger.core.DingerMessageHandler;
import com.github.jaemon.dinger.core.DingerRobot;
import com.github.jaemon.dinger.core.annatations.DingerClose;
import com.github.jaemon.dinger.core.entity.DingerProperties;
import com.github.jaemon.dinger.core.entity.DingerResponse;
import com.github.jaemon.dinger.core.entity.MsgType;
import com.github.jaemon.dinger.core.entity.enums.DingerResponseCodeEnum;
import com.github.jaemon.dinger.core.entity.enums.DingerType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingerHandleProxy
extends DingerMessageHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(DingerHandleProxy.class);
    private static final String DEFAULT_STRING_METHOD = "java.lang.Object.toString";

    public DingerHandleProxy(DingerRobot dingerRobot, DingerProperties dingerProperties) {
        this.dingerRobot = dingerRobot;
        this.dingerProperties = dingerProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> dingerClass = method.getDeclaringClass();
        boolean clzClose = dingerClass.isAnnotationPresent(DingerClose.class);
        if (clzClose) {
            return null;
        }
        boolean methodClose = method.isAnnotationPresent(DingerClose.class);
        if (methodClose) {
            return null;
        }
        String dingerClassName = dingerClass.getName();
        String methodName = method.getName();
        String keyName = dingerClassName + "." + methodName;
        if (DEFAULT_STRING_METHOD.equals(keyName)) {
            return this.toString();
        }
        try {
            DingerResponse dingerResponse;
            DingerType useDinger = this.dingerType(method);
            DingerDefinition dingerDefinition = this.dingerDefinition(useDinger, dingerClassName, keyName);
            if (dingerDefinition == null) {
                dingerResponse = DingerResponse.failed(DingerResponseCodeEnum.MESSAGE_TYPE_UNSUPPORTED, String.format("method %s does not support dinger %s.", new Object[]{keyName, useDinger}));
            } else {
                Map<String, Object> params = this.paramsHandler(method, dingerDefinition, args);
                MsgType message = this.transfer(dingerDefinition, params);
                dingerResponse = this.dingerRobot.send(message);
            }
            Object object = this.resultHandler(method.getReturnType(), dingerResponse);
            return object;
        }
        finally {
            DingerHelper.clearDinger();
        }
    }
}

