/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.AbstractDingerSender;
import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.core.DingerManagerBuilder;
import com.github.jaemon.dinger.core.entity.DingerProperties;
import com.github.jaemon.dinger.core.entity.DingerRequest;
import com.github.jaemon.dinger.core.entity.DingerResponse;
import com.github.jaemon.dinger.core.entity.MsgType;
import com.github.jaemon.dinger.core.entity.enums.DingerResponseCodeEnum;
import com.github.jaemon.dinger.core.entity.enums.DingerType;
import com.github.jaemon.dinger.core.entity.enums.MessageSubType;
import com.github.jaemon.dinger.exception.AsyncCallException;
import com.github.jaemon.dinger.exception.SendMsgException;
import com.github.jaemon.dinger.support.CustomMessage;
import com.github.jaemon.dinger.support.client.MediaTypeEnum;
import com.github.jaemon.dinger.support.sign.SignBase;
import com.github.jaemon.dinger.utils.DingerUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public class DingerRobot
extends AbstractDingerSender {
    public DingerRobot(DingerProperties dingerProperties, DingerManagerBuilder dingTalkManagerBuilder) {
        super(dingerProperties, dingTalkManagerBuilder);
    }

    @Override
    public DingerResponse send(MessageSubType messageSubType, DingerRequest request) {
        return this.send(this.dingerProperties.getDefaultDinger(), messageSubType, request);
    }

    @Override
    public DingerResponse send(DingerType dingerType, MessageSubType messageSubType, DingerRequest request) {
        if (!messageSubType.isSupport()) {
            return DingerResponse.failed(DingerResponseCodeEnum.MESSAGE_TYPE_UNSUPPORTED);
        }
        CustomMessage customMessage = this.customMessage(messageSubType);
        String msgContent = customMessage.message(this.dingerProperties.getProjectId(), request);
        request.setContent(msgContent);
        MsgType msgType = messageSubType.msgType(dingerType, request);
        return this.send(msgType);
    }

    protected <T extends MsgType> DingerResponse send(T message) {
        DingerType dingerType = message.getDingerType();
        String dkid = this.dingTalkManagerBuilder.dingerIdGenerator.dingerId();
        Map<DingerType, DingerProperties.Dinger> dingers = this.dingerProperties.getDingers();
        if (!this.dingerProperties.isEnabled() || !dingers.containsKey((Object)dingerType)) {
            return DingerResponse.failed(dkid, DingerResponseCodeEnum.DINGER_DISABLED);
        }
        DingerConfig localDinger = DingerRobot.getLocalDinger();
        boolean dingerConfig = localDinger != null;
        try {
            DingerProperties.Dinger dinger;
            if (dingerConfig) {
                dinger = new DingerProperties.Dinger();
                BeanUtils.copyProperties((Object)localDinger, (Object)dinger);
                dinger.setAsync(localDinger.getAsyncExecute());
                dinger.setRobotUrl(dingers.get((Object)dingerType).getRobotUrl());
            } else {
                dinger = dingers.get((Object)dingerType);
            }
            StringBuilder webhook = new StringBuilder();
            webhook.append(dinger.getRobotUrl()).append("=").append(dinger.getTokenId());
            if (log.isDebugEnabled()) {
                log.debug("dingerId={} send message and use dinger={}, tokenId={}.", new Object[]{dkid, dingerType, dinger.getTokenId()});
            }
            if (dingerType == DingerType.DINGTALK && DingerUtils.isNotEmpty(dinger.getSecret())) {
                Object sign = this.dingTalkManagerBuilder.dingerSignAlgorithm.sign(dinger.getSecret().trim());
                webhook.append(((SignBase)sign).transfer());
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", MediaTypeEnum.JSON.type());
            if (dinger.isAsync()) {
                this.dingTalkManagerBuilder.dingTalkExecutor.execute(() -> {
                    try {
                        String result = this.dingTalkManagerBuilder.dingerHttpClient.post(webhook.toString(), (Map<String, String>)headers, message);
                        this.dingTalkManagerBuilder.dingerAsyncCallback.execute(dkid, result);
                    }
                    catch (Exception e) {
                        this.exceptionCallback(dkid, message, new AsyncCallException(e));
                    }
                });
                return DingerResponse.success(dkid, dkid);
            }
            String response = this.dingTalkManagerBuilder.dingerHttpClient.post(webhook.toString(), headers, message);
            return DingerResponse.success(dkid, response);
        }
        catch (Exception e) {
            this.exceptionCallback(dkid, message, new SendMsgException(e));
            return DingerResponse.failed(dkid, DingerResponseCodeEnum.SEND_MESSAGE_FAILED);
        }
    }
}

