/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core.spring;

import com.github.jaemon.dinger.core.annatations.DingerScan;
import com.github.jaemon.dinger.core.entity.ExceptionPairs;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.core.spring.DingerFactoryBean;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.listeners.DingerListenersProperty;
import com.github.jaemon.dinger.utils.PackageUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

public class DingerScannerRegistrar
extends DingerListenersProperty
implements ImportBeanDefinitionRegistrar,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(DingerScannerRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        boolean isDebugEnabled = log.isDebugEnabled();
        log.info("ready to execute dingerScanner...");
        List<Class<?>> dingerClasses = DingerListenersProperty.dingerClasses();
        if (!dingerClasses.isEmpty()) {
            this.registerBeanDefinition(registry, dingerClasses);
        } else {
            String[] basePackages;
            if (isDebugEnabled) {
                log.debug("dinger class is empty in primarySources, ready to reanalysis from DingerScan.");
            }
            if (!importingClassMetadata.hasAnnotation(DingerScan.class.getName())) {
                log.warn("import class can't find DingerScan annotation.");
                return;
            }
            AnnotationAttributes annoAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(DingerScan.class.getName()));
            for (String basePackage : basePackages = annoAttrs.getStringArray("basePackages")) {
                PackageUtils.classNames(basePackage, dingerClasses, true, new Class[0]);
            }
            if (!dingerClasses.isEmpty()) {
                this.registerBeanDefinition(registry, dingerClasses);
            } else {
                throw new DingerException("dinger class is empty.", (ExceptionPairs)ExceptionEnum.CONFIG_ERROR);
            }
        }
    }

    private void registerBeanDefinition(BeanDefinitionRegistry registry, List<Class<?>> dingerClasses) {
        for (Class<?> dingerClass : dingerClasses) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DingerFactoryBean.class);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(dingerClass);
            beanDefinition.setAutowireMode(2);
            registry.registerBeanDefinition(dingerClass.getSimpleName(), (BeanDefinition)beanDefinition);
            if (!log.isDebugEnabled()) continue;
            log.debug("the beanDefinition[{}] is already registered.", (Object)dingerClass.getSimpleName());
        }
    }

    public int getOrder() {
        return 0x7FFFFFFD;
    }
}

