/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.listeners;

import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.core.DingerDefinitionResolver;
import com.github.jaemon.dinger.core.annatations.DingerScan;
import com.github.jaemon.dinger.core.entity.ExceptionPairs;
import com.github.jaemon.dinger.core.entity.enums.DingerType;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.exception.DingerAnalysisException;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.listeners.DingerListenersProperty;
import com.github.jaemon.dinger.utils.DingerUtils;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;

public class DingerXmlPreparedEvent
extends DingerDefinitionResolver
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Logger log = LoggerFactory.getLogger(DingerXmlPreparedEvent.class);

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        log.info("ready to execute dinger analysis.");
        this.loadPrimarySources(event);
        this.registerDefaultDingerConfig((Environment)event.getEnvironment());
        try {
            DingerListenersProperty.dingerClasses = this.doAnalysis(event);
        }
        catch (DingerException ex) {
            throw new DingerAnalysisException(ex.getPairs(), ex.getMessage());
        }
        catch (Exception ex) {
            throw new DingerException(ex, (ExceptionPairs)ExceptionEnum.UNKNOWN);
        }
    }

    private void loadPrimarySources(ApplicationEnvironmentPreparedEvent event) {
        Set allSources = SpringBootVersion.getVersion().startsWith("1.") ? event.getSpringApplication().getSources() : event.getSpringApplication().getAllSources();
        HashSet primarySources = new HashSet();
        for (Object source : allSources) {
            Class clazz;
            if (!Class.class.isInstance(source) || !(clazz = (Class)source).isAnnotationPresent(DingerScan.class)) continue;
            primarySources.add(clazz);
        }
        DingerListenersProperty.primarySources = primarySources;
    }

    private void registerDefaultDingerConfig(Environment environment) {
        for (DingerType dingerType : enabledDingerTypes) {
            String dingers = "spring.dinger.dingers." + dingerType.name().toLowerCase() + ".";
            String tokenIdProp = dingers + "token-id";
            String secretProp = dingers + "secret";
            String decryptProp = dingers + "decrypt";
            String decryptKeyProp = dingers + "decryptKey";
            String asyncExecuteProp = dingers + "async";
            if (DingerUtils.isEmpty(tokenIdProp)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("dinger={} is not open.", (Object)dingerType);
                continue;
            }
            String tokenId = environment.getProperty(tokenIdProp);
            String secret = environment.getProperty(secretProp);
            boolean decrypt = this.getProperty(environment, decryptProp);
            boolean async = this.getProperty(environment, asyncExecuteProp);
            DingerConfig defaultDingerConfig = DingerConfig.instance(tokenId);
            defaultDingerConfig.setDingerType(dingerType);
            defaultDingerConfig.setSecret(secret);
            if (decrypt) {
                defaultDingerConfig.setDecryptKey(environment.getProperty(decryptKeyProp));
            }
            defaultDingerConfig.setAsyncExecute(async);
            defaultDingerConfig.check();
            this.defaultDingerConfigs.put(dingerType, defaultDingerConfig);
        }
    }

    private boolean getProperty(Environment environment, String prop) {
        if (environment.getProperty(prop) != null) {
            return (Boolean)environment.getProperty(prop, Boolean.TYPE);
        }
        return false;
    }
}

