/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.multi;

import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.core.entity.ExceptionPairs;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.exception.MultiDingerRegisterException;
import com.github.jaemon.dinger.multi.MultiDingerConfigContainer;
import com.github.jaemon.dinger.multi.MultiDingerScannerRegistrar;
import com.github.jaemon.dinger.multi.algorithm.AlgorithmHandler;
import com.github.jaemon.dinger.multi.entity.MultiDingerAlgorithmDefinition;
import com.github.jaemon.dinger.multi.entity.MultiDingerConfig;
import com.github.jaemon.dinger.utils.DingerUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MultiDingerAlgorithmInjectRegister
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MultiDingerAlgorithmInjectRegister.class);
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (MultiDingerAlgorithmInjectRegister.applicationContext == null) {
            MultiDingerAlgorithmInjectRegister.applicationContext = applicationContext;
        } else {
            log.warn("applicationContext is not null.");
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (MultiDingerScannerRegistrar.MULTIDINGER_ALGORITHM_DEFINITION_MAP.isEmpty()) {
            log.info("AlgorithmHandler Container is Empty.");
            return;
        }
        try {
            this.multiDingerWithInjectAttributeHandler();
        }
        catch (DingerException ex) {
            throw new MultiDingerRegisterException(ex.getPairs(), ex.getMessage());
        }
        catch (Exception ex) {
            throw new DingerException(ex, (ExceptionPairs)ExceptionEnum.UNKNOWN);
        }
    }

    private void multiDingerWithInjectAttributeHandler() {
        boolean debugEnabled = log.isDebugEnabled();
        Set<Map.Entry<String, MultiDingerAlgorithmDefinition>> entries = MultiDingerScannerRegistrar.MULTIDINGER_ALGORITHM_DEFINITION_MAP.entrySet();
        for (Map.Entry<String, MultiDingerAlgorithmDefinition> entry : entries) {
            String beanName = entry.getKey();
            MultiDingerAlgorithmDefinition v = entry.getValue();
            Class<? extends AlgorithmHandler> algorithm = v.getAlgorithm();
            AlgorithmHandler algorithmHandler = (AlgorithmHandler)applicationContext.getBean(beanName, algorithm);
            this.algorithmFieldInjection(algorithm, algorithmHandler);
            List<DingerConfig> dingerConfigs = v.getDingerConfigs();
            MultiDingerConfigContainer.INSTANCE.put(v.getKey(), new MultiDingerConfig(algorithmHandler, dingerConfigs));
            if (!debugEnabled) continue;
            log.debug("dingerClassName={} exist spring inject info and algorithmHandler class={}, dingerConfigs={}.", new Object[]{v.getKey(), algorithm.getSimpleName(), dingerConfigs.size()});
        }
        MultiDingerScannerRegistrar.MULTIDINGER_ALGORITHM_DEFINITION_MAP.clear();
    }

    private void algorithmFieldInjection(Class<? extends AlgorithmHandler> algorithm, AlgorithmHandler algorithmHandler) {
        String algorithmSimpleName = algorithm.getSimpleName();
        for (Field declaredField : algorithm.getDeclaredFields()) {
            String[] actualBeanNames;
            int length;
            Qualifier qualifier;
            if (!declaredField.isAnnotationPresent(Autowired.class)) continue;
            String fieldBeanName = declaredField.getName();
            if (declaredField.isAnnotationPresent(Qualifier.class) && DingerUtils.isNotEmpty((qualifier = declaredField.getAnnotation(Qualifier.class)).value())) {
                fieldBeanName = qualifier.value();
            }
            if ((length = (actualBeanNames = applicationContext.getBeanNamesForType(declaredField.getType())).length) == 1) {
                fieldBeanName = actualBeanNames[0];
            } else if (length > 1) {
                String fbn = fieldBeanName;
                long count = Arrays.stream(actualBeanNames).filter(e -> Objects.equals(e, fbn)).count();
                if (count == 0L) {
                    throw new DingerException(ExceptionEnum.ALGORITHM_FIELD_INSTANCE_NOT_MATCH, algorithmSimpleName, fieldBeanName);
                }
            } else {
                throw new DingerException(ExceptionEnum.ALGORITHM_FIELD_INSTANCE_NOT_EXISTS, algorithmSimpleName, fieldBeanName);
            }
            try {
                declaredField.setAccessible(true);
                declaredField.set(algorithmHandler, applicationContext.getBean(fieldBeanName));
            }
            catch (IllegalAccessException e2) {
                throw new DingerException(ExceptionEnum.ALGORITHM_FIELD_INJECT_FAILED, algorithmSimpleName, fieldBeanName);
            }
        }
    }

    protected static void clear() {
        applicationContext = null;
    }
}

