/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.multi;

import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.core.entity.ExceptionPairs;
import com.github.jaemon.dinger.core.entity.enums.DingerType;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.exception.MultiDingerRegisterException;
import com.github.jaemon.dinger.listeners.DingerListenersProperty;
import com.github.jaemon.dinger.multi.DingerConfigHandler;
import com.github.jaemon.dinger.multi.MultiDingerConfigContainer;
import com.github.jaemon.dinger.multi.MultiDingerProperty;
import com.github.jaemon.dinger.multi.algorithm.AlgorithmHandler;
import com.github.jaemon.dinger.multi.annotations.EnableMultiDinger;
import com.github.jaemon.dinger.multi.annotations.MultiDinger;
import com.github.jaemon.dinger.multi.annotations.MultiHandler;
import com.github.jaemon.dinger.multi.entity.MultiDingerAlgorithmDefinition;
import com.github.jaemon.dinger.multi.entity.MultiDingerConfig;
import com.github.jaemon.dinger.utils.DingerUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.objenesis.instantiator.util.ClassUtils;

public class MultiDingerScannerRegistrar
extends DingerListenersProperty
implements ImportBeanDefinitionRegistrar,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(MultiDingerScannerRegistrar.class);
    protected static final Map<String, MultiDingerAlgorithmDefinition> MULTIDINGER_ALGORITHM_DEFINITION_MAP = new HashMap<String, MultiDingerAlgorithmDefinition>();

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        log.info("ready to execute multiDingerScanner...");
        try {
            this.doScanAndRegister(importingClassMetadata, registry);
        }
        catch (DingerException ex) {
            throw new MultiDingerRegisterException(ex.getPairs(), ex.getMessage());
        }
        catch (Exception ex) {
            throw new DingerException(ex, (ExceptionPairs)ExceptionEnum.UNKNOWN);
        }
        finally {
            MultiDingerScannerRegistrar.emptyDingerClasses();
        }
    }

    private void doScanAndRegister(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        boolean debugEnabled = log.isDebugEnabled();
        if (!importingClassMetadata.hasAnnotation(EnableMultiDinger.class.getName())) {
            log.warn("import class can't find EnableMultiDinger annotation.");
            return;
        }
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableMultiDinger.class.getName()));
        AnnotationAttributes[] value = annotationAttributes.getAnnotationArray("value");
        boolean aloneMulti = value.length == 0;
        log.info("multi dinger register and is it global register? {}.", (Object)(!aloneMulti ? 1 : 0));
        if (aloneMulti) {
            List<Class<?>> dingerClasses = MultiDingerScannerRegistrar.dingerClasses();
            if (dingerClasses.isEmpty()) {
                log.warn("dinger class is empty, so no need to deal with multiDinger.");
                return;
            }
            this.multiDingerHandler(registry, dingerClasses);
            if (!MultiDingerConfigContainer.INSTANCE.isEmpty()) {
                MultiDingerProperty.multiDinger = true;
            }
        } else {
            for (AnnotationAttributes attributes : value) {
                DingerType dinger = (DingerType)attributes.getEnum("dinger");
                Class handler = attributes.getClass("handler");
                if (debugEnabled) {
                    log.debug("enable {} global multi dinger, and multiDinger handler class={}.", (Object)dinger, (Object)handler.getName());
                }
                DingerConfigHandler dingerConfigHandler = (DingerConfigHandler)BeanUtils.instantiateClass((Class)handler);
                this.registerHandler(registry, dinger, (Object)((Object)dinger) + "." + MultiDingerConfigContainer.GLOABL_KEY, dingerConfigHandler);
                MultiDingerProperty.multiDinger = true;
            }
        }
    }

    private void multiDingerHandler(BeanDefinitionRegistry registry, List<Class<?>> dingerClasses) {
        boolean debugEnabled = log.isDebugEnabled();
        for (Class<?> dingerClass : dingerClasses) {
            if (!dingerClass.isAnnotationPresent(MultiHandler.class)) continue;
            MultiHandler multiDinger = dingerClass.getAnnotation(MultiHandler.class);
            MultiDinger value = multiDinger.value();
            Class<? extends DingerConfigHandler> dingerConfigHandler = value.handler();
            String beanName = dingerConfigHandler.getSimpleName();
            if (dingerConfigHandler.isInterface()) {
                log.warn("dingerClass={} handler className={} is interface and skip.", (Object)dingerClass.getSimpleName(), (Object)beanName);
                continue;
            }
            String key = dingerClass.getName();
            DingerConfigHandler handler = (DingerConfigHandler)ClassUtils.newInstance(dingerConfigHandler);
            DingerType dinger = value.dinger();
            this.registerHandler(registry, dinger, (Object)((Object)dinger) + "." + key, handler);
            if (!debugEnabled) continue;
            log.debug("regiseter multi dinger for dingerClass={} and dingerConfigHandler={}.", (Object)dingerClass.getSimpleName(), (Object)beanName);
        }
    }

    private void registerHandler(BeanDefinitionRegistry registry, DingerType dinger, String key, DingerConfigHandler dingerConfigHandler) {
        String dingerConfigHandlerClassName = dingerConfigHandler.getClass().getSimpleName();
        if (!dinger.isEnabled()) {
            throw new DingerException(ExceptionEnum.MULTIDINGER_ANNOTATTION_EXCEPTION, new Object[]{key, dinger});
        }
        Class<? extends AlgorithmHandler> algorithm = dingerConfigHandler.algorithmHandler();
        List<DingerConfig> dingerConfigs = dingerConfigHandler.dingerConfigs();
        if (algorithm == null) {
            throw new DingerException(ExceptionEnum.MULTIDINGER_ALGORITHM_EXCEPTION, dingerConfigHandlerClassName);
        }
        for (int i = 0; i < dingerConfigs.size(); ++i) {
            DingerConfig dingerConfig = dingerConfigs.get(i);
            dingerConfig.setDingerType(dinger);
            if (!DingerUtils.isEmpty(dingerConfig.getTokenId())) continue;
            throw new DingerException(ExceptionEnum.DINGER_CONFIG_HANDLER_EXCEPTION, dingerConfigHandlerClassName, i);
        }
        long injectionCnt = Arrays.stream(algorithm.getDeclaredFields()).filter(e -> e.isAnnotationPresent(Autowired.class)).count();
        AnalysisEnum mode = AnalysisEnum.REFLECT;
        if (injectionCnt == 0L) {
            AlgorithmHandler algorithmHandler = (AlgorithmHandler)ClassUtils.newInstance(algorithm);
            MultiDingerConfigContainer.INSTANCE.put(key, new MultiDingerConfig(algorithmHandler, dingerConfigs));
        } else {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(algorithm);
            AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getBeanDefinition();
            beanDefinition.setAutowireMode(2);
            String beanName = key + "." + algorithm.getSimpleName();
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            MULTIDINGER_ALGORITHM_DEFINITION_MAP.put(beanName, new MultiDingerAlgorithmDefinition(key, algorithm, dingerConfigs, dingerConfigHandlerClassName));
            mode = AnalysisEnum.SPRING_CONTAINER;
        }
        if (log.isDebugEnabled()) {
            log.debug("key={}, algorithm={} analysis through mode {}.", new Object[]{key, algorithm.getSimpleName(), mode});
        }
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    public static enum AnalysisEnum {
        REFLECT,
        SPRING_CONTAINER;

    }
}

