/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.AnnotationDingerDefinitionResolver;
import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.core.DingerDefinitionResolver;
import com.github.jaemon.dinger.core.XmlDingerDefinitionResolver;
import com.github.jaemon.dinger.core.entity.enums.DingerType;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.listeners.DingerListenersProperty;
import com.github.jaemon.dinger.utils.DingerUtils;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DefaultDingerDefinitionResolver
extends DingerListenersProperty
implements EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultDingerDefinitionResolver.class);
    private final DingerDefinitionResolver xmlDingerDefinitionResolver = new XmlDingerDefinitionResolver();
    private final DingerDefinitionResolver annotaDingerDefinitionResolver = new AnnotationDingerDefinitionResolver();
    private Environment environment;

    protected void resolver(List<Class<?>> dingerClasses) {
        this.registerDefaultDingerConfig(this.environment);
        this.dingerXmlResolver();
        this.annotaDingerDefinitionResolver.resolver(dingerClasses);
    }

    protected void dingerXmlResolver() {
        Resource[] resources;
        boolean debugEnabled = log.isDebugEnabled();
        String dingerLocationsProp = "spring.dinger.dinger-locations";
        String dingerLocations = this.environment.getProperty(dingerLocationsProp);
        if (dingerLocations == null) {
            if (debugEnabled) {
                log.debug("dinger xml is not configured.");
            }
            return;
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            resources = resolver.getResources(dingerLocations);
        }
        catch (IOException e) {
            throw new DingerException(ExceptionEnum.RESOURCE_CONFIG_EXCEPTION, dingerLocations);
        }
        if (resources.length == 0) {
            log.warn("dinger xml is empty under {}.", (Object)dingerLocations);
            return;
        }
        this.xmlDingerDefinitionResolver.resolver(resources);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private void registerDefaultDingerConfig(Environment environment) {
        if (environment == null) {
            log.warn("environment is null.");
            return;
        }
        for (DingerType dingerType : enabledDingerTypes) {
            String dingers = "spring.dinger.dingers." + dingerType.name().toLowerCase() + ".";
            String tokenIdProp = dingers + "token-id";
            String secretProp = dingers + "secret";
            String decryptProp = dingers + "decrypt";
            String decryptKeyProp = dingers + "decryptKey";
            String asyncExecuteProp = dingers + "async";
            if (DingerUtils.isEmpty(tokenIdProp)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("dinger={} is not open.", (Object)dingerType);
                continue;
            }
            String tokenId = environment.getProperty(tokenIdProp);
            String secret = environment.getProperty(secretProp);
            boolean decrypt = this.getProperty(environment, decryptProp);
            boolean async = this.getProperty(environment, asyncExecuteProp);
            DingerConfig defaultDingerConfig = DingerConfig.instance(tokenId);
            defaultDingerConfig.setDingerType(dingerType);
            defaultDingerConfig.setSecret(secret);
            if (decrypt) {
                defaultDingerConfig.setDecryptKey(environment.getProperty(decryptKeyProp));
            }
            defaultDingerConfig.setAsyncExecute(async);
            defaultDingerConfig.check();
            defaultDingerConfigs.put(dingerType, defaultDingerConfig);
        }
    }

    private boolean getProperty(Environment environment, String prop) {
        if (environment.getProperty(prop) != null) {
            return (Boolean)environment.getProperty(prop, Boolean.TYPE);
        }
        return false;
    }
}

