/*
 * Decompiled with CFR 0.152.
 */
package com.anupcowkur.reservoir;

import com.jakewharton.disklrucache.DiskLruCache;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

class SimpleDiskCache {
    private static final int VALUE_IDX = 0;
    private static final int METADATA_IDX = 1;
    private static final List<File> usedDirs = new ArrayList<File>();
    private final DiskLruCache diskLruCache;

    private SimpleDiskCache(File dir, int appVersion, long maxSize) throws IOException {
        this.diskLruCache = DiskLruCache.open((File)dir, (int)appVersion, (int)2, (long)maxSize);
    }

    static synchronized SimpleDiskCache open(File dir, int appVersion, long maxSize) throws IOException {
        if (usedDirs.contains(dir)) {
            throw new IllegalStateException("Cache dir " + dir.getAbsolutePath() + " was used " + "before.");
        }
        usedDirs.add(dir);
        return new SimpleDiskCache(dir, appVersion, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringEntry getString(String key) throws IOException {
        DiskLruCache.Snapshot snapshot = this.diskLruCache.get(this.toInternalKey(key));
        if (snapshot == null) {
            return null;
        }
        try {
            StringEntry stringEntry = new StringEntry(snapshot.getString(0));
            return stringEntry;
        }
        finally {
            snapshot.close();
        }
    }

    boolean contains(String key) throws IOException {
        DiskLruCache.Snapshot snapshot = this.diskLruCache.get(this.toInternalKey(key));
        if (snapshot == null) {
            return false;
        }
        snapshot.close();
        return true;
    }

    private OutputStream openStream(String key, Map<String, ? extends Serializable> metadata) throws IOException {
        DiskLruCache.Editor editor = this.diskLruCache.edit(this.toInternalKey(key));
        try {
            this.writeMetadata(metadata, editor);
            BufferedOutputStream bos = new BufferedOutputStream(editor.newOutputStream(0));
            return new CacheOutputStream(bos, editor);
        }
        catch (IOException e) {
            editor.abort();
            throw e;
        }
    }

    void put(String key, String value) throws IOException {
        this.put(key, value, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String key, String value, Map<String, ? extends Serializable> annotations) throws IOException {
        OutputStream cos = null;
        try {
            cos = this.openStream(key, annotations);
            cos.write(value.getBytes());
        }
        finally {
            if (cos != null) {
                cos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetadata(Map<String, ? extends Serializable> metadata, DiskLruCache.Editor editor) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(editor.newOutputStream(1)));
            oos.writeObject(metadata);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(oos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)oos);
    }

    private String toInternalKey(String key) {
        return this.md5(key);
    }

    private String md5(String s) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(s.getBytes("UTF-8"));
            byte[] digest = m.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            return bigInt.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    static class StringEntry {
        private final String string;

        StringEntry(String string) {
            this.string = string;
        }

        String getString() {
            return this.string;
        }
    }

    private class CacheOutputStream
    extends FilterOutputStream {
        private final DiskLruCache.Editor editor;
        private boolean failed;

        private CacheOutputStream(OutputStream os, DiskLruCache.Editor editor) {
            super(os);
            this.failed = false;
            this.editor = editor;
        }

        @Override
        public void close() throws IOException {
            IOException closeException = null;
            try {
                super.close();
            }
            catch (IOException e) {
                closeException = e;
            }
            if (this.failed) {
                this.editor.abort();
            } else {
                this.editor.commit();
            }
            if (closeException != null) {
                throw closeException;
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                super.flush();
            }
            catch (IOException e) {
                this.failed = true;
                throw e;
            }
        }

        @Override
        public void write(int oneByte) throws IOException {
            try {
                super.write(oneByte);
            }
            catch (IOException e) {
                this.failed = true;
                throw e;
            }
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            try {
                super.write(buffer);
            }
            catch (IOException e) {
                this.failed = true;
                throw e;
            }
        }

        @Override
        public void write(byte[] buffer, int offset, int length) throws IOException {
            try {
                super.write(buffer, offset, length);
            }
            catch (IOException e) {
                this.failed = true;
                throw e;
            }
        }
    }
}

