/*
 * Decompiled with CFR 0.152.
 */
package com.anupcowkur.reservoir;

import android.content.Context;
import android.os.AsyncTask;
import com.anupcowkur.reservoir.ReservoirGetCallback;
import com.anupcowkur.reservoir.ReservoirPutCallback;
import com.anupcowkur.reservoir.SimpleDiskCache;
import com.google.gson.Gson;

public class Reservoir {
    private static SimpleDiskCache cache;

    public static synchronized void init(Context context, long maxSize) throws Exception {
        cache = SimpleDiskCache.open(context.getFilesDir(), 1, maxSize);
    }

    public static boolean contains(String key) throws Exception {
        return cache.contains(key);
    }

    public static void put(String key, Object object) throws Exception {
        String json = new Gson().toJson(object);
        cache.put(key, json);
    }

    public static void putAsync(String key, Object object, ReservoirPutCallback callback) {
        new PutTask(key, object, callback).execute(new Void[0]);
    }

    public static <T> T get(String key, Class<T> classOfT) throws Exception {
        String json = cache.getString(key).getString();
        return (T)new Gson().fromJson(json, classOfT);
    }

    public static <T> void getAsync(String key, Class<T> classOfT, ReservoirGetCallback<T> callback) {
        new GetTask(key, classOfT, callback).execute(new Void[0]);
    }

    private static class GetTask<T>
    extends AsyncTask<Void, Void, T> {
        private final String key;
        private final ReservoirGetCallback callback;
        private final Class<T> classOfT;
        private Exception e;

        private GetTask(String key, Class<T> classOfT, ReservoirGetCallback callback) {
            this.key = key;
            this.callback = callback;
            this.classOfT = classOfT;
            this.e = null;
        }

        protected T doInBackground(Void ... params) {
            try {
                String json = cache.getString(this.key).getString();
                return (T)new Gson().fromJson(json, this.classOfT);
            }
            catch (Exception e) {
                this.e = e;
                return null;
            }
        }

        protected void onPostExecute(T object) {
            if (this.callback != null) {
                if (this.e == null) {
                    this.callback.onSuccess(object);
                } else {
                    this.callback.onFailure(this.e);
                }
            }
        }
    }

    private static class PutTask
    extends AsyncTask<Void, Void, Void> {
        private final String key;
        private Exception e;
        private final ReservoirPutCallback callback;
        final Object object;

        private PutTask(String key, Object object, ReservoirPutCallback callback) {
            this.key = key;
            this.callback = callback;
            this.object = object;
            this.e = null;
        }

        protected Void doInBackground(Void ... params) {
            try {
                String json = new Gson().toJson(this.object);
                cache.put(this.key, json);
            }
            catch (Exception e) {
                this.e = e;
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            if (this.callback != null) {
                if (this.e == null) {
                    this.callback.onSuccess();
                } else {
                    this.callback.onFailure(this.e);
                }
            }
        }
    }
}

