/*
 * Decompiled with CFR 0.152.
 */
package com.github.aoreshin.allure.webdriver;

import com.github.aoreshin.allure.webdriver.WebDriverPageObjectFactory;
import com.github.aoreshin.junit5.allure.steps.PageObject;
import com.github.aoreshin.junit5.allure.steps.StepWrapperSteps;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;

@PageObject
public abstract class WebDriverPageObject<T extends WebDriverPageObject<T>>
extends StepWrapperSteps<T> {
    private WebDriverPageObjectFactory pageObjectFactory;
    protected WebDriver driver;
    protected WebDriverWait driverWait;

    public final <D extends WebDriverPageObject<D>> D seePage(Class<D> pageClass) {
        Assertions.assertNotEquals(((Object)((Object)this)).getClass(), pageClass);
        return this.pageObjectFactory.createPageObject(pageClass);
    }

    protected void sendKeys(String xpath, CharSequence ... value) {
        this.getWebElement(xpath).sendKeys(value);
    }

    protected void click(String xpath) {
        this.getWebElement(xpath).click();
    }

    protected void clear(String xpath) {
        this.getWebElement(xpath).clear();
    }

    protected WebElement getWebElement(String xpath) {
        return this.driver.findElement(By.xpath((String)xpath));
    }

    protected List<WebElement> getWebElementList(String xpath) {
        return this.driver.findElements(By.xpath((String)xpath));
    }

    protected void jsClick(String xpath) {
        this.jsClick(this.getWebElement(xpath));
    }

    protected void jsClick(WebElement webElement) {
        ((JavascriptExecutor)this.driver).executeScript("arguments[0].click();", new Object[]{webElement});
    }

    protected void scrollIntoView(WebElement webElement) {
        ((JavascriptExecutor)this.driver).executeScript("arguments[0].scrollIntoView(true);", new Object[]{webElement});
    }

    protected void scrollIntoView(String xpath) {
        this.scrollIntoView(this.getWebElement(xpath));
    }

    protected void waitUntilPageIsLoaded() {
        this.driverWait.until(webDriver -> ((JavascriptExecutor)webDriver).executeScript("return document.readyState", new Object[0]).equals("complete"));
    }
}

