/*
 * Decompiled with CFR 0.152.
 */
package com.github.aoreshin.allure.webdriver;

import com.github.aoreshin.allure.webdriver.WebDriverPageObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebDriverPageObjectFactory {
    private static final Logger LOGGER = LogManager.getLogger(WebDriverPageObjectFactory.class);
    private int COUNTER;
    private final WebDriver webDriver;
    private final WebDriverWait webDriverWait;
    private final Map<Class<? extends WebDriverPageObject<?>>, WebDriverPageObject<? extends WebDriverPageObject<?>>> pageObjectCache = new HashMap();

    public WebDriverPageObjectFactory(WebDriver webDriver, WebDriverWait webDriverWait) {
        this.webDriver = webDriver;
        this.webDriverWait = webDriverWait;
    }

    <T extends WebDriverPageObject<T>> T createPageObject(Class<T> pageObjectClass) {
        this.isSupported(pageObjectClass);
        LOGGER.debug("Creating PageObject " + pageObjectClass.getName());
        WebDriverPageObject<? extends WebDriverPageObject<?>> cachedPageObject = this.pageObjectCache.get(pageObjectClass);
        if (cachedPageObject != null) {
            LOGGER.debug("Cache request \u2116 " + this.COUNTER++);
            return (T)((Object)((WebDriverPageObject)((Object)pageObjectClass.cast(cachedPageObject))));
        }
        try {
            Constructor<T> constructor = pageObjectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            WebDriverPageObject instance = (WebDriverPageObject)((Object)constructor.newInstance(new Object[0]));
            this.initPage(instance, pageObjectClass);
            this.pageObjectCache.put(pageObjectClass, instance);
            return (T)((Object)instance);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new PageNotInitializedException("Page cannot be initialized, problem in the default constructor");
        }
    }

    private <T extends WebDriverPageObject<T>> void isSupported(Class<T> pageObjectClass) {
        LOGGER.debug("Validity check PageObject " + pageObjectClass.getName() + " and PageObjectFactory " + this.getClass().getName());
        Class<T> superClass = pageObjectClass.getSuperclass();
        if (!superClass.equals(WebDriverPageObject.class)) {
            throw new PageNotInitializedException(this.getClass().getName() + " does not support PageObject " + pageObjectClass.getName());
        }
    }

    void shutdown() {
        this.webDriver.quit();
    }

    byte[] makeScreenshot() {
        return (byte[])((TakesScreenshot)this.webDriver).getScreenshotAs(OutputType.BYTES);
    }

    private <T extends WebDriverPageObject<T>> void initPage(T pageObjectInstance, Class<T> pageObjectClass) {
        Class<T> superClass = pageObjectClass.getSuperclass();
        Map<String, Object> nameAndValues = Map.of("driver", this.webDriver, "driverWait", this.webDriverWait, "pageObjectFactory", this);
        this.setFieldValue(superClass, pageObjectInstance, nameAndValues);
    }

    <T> void setFieldValue(Class<T> toSearch, Object instance, Map<String, Object> nameAndValues) {
        nameAndValues.forEach((key, value) -> {
            try {
                Field field = toSearch.getDeclaredField((String)key);
                field.setAccessible(true);
                field.set(instance, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                throw new PageNotInitializedException("Cannot init page" + instance.getClass().getName());
            }
        });
    }

    static class PageNotInitializedException
    extends RuntimeException {
        PageNotInitializedException(String message) {
            super(message);
        }
    }
}

