/*
 * Decompiled with CFR 0.152.
 */
package com.github.aoreshin.allure.webdriver;

import com.github.aoreshin.allure.webdriver.WebDriverPageObject;
import com.github.aoreshin.allure.webdriver.WebDriverPageObjectFactory;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;

public final class WebDriverPageObjectFactoryCallbacks
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver,
TestExecutionExceptionHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<Class<? extends WebDriverPageObject<?>>> pageObjectClassSet;
    private final Supplier<WebDriverPageObjectFactory> pageObjectFactorySupplier;
    private WebDriverPageObjectFactory pageObjectFactory;

    public WebDriverPageObjectFactoryCallbacks(Set<Class<? extends WebDriverPageObject<?>>> pageObjectClassSet, Supplier<WebDriverPageObjectFactory> pageObjectFactorySupplier) {
        this.pageObjectClassSet = pageObjectClassSet;
        this.pageObjectFactorySupplier = pageObjectFactorySupplier;
    }

    public void beforeEach(ExtensionContext context) {
        this.pageObjectFactory = this.pageObjectFactorySupplier.get();
    }

    public void afterEach(ExtensionContext context) {
        this.pageObjectFactory.shutdown();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.pageObjectClassSet.stream().anyMatch(pageObjectClass -> parameterContext.getParameter().getType().equals(pageObjectClass));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.pageObjectFactory.createPageObject(parameterContext.getParameter().getType());
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        LOGGER.debug("Test ended with exception");
        this.lifecycle().addAttachment("Screenshot", "image/png", "", this.pageObjectFactory.makeScreenshot());
        throw throwable;
    }

    AllureLifecycle lifecycle() {
        return Allure.getLifecycle();
    }
}

