/*
 * Decompiled with CFR 0.152.
 */
package com.github.aoudiamoncef.apollo.plugin.util;

import com.apollographql.apollo.api.internal.json.JsonWriter;
import com.apollographql.apollo.compiler.MoshiKt;
import com.apollographql.apollo.compiler.VersionKt;
import com.apollographql.apollo.compiler.parser.introspection.Introspection2sdlKt;
import com.apollographql.apollo.compiler.parser.introspection.IntrospectionSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.aoudiamoncef.apollo.plugin.util.GzipRequestInterceptor;
import com.github.aoudiamoncef.apollo.plugin.util.UnsafeOkHttpClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ6\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ@\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J.\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rJ\u001a\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\"\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\"\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010$\u001a\u0004\u0018\u0001H%\"\u0006\b\u0000\u0010%\u0018\u0001*\u0004\u0018\u00010\u0001H\u0086\b\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/github/aoudiamoncef/apollo/plugin/util/SchemaDownloader;", "", "()V", "introspectionQuery", "", "downloadIntrospection", "", "endpoint", "schema", "Ljava/io/File;", "headers", "", "prettyPrint", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "downloadRegistry", "graph", "key", "variant", "executeQuery", "Lokhttp3/Response;", "query", "variables", "url", "newOkHttpClient", "connectTimeoutSeconds", "", "readTimeoutSeconds", "writeTimeoutSeconds", "useSelfSignedCertificat", "useGzip", "pretify", "document", "writeResponse", "response", "cast", "T", "(Ljava/lang/Object;)Ljava/lang/Object;", "apollo-client-maven-plugin"})
public final class SchemaDownloader {
    @NotNull
    public static final SchemaDownloader INSTANCE = new SchemaDownloader();
    @NotNull
    private static final String introspectionQuery = "query IntrospectionQuery {\n  __schema {\n    queryType { name }\n    mutationType { name }\n    subscriptionType { name }\n    types {\n      ...FullType\n    }\n    directives {\n      name\n      description\n      locations\n      args {\n        ...InputValue\n      }\n    }\n  }\n}\n\nfragment FullType on __Type {\n  kind\n  name\n  description\n  fields(includeDeprecated: true) {\n    name\n    description\n    args {\n      ...InputValue\n    }\n    type {\n      ...TypeRef\n    }\n    isDeprecated\n    deprecationReason\n  }\n  inputFields {\n    ...InputValue\n  }\n  interfaces {\n    ...TypeRef\n  }\n  enumValues(includeDeprecated: true) {\n    name\n    description\n    isDeprecated\n    deprecationReason\n  }\n  possibleTypes {\n    ...TypeRef\n  }\n}\n\nfragment InputValue on __InputValue {\n  name\n  description\n  type { ...TypeRef }\n  defaultValue\n}\n\nfragment TypeRef on __Type {\n  kind\n  name\n  ofType {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}";

    private SchemaDownloader() {
    }

    @NotNull
    public final OkHttpClient newOkHttpClient(long connectTimeoutSeconds, long readTimeoutSeconds, long writeTimeoutSeconds, boolean useSelfSignedCertificat, boolean useGzip) {
        OkHttpClient.Builder okhttpClientBuilder;
        OkHttpClient.Builder builder = okhttpClientBuilder = useSelfSignedCertificat ? UnsafeOkHttpClient.Companion.getUnsafeOkHttpClient() : new OkHttpClient.Builder();
        if (useGzip) {
            okhttpClientBuilder.addInterceptor((Interceptor)new GzipRequestInterceptor());
        }
        return new OkHttpClient.Builder().connectTimeout(connectTimeoutSeconds, TimeUnit.SECONDS).readTimeout(readTimeoutSeconds, TimeUnit.SECONDS).writeTimeout(writeTimeoutSeconds, TimeUnit.SECONDS).build();
    }

    private final Response executeQuery(String query, String variables, String url, Map<String, String> headers, OkHttpClient okHttpClient) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JsonWriter jsonWriter = JsonWriter.Companion.of(Okio.buffer((Sink)Okio.sink((OutputStream)byteArrayOutputStream)));
        boolean bl = false;
        boolean bl2 = false;
        JsonWriter $this$executeQuery_u24lambda_u2d0 = jsonWriter;
        boolean bl3 = false;
        $this$executeQuery_u24lambda_u2d0.beginObject();
        $this$executeQuery_u24lambda_u2d0.name("query");
        $this$executeQuery_u24lambda_u2d0.value(query);
        if (variables != null) {
            $this$executeQuery_u24lambda_u2d0.name("variables");
            $this$executeQuery_u24lambda_u2d0.value(variables);
        }
        $this$executeQuery_u24lambda_u2d0.endObject();
        $this$executeQuery_u24lambda_u2d0.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        RequestBody body = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])byArray, (MediaType)MediaType.Companion.parse("application/json"), (int)0, (int)0, (int)6, null);
        Request.Builder builder = new Request.Builder().post(body);
        boolean bl4 = false;
        boolean bl5 = false;
        Request.Builder $this$executeQuery_u24lambda_u2d2 = builder;
        boolean bl6 = false;
        $this$executeQuery_u24lambda_u2d2.addHeader("User-Agent", "ApolloMavenPlugin");
        Iterable $this$forEach$iv = headers.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl7 = false;
            $this$executeQuery_u24lambda_u2d2.addHeader((String)it.getKey(), (String)it.getValue());
        }
        Request request = builder.header("apollographql-client-name", "apollo-maven-plugin").header("apollographql-client-version", VersionKt.getVERSION()).url(url).build();
        Response response = okHttpClient.newCall(request).execute();
        bl4 = response.isSuccessful();
        bl5 = false;
        boolean bl8 = false;
        if (!bl4) {
            ResponseBody responseBody;
            boolean bl9 = false;
            String string = "Cannot get schema from " + url + ": " + response.code() + ":\n" + ((responseBody = response.body()) == null ? null : responseBody.string());
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return response;
    }

    static /* synthetic */ Response executeQuery$default(SchemaDownloader schemaDownloader, String string, String string2, String string3, Map map, OkHttpClient okHttpClient, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return schemaDownloader.executeQuery(string, string2, string3, map, okHttpClient);
    }

    public final void downloadIntrospection(@NotNull String endpoint, @NotNull File schema, @NotNull Map<String, String> headers, boolean prettyPrint, @NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Response response = this.executeQuery(introspectionQuery, null, endpoint, headers, okHttpClient);
        this.writeResponse(schema, response, prettyPrint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void downloadRegistry(@NotNull String graph, @NotNull File schema, @NotNull String key, @NotNull String variant, boolean prettyPrint, @NotNull OkHttpClient okHttpClient) {
        String document;
        Map map5;
        Map map2;
        Map map3;
        Map map4;
        Object v0;
        Object object;
        Object it2;
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        String query = "query DownloadSchema($graphID: ID!, $variant: String!) {\n  service(id: $graphID) {\n    variant(name: $variant) {\n      activeSchemaPublish {\n        schema {\n          document\n        }\n      }\n    }\n  }\n}";
        String variables = StringsKt.trimIndent((String)("\n      {\n        \"graphID\": \"" + graph + "\",\n        \"variant\": \"" + variant + "\"\n      }\n            "));
        Response response = this.executeQuery(query, variables, "https://graphql.api.apollographql.com/api/graphql", MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-api-key", (Object)key)), okHttpClient);
        Closeable closeable = (Closeable)response.body();
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = null;
        try {
            it2 = (ResponseBody)closeable;
            boolean map5 = false;
            object = it2;
            it2 = object == null ? null : object.string();
        }
        catch (Throwable it2) {
            object2 = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        Object responseString = it2;
        SchemaDownloader schemaDownloader = this;
        it2 = this;
        object = this;
        SchemaDownloader schemaDownloader2 = this;
        SchemaDownloader schemaDownloader3 = this;
        SchemaDownloader schemaDownloader4 = this;
        Object object3 = responseString;
        if (object3 == null) {
            v0 = null;
        } else {
            Map map6;
            void $this$fromJson$iv;
            Object object4 = object3;
            boolean $i$f$fromJson = false;
            boolean $i$f$getJsonAdapter = false;
            Object object5 = MoshiKt.getMOSHI().adapter(Map.class).fromJson((String)$this$fromJson$iv);
            if (object5 == null) {
                Intrinsics.throwNpe();
            }
            v0 = (map6 = (Map)object5) == null ? null : map6.get("data");
        }
        Object $this$cast$iv = v0;
        boolean $i$f$cast = false;
        Object v2 = $this$cast$iv;
        if (!(v2 instanceof Map)) {
            v2 = null;
        }
        Object $this$cast$iv2 = (map4 = (Map)v2) == null ? null : map4.get("service");
        boolean $i$f$cast2 = false;
        Object v3 = $this$cast$iv2;
        if (!(v3 instanceof Map)) {
            v3 = null;
        }
        Object $this$cast$iv3 = (map3 = (Map)v3) == null ? null : map3.get("variant");
        boolean $i$f$cast3 = false;
        Object v4 = $this$cast$iv3;
        if (!(v4 instanceof Map)) {
            v4 = null;
        }
        Object $this$cast$iv4 = (map2 = (Map)v4) == null ? null : map2.get("activeSchemaPublish");
        boolean $i$f$cast4 = false;
        Object v5 = $this$cast$iv4;
        if (!(v5 instanceof Map)) {
            v5 = null;
        }
        Object $this$cast$iv5 = (map5 = (Map)v5) == null ? null : map5.get("schema");
        boolean $i$f$cast5 = false;
        Object v6 = $this$cast$iv5;
        if (!(v6 instanceof Map)) {
            v6 = null;
        }
        Object $this$cast$iv6 = (object2 = (Map)v6) == null ? null : object2.get("document");
        boolean $i$f$cast6 = false;
        Object v7 = $this$cast$iv6;
        if (!(v7 instanceof String)) {
            v7 = null;
        }
        boolean bl3 = (document = (String)v7) != null;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl3) {
            boolean bl6 = false;
            String string = "Cannot retrieve document from " + responseString + "\nCheck graph id and variant";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.writeResponse(schema, document, prettyPrint);
    }

    public final /* synthetic */ Object cast(Object $this$cast) {
        boolean $i$f$cast = false;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return $this$cast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeResponse(File schema, Response response, boolean prettyPrint) {
        Object object = schema.getParentFile();
        if (object != null) {
            ((File)object).mkdirs();
        }
        object = (Closeable)response.body();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ResponseBody responseBody = (ResponseBody)object;
            boolean bl3 = false;
            String string = FilesKt.getExtension((File)schema);
            boolean bl4 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            if (Intrinsics.areEqual((Object)string3, (Object)"json")) {
                Intrinsics.checkNotNull((Object)responseBody);
                FilesKt.writeText$default((File)schema, (String)INSTANCE.pretify(responseBody.string(), prettyPrint), null, (int)2, null);
            } else {
                Intrinsics.checkNotNull((Object)responseBody);
                string = INSTANCE.pretify(responseBody.string(), prettyPrint);
                Charset charset = Charsets.UTF_8;
                boolean bl5 = false;
                String string4 = string;
                boolean bl6 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string5.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                Introspection2sdlKt.toSDL((IntrospectionSchema)IntrospectionSchema.Companion.invoke$default((IntrospectionSchema.Companion)IntrospectionSchema.Companion, (InputStream)new ByteArrayInputStream(byArray), null, (int)2, null), (File)schema);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void writeResponse(File schema, String document, boolean prettyPrint) {
        Object object = schema.getParentFile();
        if (object != null) {
            ((File)object).mkdirs();
        }
        object = FilesKt.getExtension((File)schema);
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object2).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        if (Intrinsics.areEqual((Object)string, (Object)"json")) {
            FilesKt.writeText$default((File)schema, (String)this.pretify(document, prettyPrint), null, (int)2, null);
        } else {
            object = this.pretify(document, prettyPrint);
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            Object object3 = object;
            boolean bl3 = false;
            Object object4 = object3;
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = ((String)object4).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            Introspection2sdlKt.toSDL((IntrospectionSchema)IntrospectionSchema.Companion.invoke$default((IntrospectionSchema.Companion)IntrospectionSchema.Companion, (InputStream)new ByteArrayInputStream(byArray), null, (int)2, null), (File)schema);
        }
    }

    private final String pretify(String document, boolean prettyPrint) {
        CharSequence charSequence = document;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new IllegalArgumentException("document: is null or blank");
        }
        if (prettyPrint) {
            ObjectMapper mapper = new ObjectMapper();
            Object object = mapper.readValue(document, JsonNode.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(document, JsonNode::class.java)");
            JsonNode json = (JsonNode)object;
            object = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json)");
            return object;
        }
        charSequence = document;
        bl = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            charSequence2 = "";
        }
        return charSequence2;
    }
}

