/*
 * Decompiled with CFR 0.152.
 */
package com.github.aoudiamoncef.apollo.plugin.util;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/github/aoudiamoncef/apollo/plugin/util/GzipRequestInterceptor;", "Lokhttp3/Interceptor;", "()V", "gzip", "Lokhttp3/RequestBody;", "body", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "apollo-client-maven-plugin"})
public final class GzipRequestInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request originalRequest = chain.request();
        if (originalRequest.body() == null || originalRequest.header("Content-Encoding") != null) {
            return chain.proceed(originalRequest);
        }
        Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "gzip").method(originalRequest.method(), this.gzip(originalRequest.body())).build();
        return chain.proceed(compressedRequest);
    }

    private final RequestBody gzip(RequestBody body) {
        return new RequestBody(body){
            final /* synthetic */ RequestBody $body;
            {
                this.$body = $body;
            }

            @Nullable
            public MediaType contentType() {
                RequestBody requestBody = this.$body;
                Intrinsics.checkNotNull((Object)requestBody);
                return requestBody.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(@NotNull BufferedSink sink) throws IOException {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                BufferedSink gzipSink = Okio.buffer((Sink)((Sink)new GzipSink((Sink)sink)));
                RequestBody requestBody = this.$body;
                Intrinsics.checkNotNull((Object)requestBody);
                requestBody.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }
}

