/*
 * Decompiled with CFR 0.152.
 */
package com.github.aoudiamoncef.apollo.plugin.util;

import com.apollographql.apollo3.compiler.MoshiKt;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.aoudiamoncef.apollo.plugin.util.ConfigUtils;
import com.github.aoudiamoncef.apollo.plugin.util.GzipRequestInterceptor;
import com.github.aoudiamoncef.apollo.plugin.util.UnsafeOkHttpClient;
import com.squareup.moshi.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J6\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J@\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000fJ\u001a\u0010\"\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010$\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010$\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010&\u001a\u0004\u0018\u0001H'\"\u0006\b\u0000\u0010'\u0018\u0001*\u0004\u0018\u00010\u0001H\u0082\b\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/github/aoudiamoncef/apollo/plugin/util/SchemaDownloader;", "", "()V", "introspectionQuery", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "downloadIntrospection", "", "endpoint", "schema", "Ljava/io/File;", "headers", "", "prettyPrint", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "downloadRegistry", "graph", "key", "variant", "executeQuery", "Lokhttp3/Response;", "query", "variables", "url", "newOkHttpClient", "connectTimeoutSeconds", "", "readTimeoutSeconds", "writeTimeoutSeconds", "useSelfSignedCertificat", "useGzip", "pretify", "document", "writeResponse", "response", "cast", "T", "(Ljava/lang/Object;)Ljava/lang/Object;", "apollo-client-maven-plugin"})
@SourceDebugExtension(value={"SMAP\nSchemaDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaDownloader.kt\ncom/github/aoudiamoncef/apollo/plugin/util/SchemaDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 moshi.kt\ncom/apollographql/apollo3/compiler/MoshiKt\n*L\n1#1,282:1\n151#1:288\n151#1:289\n151#1:290\n151#1:291\n151#1:292\n151#1:293\n1855#2,2:283\n1#3:285\n25#4:286\n17#4:287\n*S KotlinDebug\n*F\n+ 1 SchemaDownloader.kt\ncom/github/aoudiamoncef/apollo/plugin/util/SchemaDownloader\n*L\n137#1:288\n138#1:289\n139#1:290\n140#1:291\n141#1:292\n142#1:293\n71#1:283,2\n136#1:286\n136#1:287\n*E\n"})
public final class SchemaDownloader {
    @NotNull
    public static final SchemaDownloader INSTANCE = new SchemaDownloader();
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();
    @NotNull
    private static final String introspectionQuery = "query IntrospectionQuery {\n  __schema {\n    queryType { name }\n    mutationType { name }\n    subscriptionType { name }\n    types {\n      ...FullType\n    }\n    directives {\n      name\n      description\n      locations\n      args {\n        ...InputValue\n      }\n    }\n  }\n}\n\nfragment FullType on __Type {\n  kind\n  name\n  description\n  fields(includeDeprecated: true) {\n    name\n    description\n    args {\n      ...InputValue\n    }\n    type {\n      ...TypeRef\n    }\n    isDeprecated\n    deprecationReason\n  }\n  inputFields {\n    ...InputValue\n  }\n  interfaces {\n    ...TypeRef\n  }\n  enumValues(includeDeprecated: true) {\n    name\n    description\n    isDeprecated\n    deprecationReason\n  }\n  possibleTypes {\n    ...TypeRef\n  }\n}\n\nfragment InputValue on __InputValue {\n  name\n  description\n  type { ...TypeRef }\n  defaultValue\n}\n\nfragment TypeRef on __Type {\n  kind\n  name\n  ofType {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}";

    private SchemaDownloader() {
    }

    @NotNull
    public final OkHttpClient newOkHttpClient(long connectTimeoutSeconds, long readTimeoutSeconds, long writeTimeoutSeconds, boolean useSelfSignedCertificat, boolean useGzip) {
        OkHttpClient.Builder okhttpClientBuilder;
        OkHttpClient.Builder builder = okhttpClientBuilder = useSelfSignedCertificat ? UnsafeOkHttpClient.Companion.getUnsafeOkHttpClient() : new OkHttpClient.Builder();
        if (useGzip) {
            okhttpClientBuilder.addInterceptor((Interceptor)new GzipRequestInterceptor());
        }
        return okhttpClientBuilder.connectTimeout(connectTimeoutSeconds, TimeUnit.SECONDS).readTimeout(readTimeoutSeconds, TimeUnit.SECONDS).writeTimeout(writeTimeoutSeconds, TimeUnit.SECONDS).build();
    }

    private final Response executeQuery(String query, String variables, String url, Map<String, String> headers, OkHttpClient okHttpClient) {
        JsonWriter jsonWriter;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JsonWriter $this$executeQuery_u24lambda_u240 = jsonWriter = JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink((OutputStream)byteArrayOutputStream)));
        boolean bl = false;
        $this$executeQuery_u24lambda_u240.beginObject();
        $this$executeQuery_u24lambda_u240.name("query");
        $this$executeQuery_u24lambda_u240.value(query);
        if (variables != null) {
            $this$executeQuery_u24lambda_u240.name("variables");
            $this$executeQuery_u24lambda_u240.value(variables);
        }
        $this$executeQuery_u24lambda_u240.endObject();
        $this$executeQuery_u24lambda_u240.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        RequestBody body = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])byArray, (MediaType)MediaType.Companion.parse("application/json"), (int)0, (int)0, (int)6, null);
        Request.Builder $this$executeQuery_u24lambda_u242 = bl = new Request.Builder().post(body);
        boolean bl2 = false;
        $this$executeQuery_u24lambda_u242.addHeader("User-Agent", "ApolloMavenPlugin");
        Iterable $this$forEach$iv = headers.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl3 = false;
            $this$executeQuery_u24lambda_u242.addHeader((String)it.getKey(), (String)it.getValue());
        }
        Request request = bl.header("apollographql-client-name", "apollo-maven-plugin").header("apollographql-client-version", "3.8.2").url(url).build();
        Response response = okHttpClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            boolean bl4 = false;
            ResponseBody responseBody = response.body();
            String string = "Cannot get schema from " + url + ": " + response.code() + ":\n" + (responseBody != null ? responseBody.string() : null);
            throw new IllegalStateException(string.toString());
        }
        return response;
    }

    static /* synthetic */ Response executeQuery$default(SchemaDownloader schemaDownloader, String string, String string2, String string3, Map map, OkHttpClient okHttpClient, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return schemaDownloader.executeQuery(string, string2, string3, map, okHttpClient);
    }

    public final void downloadIntrospection(@NotNull String endpoint, @NotNull File schema, @NotNull Map<String, String> headers, boolean prettyPrint, @NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Response response = this.executeQuery(introspectionQuery, null, endpoint, headers, okHttpClient);
        this.writeResponse(schema, response, prettyPrint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void downloadRegistry(@NotNull String graph, @NotNull File schema, @NotNull String key, @NotNull String variant, boolean prettyPrint, @NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        query = "query DownloadSchema($graphID: ID!, $variant: String!) {\n  service(id: $graphID) {\n    variant(name: $variant) {\n      activeSchemaPublish {\n        schema {\n          document\n        }\n      }\n    }\n  }\n}";
        variables = StringsKt.trimIndent((String)("\n      {\n        \"graphID\": \"" + graph + "\",\n        \"variant\": \"" + variant + "\"\n      }\n            "));
        response = this.executeQuery(query, variables, "https://graphql.api.apollographql.com/api/graphql", MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-api-key", (Object)key)), okHttpClient);
        var11_10 = (Closeable)response.body();
        var12_11 = null;
        try {
            it = (ResponseBody)var11_10;
            $i$a$-use-SchemaDownloader$downloadRegistry$responseString$1 = false;
            v0 = it;
            it = v0 != null ? v0.string() : null;
        }
        catch (Throwable it) {
            var12_11 = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var11_10, (Throwable)var12_11);
        }
        responseString /* !! */  = it;
        var12_11 = this;
        $i$a$-use-SchemaDownloader$downloadRegistry$responseString$1 = this;
        var16_21 = this;
        var18_23 = this;
        var20_25 = this;
        var22_27 = this;
        if (responseString /* !! */  == null) ** GOTO lbl-1000
        var24_29 /* !! */  = responseString /* !! */ ;
        $i$f$fromJson = false;
        $i$f$getJsonAdapter = false;
        v1 = MoshiKt.getMOSHI().adapter(Map.class).fromJson((String)$this$fromJson$iv);
        Intrinsics.checkNotNull((Object)v1);
        var23_33 = (Map)v1;
        if (var23_33 != null) {
            v2 /* !! */  = var23_33.get("data");
        } else lbl-1000:
        // 2 sources

        {
            v2 /* !! */  = null;
        }
        var23_33 = v2 /* !! */ ;
        $i$f$cast = false;
        v3 = $this$cast$iv;
        if (!(v3 instanceof Map)) {
            v3 = null;
        }
        $this$cast$iv = (var21_34 = (Map)v3) != null ? var21_34.get("service") : null;
        $i$f$cast = false;
        v4 = $this$cast$iv;
        if (!(v4 instanceof Map)) {
            v4 = null;
        }
        $this$cast$iv = (var19_35 = (Map)v4) != null ? var19_35.get("variant") : null;
        $i$f$cast = false;
        v5 = $this$cast$iv;
        if (!(v5 instanceof Map)) {
            v5 = null;
        }
        $this$cast$iv = (var17_36 = (Map)v5) != null ? var17_36.get("activeSchemaPublish") : null;
        $i$f$cast = false;
        v6 = $this$cast$iv;
        if (!(v6 instanceof Map)) {
            v6 = null;
        }
        $this$cast$iv = (var15_37 = (Map)v6) != null ? var15_37.get("schema") : null;
        $i$f$cast = false;
        v7 = $this$cast$iv;
        if (!(v7 instanceof Map)) {
            v7 = null;
        }
        $this$cast$iv = (it = (Map)v7) != null ? it.get("document") : null;
        $i$f$cast = false;
        v8 = $this$cast$iv;
        if (!(v8 instanceof String)) {
            v8 = null;
        }
        if (!((document = (String)v8) != null)) {
            $i$a$-check-SchemaDownloader$downloadRegistry$1 = false;
            var13_16 = "Cannot retrieve document from " + (String)responseString /* !! */  + "\nCheck graph id and variant";
            throw new IllegalStateException(var13_16.toString());
        }
        this.writeResponse(schema, document, prettyPrint);
    }

    private final /* synthetic */ <T> T cast(Object $this$cast) {
        boolean $i$f$cast = false;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)$this$cast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeResponse(File schema, Response response, boolean prettyPrint) {
        File file = schema.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        Closeable closeable = (Closeable)response.body();
        Throwable throwable = null;
        try {
            Unit unit;
            ResponseBody responseBody = (ResponseBody)closeable;
            boolean bl = false;
            if (ConfigUtils.INSTANCE.isIntrospection(schema)) {
                ResponseBody responseBody2 = responseBody;
                FilesKt.writeText$default((File)schema, (String)INSTANCE.pretify(responseBody2 != null ? responseBody2.string() : null, prettyPrint), null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                ResponseBody responseBody3 = responseBody;
                if (responseBody3 != null) {
                    ResponseBody it = responseBody3;
                    boolean bl2 = false;
                    FilesKt.writeText$default((File)schema, (String)it.toString(), null, (int)2, null);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            Unit unit2 = unit;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void writeResponse(File schema, String document, boolean prettyPrint) {
        block2: {
            block1: {
                File file = schema.getParentFile();
                if (file != null) {
                    file.mkdirs();
                }
                if (!ConfigUtils.INSTANCE.isIntrospection(schema)) break block1;
                FilesKt.writeText$default((File)schema, (String)this.pretify(document, prettyPrint), null, (int)2, null);
                break block2;
            }
            String string = document;
            if (string == null) break block2;
            String it = string;
            boolean bl = false;
            FilesKt.writeText$default((File)schema, (String)it, null, (int)2, null);
        }
    }

    private final String pretify(String document, boolean prettyPrint) {
        CharSequence charSequence = document;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new IllegalArgumentException("document: is null or blank");
        }
        if (prettyPrint) {
            Object object = mapper.readValue(document, JsonNode.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(document, JsonNode::class.java)");
            JsonNode json = (JsonNode)object;
            String string = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapper.writerWithDefault\u2026.writeValueAsString(json)");
            return string;
        }
        return document;
    }
}

