package com.applikeysolutions.cosmocalendar.settings.lists;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class CalendarListsModel implements CalendarListsInterface {

    //Disabled days cannot be selected
    private Set<Long> disabledDays = new TreeSet<>();

    //Custom connected days for displaying in calendar
    private Set<Long> connectedCalendarDays = new TreeSet<>();

    private Set<Long> weekendDays = new HashSet() {{
        add(Calendar.SUNDAY);
    }};

    @Override
    public Set<Long> getDisabledDays() {
        return disabledDays;
    }

    @Override
    public Set<Long> getConnectedCalendarDays() {
        return connectedCalendarDays;
    }

    @Override
    public Set<Long> getWeekendDays() {
        return weekendDays;
    }

    @Override
    public void setDisabledDays(Set<Long> disabledDays) {
        this.disabledDays = disabledDays;
    }

    @Override
    public void setConnectedCalendarDays(Set<Long> connectedCalendarDays) {
        this.connectedCalendarDays = connectedCalendarDays;
    }

    @Override
    public void setWeekendDays(Set<Long> weekendDays) {
        this.weekendDays = weekendDays;
    }
}
