/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.applikeysolutions.cosmocalendar.adapter.viewholder.DayHolder;
import com.applikeysolutions.cosmocalendar.adapter.viewholder.DayOfWeekHolder;
import com.applikeysolutions.cosmocalendar.adapter.viewholder.OtherDayHolder;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.model.Month;
import com.applikeysolutions.cosmocalendar.view.CalendarView;
import com.applikeysolutions.cosmocalendar.view.delegate.DayDelegate;
import com.applikeysolutions.cosmocalendar.view.delegate.DayOfWeekDelegate;
import com.applikeysolutions.cosmocalendar.view.delegate.OtherDayDelegate;

public class DaysAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Month month;
    private DayOfWeekDelegate dayOfWeekDelegate;
    private DayDelegate dayDelegate;
    private OtherDayDelegate otherDayDelegate;
    private CalendarView calendarView;

    private DaysAdapter(Month month, DayOfWeekDelegate dayOfWeekDelegate, DayDelegate dayDelegate, OtherDayDelegate otherDayDelegate, CalendarView calendarView) {
        this.setHasStableIds(false);
        this.month = month;
        this.dayOfWeekDelegate = dayOfWeekDelegate;
        this.dayDelegate = dayDelegate;
        this.otherDayDelegate = otherDayDelegate;
        this.calendarView = calendarView;
    }

    public int getItemViewType(int position) {
        if (position < 7 && this.calendarView.isShowDaysOfWeek()) {
            return 3;
        }
        if (this.month.getDays().get(position).isBelongToMonth()) {
            return 1;
        }
        return 2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 3: {
                return this.dayOfWeekDelegate.onCreateDayHolder(parent, viewType);
            }
            case 1: {
                return this.dayDelegate.onCreateDayHolder(parent, viewType);
            }
            case 2: {
                return this.otherDayDelegate.onCreateDayHolder(parent, viewType);
            }
        }
        throw new IllegalArgumentException("Unknown view type");
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        Day day = this.month.getDays().get(position);
        switch (holder.getItemViewType()) {
            case 3: {
                this.dayOfWeekDelegate.onBindDayHolder(day, (DayOfWeekHolder)holder, position);
                break;
            }
            case 2: {
                this.otherDayDelegate.onBindDayHolder(day, (OtherDayHolder)holder, position);
                break;
            }
            case 1: {
                this.dayDelegate.onBindDayHolder(this, day, (DayHolder)holder, position);
            }
        }
    }

    public int getItemCount() {
        return this.month == null ? 0 : this.month.getDays().size();
    }

    public void setMonth(Month month) {
        this.month = month;
        this.notifyDataSetChanged();
    }

    public long getItemId(int position) {
        return this.month.getDays().get(position).getCalendar().getTimeInMillis();
    }

    public static class DaysAdapterBuilder {
        private Month month;
        private DayOfWeekDelegate dayOfWeekDelegate;
        private DayDelegate dayDelegate;
        private OtherDayDelegate anotherDayDelegate;
        private CalendarView calendarView;

        public DaysAdapterBuilder setMonth(Month month) {
            this.month = month;
            return this;
        }

        public DaysAdapterBuilder setDayOfWeekDelegate(DayOfWeekDelegate dayOfWeekDelegate) {
            this.dayOfWeekDelegate = dayOfWeekDelegate;
            return this;
        }

        public DaysAdapterBuilder setDayDelegate(DayDelegate dayDelegate) {
            this.dayDelegate = dayDelegate;
            return this;
        }

        public DaysAdapterBuilder setOtherDayDelegate(OtherDayDelegate anotherDayDelegate) {
            this.anotherDayDelegate = anotherDayDelegate;
            return this;
        }

        public DaysAdapterBuilder setCalendarView(CalendarView calendarView) {
            this.calendarView = calendarView;
            return this;
        }

        public DaysAdapter createDaysAdapter() {
            return new DaysAdapter(this.month, this.dayOfWeekDelegate, this.dayDelegate, this.anotherDayDelegate, this.calendarView);
        }
    }
}

