/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.applikeysolutions.cosmocalendar.adapter.DaysAdapter;
import com.applikeysolutions.cosmocalendar.adapter.viewholder.MonthHolder;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.model.Month;
import com.applikeysolutions.cosmocalendar.selection.BaseSelectionManager;
import com.applikeysolutions.cosmocalendar.utils.CalendarUtils;
import com.applikeysolutions.cosmocalendar.utils.DayFlag;
import com.applikeysolutions.cosmocalendar.view.CalendarView;
import com.applikeysolutions.cosmocalendar.view.delegate.DayDelegate;
import com.applikeysolutions.cosmocalendar.view.delegate.DayOfWeekDelegate;
import com.applikeysolutions.cosmocalendar.view.delegate.MonthDelegate;
import com.applikeysolutions.cosmocalendar.view.delegate.OtherDayDelegate;
import java.util.List;
import java.util.Set;

public class MonthAdapter
extends RecyclerView.Adapter<MonthHolder> {
    private final List<Month> months;
    private MonthDelegate monthDelegate;
    private CalendarView calendarView;
    private BaseSelectionManager selectionManager;
    private DaysAdapter daysAdapter;

    private MonthAdapter(List<Month> months, MonthDelegate monthDelegate, CalendarView calendarView, BaseSelectionManager selectionManager) {
        this.setHasStableIds(true);
        this.months = months;
        this.monthDelegate = monthDelegate;
        this.calendarView = calendarView;
        this.selectionManager = selectionManager;
    }

    public void setSelectionManager(BaseSelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public BaseSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public MonthHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.daysAdapter = new DaysAdapter.DaysAdapterBuilder().setDayOfWeekDelegate(new DayOfWeekDelegate(this.calendarView)).setOtherDayDelegate(new OtherDayDelegate(this.calendarView)).setDayDelegate(new DayDelegate(this.calendarView, this)).setCalendarView(this.calendarView).createDaysAdapter();
        return this.monthDelegate.onCreateMonthHolder(this.daysAdapter, parent, viewType);
    }

    public void onBindViewHolder(MonthHolder holder, int position) {
        Month month = this.months.get(position);
        this.monthDelegate.onBindMonthHolder(month, holder, position);
    }

    public int getItemCount() {
        return this.months.size();
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public long getItemId(int position) {
        return this.months.get(position).getFirstDay().getCalendar().getTimeInMillis();
    }

    public List<Month> getData() {
        return this.months;
    }

    public void setWeekendDays(Set<Long> weekendDays) {
        this.setDaysAccordingToSet(weekendDays, DayFlag.WEEKEND);
    }

    public void setDisabledDays(Set<Long> disabledDays) {
        this.setDaysAccordingToSet(disabledDays, DayFlag.DISABLED);
    }

    public void setConnectedCalendarDays(Set<Long> connectedCalendarDays) {
        this.setDaysAccordingToSet(connectedCalendarDays, DayFlag.FROM_CONNECTED_CALENDAR);
    }

    private void setDaysAccordingToSet(Set<Long> days, DayFlag dayFlag) {
        if (days != null && !days.isEmpty()) {
            for (Month month : this.months) {
                for (Day day : month.getDays()) {
                    switch (dayFlag) {
                        case WEEKEND: {
                            day.setWeekend(days.contains(day.getCalendar().get(7)));
                            break;
                        }
                        case DISABLED: {
                            day.setDisabled(CalendarUtils.isDayInSet(day, days));
                            break;
                        }
                        case FROM_CONNECTED_CALENDAR: {
                            day.setFromConnectedCalendar(CalendarUtils.isDayInSet(day, days));
                        }
                    }
                }
            }
            this.notifyDataSetChanged();
        }
    }

    public static class MonthAdapterBuilder {
        private List<Month> months;
        private MonthDelegate monthDelegate;
        private CalendarView calendarView;
        private BaseSelectionManager selectionManager;

        public MonthAdapterBuilder setMonths(List<Month> months) {
            this.months = months;
            return this;
        }

        public MonthAdapterBuilder setMonthDelegate(MonthDelegate monthHolderDelegate) {
            this.monthDelegate = monthHolderDelegate;
            return this;
        }

        public MonthAdapterBuilder setCalendarView(CalendarView calendarView) {
            this.calendarView = calendarView;
            return this;
        }

        public MonthAdapterBuilder setSelectionManager(BaseSelectionManager selectionManager) {
            this.selectionManager = selectionManager;
            return this;
        }

        public MonthAdapter createMonthAdapter() {
            return new MonthAdapter(this.months, this.monthDelegate, this.calendarView, this.selectionManager);
        }
    }
}

