/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.adapter.viewholder;

import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.view.View;
import com.applikeysolutions.cosmocalendar.adapter.viewholder.BaseDayHolder;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.selection.BaseSelectionManager;
import com.applikeysolutions.cosmocalendar.selection.RangeSelectionManager;
import com.applikeysolutions.cosmocalendar.selection.SelectionState;
import com.applikeysolutions.cosmocalendar.view.CalendarView;
import com.applikeysolutions.cosmocalendar.view.customviews.CircleAnimationTextView;
import com.applikeysolutions.customizablecalendar.R;

public class DayHolder
extends BaseDayHolder {
    private CircleAnimationTextView ctvDay;
    private BaseSelectionManager selectionManager;

    public DayHolder(View itemView, CalendarView calendarView) {
        super(itemView, calendarView);
        this.ctvDay = (CircleAnimationTextView)itemView.findViewById(R.id.tv_day_number);
    }

    public void bind(Day day, BaseSelectionManager selectionManager) {
        this.selectionManager = selectionManager;
        this.ctvDay.setText(String.valueOf(day.getDayNumber()));
        boolean isSelected = selectionManager.isDaySelected(day);
        if (isSelected && !day.isDisabled()) {
            this.select(day);
        } else {
            this.unselect(day);
        }
        if (day.isCurrent()) {
            int height = isSelected ? BitmapFactory.decodeResource((Resources)this.calendarView.getContext().getResources(), (int)this.calendarView.getCurrentDaySelectedIconRes()).getHeight() : BitmapFactory.decodeResource((Resources)this.calendarView.getContext().getResources(), (int)this.calendarView.getCurrentDayIconRes()).getHeight();
            this.ctvDay.setCompoundDrawablePadding(height * -1);
            this.ctvDay.setCompoundDrawablesWithIntrinsicBounds(0, isSelected ? this.calendarView.getCurrentDaySelectedIconRes() : this.calendarView.getCurrentDayIconRes(), 0, 0);
        } else {
            this.ctvDay.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        }
    }

    private void select(Day day) {
        if (day.isFromConnectedCalendar()) {
            this.ctvDay.setTextColor(this.calendarView.getConnectedDaySelectedTextColor());
        } else {
            this.ctvDay.setTextColor(this.calendarView.getSelectedDayTextColor());
        }
        SelectionState state = this.selectionManager instanceof RangeSelectionManager ? ((RangeSelectionManager)this.selectionManager).getSelectedState(day) : SelectionState.SINGLE_DAY;
        this.animateDay(state, day);
    }

    private void animateDay(SelectionState state, Day day) {
        if (day.getSelectionState() != state) {
            if (day.isSelectionCircleDrawed() && state == SelectionState.SINGLE_DAY) {
                this.ctvDay.showAsSingleCircle(this.calendarView);
            } else if (day.isSelectionCircleDrawed() && state == SelectionState.START_RANGE_DAY) {
                this.ctvDay.showAsStartCircle(this.calendarView, false);
            } else if (day.isSelectionCircleDrawed() && state == SelectionState.END_RANGE_DAY) {
                this.ctvDay.showAsEndCircle(this.calendarView, false);
            } else {
                this.ctvDay.setSelectionStateAndAnimate(state, this.calendarView, day);
            }
        } else {
            switch (state) {
                case SINGLE_DAY: {
                    if (day.isSelectionCircleDrawed()) {
                        this.ctvDay.showAsSingleCircle(this.calendarView);
                        break;
                    }
                    this.ctvDay.setSelectionStateAndAnimate(state, this.calendarView, day);
                    break;
                }
                case RANGE_DAY: {
                    this.ctvDay.setSelectionStateAndAnimate(state, this.calendarView, day);
                    break;
                }
                case START_RANGE_DAY_WITHOUT_END: {
                    if (day.isSelectionCircleDrawed()) {
                        this.ctvDay.showAsStartCircleWithouEnd(this.calendarView, false);
                        break;
                    }
                    this.ctvDay.setSelectionStateAndAnimate(state, this.calendarView, day);
                    break;
                }
                case START_RANGE_DAY: {
                    if (day.isSelectionCircleDrawed()) {
                        this.ctvDay.showAsStartCircle(this.calendarView, false);
                        break;
                    }
                    this.ctvDay.setSelectionStateAndAnimate(state, this.calendarView, day);
                    break;
                }
                case END_RANGE_DAY: {
                    if (day.isSelectionCircleDrawed()) {
                        this.ctvDay.showAsEndCircle(this.calendarView, false);
                        break;
                    }
                    this.ctvDay.setSelectionStateAndAnimate(state, this.calendarView, day);
                }
            }
        }
    }

    private void unselect(Day day) {
        int textColor = day.isFromConnectedCalendar() ? this.calendarView.getConnectedDayTextColor() : (day.isWeekend() ? this.calendarView.getWeekendDayTextColor() : this.calendarView.getDayTextColor());
        day.setSelectionCircleDrawed(false);
        this.ctvDay.setTextColor(textColor);
        this.ctvDay.clearView();
    }
}

