/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.adapter.viewholder;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.applikeysolutions.cosmocalendar.adapter.DaysAdapter;
import com.applikeysolutions.cosmocalendar.model.Month;
import com.applikeysolutions.cosmocalendar.settings.SettingsManager;
import com.applikeysolutions.cosmocalendar.view.MonthView;
import com.applikeysolutions.customizablecalendar.R;

public class MonthHolder
extends RecyclerView.ViewHolder {
    private LinearLayout llMonthHeader;
    private TextView tvMonthName;
    private View viewLeftLine;
    private View viewRightLine;
    private MonthView monthView;
    private SettingsManager appearanceModel;

    public MonthHolder(View itemView, SettingsManager appearanceModel) {
        super(itemView);
        this.llMonthHeader = (LinearLayout)itemView.findViewById(R.id.ll_month_header);
        this.monthView = (MonthView)itemView.findViewById(R.id.month_view);
        this.tvMonthName = (TextView)itemView.findViewById(R.id.tv_month_name);
        this.viewLeftLine = itemView.findViewById(R.id.view_left_line);
        this.viewRightLine = itemView.findViewById(R.id.view_right_line);
        this.appearanceModel = appearanceModel;
    }

    public void setDayAdapter(DaysAdapter adapter) {
        this.getMonthView().setAdapter(adapter);
    }

    public void bind(Month month) {
        this.tvMonthName.setText((CharSequence)month.getMonthName());
        this.tvMonthName.setTextColor(this.appearanceModel.getMonthTextColor());
        this.viewLeftLine.setVisibility(this.appearanceModel.getCalendarOrientation() == 0 ? 4 : 0);
        this.viewRightLine.setVisibility(this.appearanceModel.getCalendarOrientation() == 0 ? 4 : 0);
        this.llMonthHeader.setBackgroundResource(this.appearanceModel.getCalendarOrientation() == 0 ? R.drawable.border_top_bottom : 0);
        this.monthView.initAdapter(month);
    }

    public MonthView getMonthView() {
        return this.monthView;
    }
}

