/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.applikeysolutions.cosmocalendar.dialog.OnDaysSelectionListener;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.settings.appearance.AppearanceInterface;
import com.applikeysolutions.cosmocalendar.settings.date.DateInterface;
import com.applikeysolutions.cosmocalendar.settings.lists.CalendarListsInterface;
import com.applikeysolutions.cosmocalendar.settings.selection.SelectionInterface;
import com.applikeysolutions.cosmocalendar.view.CalendarView;
import com.applikeysolutions.customizablecalendar.R;
import java.util.List;
import java.util.Set;

public class CalendarDialog
extends Dialog
implements View.OnClickListener,
AppearanceInterface,
DateInterface,
CalendarListsInterface,
SelectionInterface {
    private FrameLayout flNavigationButtonsBar;
    private ImageView ivCancel;
    private ImageView ivDone;
    private CalendarView calendarView;
    private OnDaysSelectionListener onDaysSelectionListener;

    public CalendarDialog(@NonNull Context context) {
        super(context);
    }

    public CalendarDialog(@NonNull Context context, OnDaysSelectionListener onDaysSelectionListener) {
        super(context);
        this.onDaysSelectionListener = onDaysSelectionListener;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.dialog_calendar);
        this.getWindow().setLayout(-1, -1);
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getWindow().getAttributes().gravity = 48;
        this.initViews();
    }

    private void initViews() {
        this.flNavigationButtonsBar = (FrameLayout)this.findViewById(R.id.fl_navigation_buttons_bar);
        this.ivCancel = (ImageView)this.findViewById(R.id.iv_cancel);
        this.ivDone = (ImageView)this.findViewById(R.id.iv_done);
        this.calendarView = (CalendarView)this.findViewById(R.id.calendar_view);
        Drawable background = this.calendarView.getBackground();
        if (background instanceof ColorDrawable) {
            this.flNavigationButtonsBar.setBackgroundColor(((ColorDrawable)background).getColor());
        }
        this.ivCancel.setOnClickListener((View.OnClickListener)this);
        this.ivDone.setOnClickListener((View.OnClickListener)this);
    }

    public void setOnDaysSelectionListener(OnDaysSelectionListener onDaysSelectionListener) {
        this.onDaysSelectionListener = onDaysSelectionListener;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.iv_cancel) {
            this.cancel();
        } else if (id2 == R.id.iv_done) {
            this.doneClick();
        }
    }

    private void doneClick() {
        List<Day> selectedDays = this.calendarView.getSelectedDays();
        if (this.onDaysSelectionListener != null) {
            this.onDaysSelectionListener.onDaysSelected(selectedDays);
        }
        this.dismiss();
    }

    @Override
    public int getSelectionType() {
        return this.calendarView.getSelectionType();
    }

    @Override
    public void setSelectionType(int selectionType) {
        this.calendarView.setSelectionType(selectionType);
    }

    @Override
    public int getCalendarBackgroundColor() {
        return this.calendarView.getCalendarBackgroundColor();
    }

    @Override
    public int getMonthTextColor() {
        return this.calendarView.getMonthTextColor();
    }

    @Override
    public int getOtherDayTextColor() {
        return this.calendarView.getOtherDayTextColor();
    }

    @Override
    public int getDayTextColor() {
        return this.calendarView.getDayTextColor();
    }

    @Override
    public int getWeekendDayTextColor() {
        return this.calendarView.getWeekendDayTextColor();
    }

    @Override
    public int getWeekDayTitleTextColor() {
        return this.calendarView.getWeekDayTitleTextColor();
    }

    @Override
    public int getSelectedDayTextColor() {
        return this.calendarView.getSelectedDayTextColor();
    }

    @Override
    public int getSelectedDayBackgroundColor() {
        return this.calendarView.getSelectedDayBackgroundColor();
    }

    @Override
    public int getSelectedDayBackgroundStartColor() {
        return this.calendarView.getSelectedDayBackgroundStartColor();
    }

    @Override
    public int getSelectedDayBackgroundEndColor() {
        return this.calendarView.getSelectedDayBackgroundEndColor();
    }

    @Override
    public int getCurrentDayTextColor() {
        return this.calendarView.getCurrentDayTextColor();
    }

    @Override
    public int getCurrentDayIconRes() {
        return this.calendarView.getCurrentDayIconRes();
    }

    @Override
    public int getCurrentDaySelectedIconRes() {
        return this.calendarView.getCurrentDaySelectedIconRes();
    }

    @Override
    public int getCalendarOrientation() {
        return this.calendarView.getCalendarOrientation();
    }

    @Override
    public int getConnectedDayTextColor() {
        return this.calendarView.getConnectedDayTextColor();
    }

    @Override
    public int getConnectedDaySelectedTextColor() {
        return this.calendarView.getConnectedDaySelectedTextColor();
    }

    @Override
    public int getDisabledDayTextColor() {
        return this.calendarView.getDisabledDayTextColor();
    }

    @Override
    public int getSelectionBarMonthTextColor() {
        return this.calendarView.getSelectionBarMonthTextColor();
    }

    @Override
    public int getPreviousMonthIconRes() {
        return this.calendarView.getPreviousMonthIconRes();
    }

    @Override
    public int getNextMonthIconRes() {
        return this.calendarView.getNextMonthIconRes();
    }

    @Override
    public boolean isShowDaysOfWeek() {
        return this.calendarView.isShowDaysOfWeek();
    }

    @Override
    public boolean isShowDaysOfWeekTitle() {
        return this.calendarView.isShowDaysOfWeekTitle();
    }

    @Override
    public void setCalendarBackgroundColor(int calendarBackgroundColor) {
        this.calendarView.setCalendarBackgroundColor(calendarBackgroundColor);
    }

    @Override
    public void setMonthTextColor(int monthTextColor) {
        this.calendarView.setMonthTextColor(monthTextColor);
    }

    @Override
    public void setOtherDayTextColor(int otherDayTextColor) {
        this.calendarView.setOtherDayTextColor(otherDayTextColor);
    }

    @Override
    public void setDayTextColor(int dayTextColor) {
        this.calendarView.setDayTextColor(dayTextColor);
    }

    @Override
    public void setWeekendDayTextColor(int weekendDayTextColor) {
        this.calendarView.setWeekendDayTextColor(weekendDayTextColor);
    }

    @Override
    public void setWeekDayTitleTextColor(int weekDayTitleTextColor) {
        this.calendarView.setWeekDayTitleTextColor(weekDayTitleTextColor);
    }

    @Override
    public void setSelectedDayTextColor(int selectedDayTextColor) {
        this.calendarView.setSelectedDayTextColor(selectedDayTextColor);
    }

    @Override
    public void setSelectedDayBackgroundColor(int selectedDayBackgroundColor) {
        this.calendarView.setSelectedDayBackgroundColor(selectedDayBackgroundColor);
    }

    @Override
    public void setSelectedDayBackgroundStartColor(int selectedDayBackgroundStartColor) {
        this.calendarView.setSelectedDayBackgroundStartColor(selectedDayBackgroundStartColor);
    }

    @Override
    public void setSelectedDayBackgroundEndColor(int selectedDayBackgroundEndColor) {
        this.calendarView.setSelectedDayBackgroundEndColor(selectedDayBackgroundEndColor);
    }

    @Override
    public void setCurrentDayTextColor(int currentDayTextColor) {
        this.calendarView.setCurrentDayTextColor(currentDayTextColor);
    }

    @Override
    public void setCurrentDayIconRes(int currentDayIconRes) {
        this.calendarView.setCurrentDayIconRes(currentDayIconRes);
    }

    @Override
    public void setCurrentDaySelectedIconRes(int currentDaySelectedIconRes) {
        this.calendarView.setCurrentDaySelectedIconRes(currentDaySelectedIconRes);
    }

    @Override
    public void setCalendarOrientation(int calendarOrientation) {
        this.calendarView.setCalendarOrientation(calendarOrientation);
    }

    @Override
    public void setConnectedDayTextColor(int connectedDayTextColor) {
        this.calendarView.setConnectedDayTextColor(connectedDayTextColor);
    }

    @Override
    public void setConnectedDaySelectedTextColor(int connectedDaySelectedTextColor) {
        this.calendarView.setConnectedDaySelectedTextColor(connectedDaySelectedTextColor);
    }

    @Override
    public void setDisabledDayTextColor(int disabledDayTextColor) {
        this.calendarView.setDisabledDayTextColor(disabledDayTextColor);
    }

    @Override
    public void setSelectionBarMonthTextColor(int selectionBarMonthTextColor) {
        this.calendarView.setSelectionBarMonthTextColor(selectionBarMonthTextColor);
    }

    @Override
    public void setPreviousMonthIconRes(int previousMonthIconRes) {
        this.calendarView.setPreviousMonthIconRes(previousMonthIconRes);
    }

    @Override
    public void setNextMonthIconRes(int nextMonthIconRes) {
        this.calendarView.setNextMonthIconRes(nextMonthIconRes);
    }

    @Override
    public void setShowDaysOfWeek(boolean showDaysOfWeek) {
        this.calendarView.setShowDaysOfWeek(showDaysOfWeek);
    }

    @Override
    public void setShowDaysOfWeekTitle(boolean showDaysOfWeekTitle) {
        this.calendarView.setShowDaysOfWeekTitle(showDaysOfWeekTitle);
    }

    @Override
    public Set<Long> getDisabledDays() {
        return this.calendarView.getDisabledDays();
    }

    @Override
    public Set<Long> getConnectedCalendarDays() {
        return this.calendarView.getConnectedCalendarDays();
    }

    @Override
    public Set<Long> getWeekendDays() {
        return this.calendarView.getWeekendDays();
    }

    @Override
    public void setDisabledDays(Set<Long> disabledDays) {
        this.calendarView.setDisabledDays(disabledDays);
    }

    @Override
    public void setConnectedCalendarDays(Set<Long> connectedCalendarDays) {
        this.calendarView.setConnectedCalendarDays(connectedCalendarDays);
    }

    @Override
    public void setWeekendDays(Set<Long> weekendDays) {
        this.calendarView.setWeekendDays(weekendDays);
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.calendarView.getFirstDayOfWeek();
    }

    @Override
    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.calendarView.setFirstDayOfWeek(firstDayOfWeek);
    }
}

