/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.model;

import com.applikeysolutions.cosmocalendar.selection.SelectionState;
import com.applikeysolutions.cosmocalendar.utils.DateUtils;
import java.util.Calendar;
import java.util.Date;

public class Day {
    private Calendar calendar;
    private boolean belongToMonth;
    private boolean current;
    private boolean selected;
    private boolean disabled;
    private boolean weekend;
    private boolean fromConnectedCalendar;
    private SelectionState selectionState;
    private boolean isSelectionCircleDrawed;

    public Day(Date date) {
        this.calendar = DateUtils.getCalendar(date);
        this.current = DateUtils.isCurrentDate(date);
        this.selected = false;
    }

    public Day(Calendar calendar) {
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.setTime(calendar.getTime());
        this.calendar = tempCalendar;
        this.current = DateUtils.isCurrentDate(calendar.getTime());
        this.selected = false;
    }

    public boolean isBelongToMonth() {
        return this.belongToMonth;
    }

    public void setBelongToMonth(boolean belongToMonth) {
        this.belongToMonth = belongToMonth;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isWeekend() {
        return this.weekend;
    }

    public void setWeekend(boolean weekend) {
        this.weekend = weekend;
    }

    public boolean isFromConnectedCalendar() {
        return this.fromConnectedCalendar;
    }

    public void setFromConnectedCalendar(boolean fromConnectedCalendar) {
        this.fromConnectedCalendar = fromConnectedCalendar;
    }

    public boolean isSelectionCircleDrawed() {
        return this.isSelectionCircleDrawed;
    }

    public void setSelectionCircleDrawed(boolean selectionCircleDrawed) {
        this.isSelectionCircleDrawed = selectionCircleDrawed;
    }

    public SelectionState getSelectionState() {
        return this.selectionState;
    }

    public void setSelectionState(SelectionState selectionState) {
        this.selectionState = selectionState;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public int getDayNumber() {
        return this.calendar.get(5);
    }

    public String toString() {
        return "Day{day=" + this.calendar.getTime() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Day day = (Day)o;
        Calendar anotherCalendar = day.getCalendar();
        return anotherCalendar.get(1) == this.calendar.get(1) && anotherCalendar.get(6) == this.calendar.get(6);
    }

    public int hashCode() {
        return this.calendar != null ? this.calendar.hashCode() : 0;
    }
}

