/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.model;

import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.model.DayOfWeek;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class Month {
    private List<Day> days;
    private Day firstDay;

    public Month(Day firstDay, List<Day> days) {
        this.days = days;
        this.firstDay = firstDay;
    }

    public Day getFirstDay() {
        return this.firstDay;
    }

    public void setFirstDay(Day firstDay) {
        this.firstDay = firstDay;
    }

    public List<Day> getDays() {
        return this.days;
    }

    public List<Day> getDaysWithoutTitlesAndOnlyCurrent() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.firstDay.getCalendar().getTime());
        int currentMonth = calendar.get(2);
        ArrayList<Day> result = new ArrayList<Day>();
        for (Day day : this.days) {
            calendar.setTime(day.getCalendar().getTime());
            if (day instanceof DayOfWeek || calendar.get(2) != currentMonth) continue;
            result.add(day);
        }
        return result;
    }

    public String getMonthName() {
        return new SimpleDateFormat("MMMM yyyy", Locale.getDefault()).format(this.firstDay.getCalendar().getTime());
    }
}

