/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.selection;

import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.selection.BaseSelectionManager;
import com.applikeysolutions.cosmocalendar.selection.criteria.BaseCriteria;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseCriteriaSelectionManager
extends BaseSelectionManager {
    protected List<BaseCriteria> criteriaList;

    public void setCriteriaList(List<BaseCriteria> criteriaList) {
        this.criteriaList = new ArrayList<BaseCriteria>(criteriaList);
        this.notifyCriteriaUpdates();
    }

    public void clearCriteriaList() {
        if (this.criteriaList != null) {
            this.criteriaList.clear();
        }
        this.notifyCriteriaUpdates();
    }

    public void addCriteriaList(List<BaseCriteria> criteriaList) {
        if (this.criteriaList != null) {
            this.criteriaList.addAll(criteriaList);
        } else {
            this.setCriteriaList(criteriaList);
        }
        this.notifyCriteriaUpdates();
    }

    public void addCriteria(BaseCriteria criteria) {
        if (this.criteriaList == null) {
            this.criteriaList = new ArrayList<BaseCriteria>();
        }
        this.criteriaList.add(criteria);
        this.notifyCriteriaUpdates();
    }

    public void removeCriteria(BaseCriteria criteria) {
        if (this.criteriaList != null) {
            this.criteriaList.remove(criteria);
        }
        this.notifyCriteriaUpdates();
    }

    public void removeCriteriaList(List<BaseCriteria> listToDelete) {
        if (this.criteriaList != null) {
            this.criteriaList.removeAll(listToDelete);
        }
        this.notifyCriteriaUpdates();
    }

    private void notifyCriteriaUpdates() {
        if (this.onDaySelectedListener != null) {
            this.onDaySelectedListener.onDaySelected();
        }
    }

    public boolean hasCriteria() {
        return this.criteriaList != null && !this.criteriaList.isEmpty();
    }

    public boolean isDaySelectedByCriteria(Day day) {
        if (this.hasCriteria()) {
            for (BaseCriteria criteria : this.criteriaList) {
                if (!criteria.isCriteriaPassed(day)) continue;
                return true;
            }
        }
        return false;
    }
}

