/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.selection;

import android.support.annotation.NonNull;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.selection.BaseCriteriaSelectionManager;
import com.applikeysolutions.cosmocalendar.selection.OnDaySelectedListener;
import com.applikeysolutions.cosmocalendar.selection.criteria.BaseCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultipleSelectionManager
extends BaseCriteriaSelectionManager {
    private final Set<Day> days = new HashSet<Day>();

    public MultipleSelectionManager(OnDaySelectedListener onDaySelectedListener) {
        this.onDaySelectedListener = onDaySelectedListener;
    }

    public MultipleSelectionManager(BaseCriteria criteria, OnDaySelectedListener onDaySelectedListener) {
        this(new ArrayList<BaseCriteria>(Arrays.asList(criteria)), onDaySelectedListener);
    }

    public MultipleSelectionManager(List<BaseCriteria> criteriaList, OnDaySelectedListener onDaySelectedListener) {
        this.criteriaList = criteriaList;
        this.onDaySelectedListener = onDaySelectedListener;
    }

    @Override
    public void toggleDay(@NonNull Day day) {
        if (this.days.contains(day)) {
            this.days.remove(day);
        } else {
            this.days.add(day);
        }
        this.onDaySelectedListener.onDaySelected();
    }

    @Override
    public boolean isDaySelected(@NonNull Day day) {
        return this.days.contains(day) || this.isDaySelectedByCriteria(day);
    }

    @Override
    public void clearSelections() {
        this.days.clear();
    }

    public void removeDay(Day day) {
        this.days.remove(day);
        this.onDaySelectedListener.onDaySelected();
    }
}

