/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.selection;

import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.selection.BaseSelectionManager;
import com.applikeysolutions.cosmocalendar.selection.OnDaySelectedListener;
import com.applikeysolutions.cosmocalendar.selection.SelectionState;
import com.applikeysolutions.cosmocalendar.utils.DateUtils;

public class RangeSelectionManager
extends BaseSelectionManager {
    private Pair<Day, Day> days;
    private Day tempDay;

    public RangeSelectionManager(OnDaySelectedListener onDaySelectedListener) {
        this.onDaySelectedListener = onDaySelectedListener;
    }

    public Pair<Day, Day> getDays() {
        return this.days;
    }

    @Override
    public void toggleDay(@NonNull Day day) {
        if (this.days == null && this.tempDay == null || this.tempDay == null) {
            this.tempDay = day;
            this.days = null;
        } else {
            if (this.tempDay == day) {
                return;
            }
            this.days = this.tempDay.getCalendar().getTime().before(day.getCalendar().getTime()) ? Pair.create((Object)this.tempDay, (Object)day) : Pair.create((Object)day, (Object)this.tempDay);
            this.tempDay = null;
        }
        this.onDaySelectedListener.onDaySelected();
    }

    @Override
    public boolean isDaySelected(@NonNull Day day) {
        return this.isDaySelectedManually(day);
    }

    private boolean isDaySelectedManually(@NonNull Day day) {
        if (this.tempDay != null) {
            return day.equals(this.tempDay);
        }
        if (this.days != null) {
            return DateUtils.isDayInRange(day, (Day)this.days.first, (Day)this.days.second);
        }
        return false;
    }

    @Override
    public void clearSelections() {
        this.days = null;
        this.tempDay = null;
    }

    public SelectionState getSelectedState(Day day) {
        if (!this.isDaySelectedManually(day)) {
            return SelectionState.SINGLE_DAY;
        }
        if (this.days == null) {
            return SelectionState.START_RANGE_DAY_WITHOUT_END;
        }
        if (((Day)this.days.first).equals(day)) {
            return SelectionState.START_RANGE_DAY;
        }
        if (((Day)this.days.second).equals(day)) {
            return SelectionState.END_RANGE_DAY;
        }
        if (DateUtils.isDayInRange(day, (Day)this.days.first, (Day)this.days.second)) {
            return SelectionState.RANGE_DAY;
        }
        return SelectionState.SINGLE_DAY;
    }
}

