/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.selection.criteria;

import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.selection.criteria.BaseCriteria;

public class WeekDayCriteria
extends BaseCriteria {
    private int weekDay = -1;

    public WeekDayCriteria(int weekDay) {
        if (weekDay < 1 || weekDay > 7) {
            throw new IllegalArgumentException("Weekday must be from 1 to 7");
        }
        this.weekDay = weekDay;
    }

    @Override
    public boolean isCriteriaPassed(Day day) {
        return day.getCalendar().get(7) == this.weekDay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeekDayCriteria that = (WeekDayCriteria)o;
        return this.weekDay == that.weekDay;
    }

    public int hashCode() {
        return this.weekDay;
    }
}

