/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.selection.selectionbar;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.selection.selectionbar.SelectionBarContentItem;
import com.applikeysolutions.cosmocalendar.selection.selectionbar.SelectionBarItem;
import com.applikeysolutions.cosmocalendar.selection.selectionbar.SelectionBarTitleItem;
import com.applikeysolutions.cosmocalendar.view.CalendarView;
import com.applikeysolutions.cosmocalendar.view.customviews.CircleAnimationTextView;
import com.applikeysolutions.customizablecalendar.R;
import java.util.ArrayList;
import java.util.List;

public class MultipleSelectionBarAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private List<SelectionBarItem> items = new ArrayList<SelectionBarItem>();
    private CalendarView calendarView;
    private ListItemClickListener listItemClickListener;
    private static final int VIEW_TYPE_TITLE = 0;
    private static final int VIEW_TYPE_CONTENT = 1;

    public MultipleSelectionBarAdapter(CalendarView calendarView, ListItemClickListener listItemClickListener) {
        this.calendarView = calendarView;
        this.listItemClickListener = listItemClickListener;
    }

    public void setData(List<SelectionBarItem> items) {
        this.items = items;
        this.notifyDataSetChanged();
    }

    public void setListItemClickListener(ListItemClickListener listItemClickListener) {
        this.listItemClickListener = listItemClickListener;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return new TitleViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_multiple_selection_bar_title, parent, false));
        }
        return new ContentViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_multiple_selection_bar_content, parent, false));
    }

    public int getItemViewType(int position) {
        if (this.items.get(position) instanceof SelectionBarTitleItem) {
            return 0;
        }
        return 1;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.getItemViewType(position) == 0) {
            ((TitleViewHolder)holder).bind(position);
        } else {
            ((ContentViewHolder)holder).bind(position);
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    public static interface ListItemClickListener {
        public void onMultipleSelectionListItemClick(Day var1);
    }

    public class ContentViewHolder
    extends RecyclerView.ViewHolder {
        final CircleAnimationTextView catvDay;

        public ContentViewHolder(View itemView) {
            super(itemView);
            this.catvDay = (CircleAnimationTextView)itemView.findViewById(R.id.catv_day);
        }

        public void bind(int position) {
            final SelectionBarContentItem selectionBarContentItem = (SelectionBarContentItem)MultipleSelectionBarAdapter.this.items.get(position);
            this.catvDay.setText(String.valueOf(selectionBarContentItem.getDay().getDayNumber()));
            this.catvDay.setTextColor(MultipleSelectionBarAdapter.this.calendarView.getSelectedDayTextColor());
            this.catvDay.showAsSingleCircle(MultipleSelectionBarAdapter.this.calendarView);
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MultipleSelectionBarAdapter.this.listItemClickListener != null) {
                        MultipleSelectionBarAdapter.this.listItemClickListener.onMultipleSelectionListItemClick(selectionBarContentItem.getDay());
                    }
                }
            });
        }
    }

    public class TitleViewHolder
    extends RecyclerView.ViewHolder {
        final TextView tvTitle;

        public TitleViewHolder(View itemView) {
            super(itemView);
            this.tvTitle = (TextView)itemView.findViewById(R.id.tv_title);
        }

        public void bind(int position) {
            SelectionBarTitleItem selectionBarTitleItem = (SelectionBarTitleItem)MultipleSelectionBarAdapter.this.items.get(position);
            this.tvTitle.setText((CharSequence)selectionBarTitleItem.getTitle());
            this.tvTitle.setTextColor(MultipleSelectionBarAdapter.this.calendarView.getSelectionBarMonthTextColor());
        }
    }
}

