/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.utils;

import android.content.Context;
import android.view.WindowManager;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.model.DayOfWeek;
import com.applikeysolutions.cosmocalendar.model.Month;
import com.applikeysolutions.cosmocalendar.selection.selectionbar.SelectionBarContentItem;
import com.applikeysolutions.cosmocalendar.selection.selectionbar.SelectionBarItem;
import com.applikeysolutions.cosmocalendar.selection.selectionbar.SelectionBarTitleItem;
import com.applikeysolutions.cosmocalendar.settings.SettingsManager;
import com.applikeysolutions.cosmocalendar.utils.DateUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class CalendarUtils {
    public static Month createMonth(Date date, SettingsManager settingsManager) {
        ArrayList<Day> days = new ArrayList<Day>();
        Calendar firstDisplayedDayCalendar = Calendar.getInstance();
        Calendar firstDayOfMonthCalendar = Calendar.getInstance();
        Date firstDayOfMonth = DateUtils.getFirstDayOfMonth(date);
        firstDayOfMonthCalendar.setTime(firstDayOfMonth);
        firstDayOfMonthCalendar.get(2);
        int targetMonth = firstDayOfMonthCalendar.get(2);
        Date firstDisplayedDay = DateUtils.getFirstDayOfWeek(firstDayOfMonth, settingsManager.getFirstDayOfWeek());
        firstDisplayedDayCalendar.setTime(firstDisplayedDay);
        Calendar end = Calendar.getInstance();
        end.setTime(DateUtils.getLastDayOfWeek(DateUtils.getLastDayOfMonth(date)));
        if (settingsManager.isShowDaysOfWeek()) {
            days.addAll(CalendarUtils.createDaysOfWeek(firstDisplayedDay));
        }
        days.add(CalendarUtils.createDay(firstDisplayedDayCalendar, settingsManager, targetMonth));
        do {
            DateUtils.addDay(firstDisplayedDayCalendar);
            days.add(CalendarUtils.createDay(firstDisplayedDayCalendar, settingsManager, targetMonth));
        } while (!DateUtils.isSameDayOfMonth(firstDisplayedDayCalendar, end) || !DateUtils.isSameMonth(firstDisplayedDayCalendar, end));
        return new Month(CalendarUtils.createDay(firstDayOfMonthCalendar, settingsManager, targetMonth), days);
    }

    private static Day createDay(Calendar calendar, SettingsManager settingsManager, int targetMonth) {
        Day day = new Day(calendar);
        day.setBelongToMonth(calendar.get(2) == targetMonth);
        CalendarUtils.setDay(day, settingsManager);
        return day;
    }

    private static List<DayOfWeek> createDaysOfWeek(Date firstDisplayedDay) {
        ArrayList<DayOfWeek> daysOfTheWeek = new ArrayList<DayOfWeek>();
        Calendar calendar = DateUtils.getCalendar(firstDisplayedDay);
        int startDayOfTheWeek = calendar.get(7);
        do {
            daysOfTheWeek.add(new DayOfWeek(calendar.getTime()));
            DateUtils.addDay(calendar);
        } while (calendar.get(7) != startDayOfTheWeek);
        return daysOfTheWeek;
    }

    public static List<String> createWeekDayTitles(int firstDayOfWeek) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEEEE", Locale.getDefault());
        ArrayList<String> titles = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, firstDayOfWeek);
        do {
            titles.add(sdf.format(calendar.getTime()));
            DateUtils.addDay(calendar);
        } while (calendar.get(7) != firstDayOfWeek);
        return titles;
    }

    public static List<Month> createInitialMonths(SettingsManager settingsManager) {
        int i;
        ArrayList<Month> months = new ArrayList<Month>();
        Calendar calendar = Calendar.getInstance();
        for (i = 0; i < 10; ++i) {
            calendar.add(2, -1);
        }
        for (i = 0; i < 20; ++i) {
            months.add(CalendarUtils.createMonth(calendar.getTime(), settingsManager));
            DateUtils.addMonth(calendar);
        }
        return months;
    }

    public static List<SelectionBarItem> getSelectedDayListForMultipleMode(List<Day> selectedDays) {
        ArrayList<SelectionBarItem> result = new ArrayList<SelectionBarItem>();
        Calendar tempCalendar = Calendar.getInstance();
        int tempYear = -1;
        int tempMonth = -1;
        for (Day day : selectedDays) {
            tempCalendar.setTime(day.getCalendar().getTime());
            if (tempCalendar.get(1) != tempYear || tempCalendar.get(2) != tempMonth) {
                result.add(new SelectionBarTitleItem(CalendarUtils.getYearNameTitle(day)));
                tempYear = tempCalendar.get(1);
                tempMonth = tempCalendar.get(2);
            }
            result.add(new SelectionBarContentItem(day));
        }
        return result;
    }

    public static String getYearNameTitle(Day day) {
        return new SimpleDateFormat("MMM''yy").format(day.getCalendar().getTime());
    }

    public static int getCircleWidth(Context context) {
        return CalendarUtils.getDisplayWidth(context) / 7;
    }

    public static int getDisplayWidth(Context context) {
        return ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getWidth();
    }

    public static void setDay(Day day, SettingsManager settingsManager) {
        if (settingsManager.getWeekendDays() != null) {
            day.setWeekend(settingsManager.getWeekendDays().contains(day.getCalendar().get(7)));
        }
        if (settingsManager.getDisabledDays() != null) {
            day.setDisabled(CalendarUtils.isDayInSet(day, settingsManager.getDisabledDays()));
        }
        if (settingsManager.getConnectedCalendarDays() != null) {
            day.setFromConnectedCalendar(CalendarUtils.isDayInSet(day, settingsManager.getConnectedCalendarDays()));
        }
    }

    public static boolean isDayInSet(Day day, Set<Long> daysInSet) {
        for (long disabledTime : daysInSet) {
            Calendar disabledDayCalendar = DateUtils.getCalendar(disabledTime);
            if (day.getCalendar().get(1) != disabledDayCalendar.get(1) || day.getCalendar().get(6) != disabledDayCalendar.get(6)) continue;
            return true;
        }
        return false;
    }
}

