/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.applikeysolutions.cosmocalendar.model.Day;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar getCalendar(long timeInMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        return calendar;
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getFirstDayOfWeek(@NonNull Date date, int firstDayOfWeek) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.clear(11);
        calendar.clear(10);
        while (calendar.get(7) != firstDayOfWeek) {
            calendar.add(5, -1);
        }
        return calendar.getTime();
    }

    public static Date getLastDayOfWeek(@Nullable Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.clear(11);
        calendar.clear(10);
        if (calendar.get(5) == calendar.getActualMaximum(5) && calendar.get(7) == 1) {
            return calendar.getTime();
        }
        calendar.set(7, calendar.getActualMaximum(7));
        while (calendar.get(7) != 1) {
            calendar.add(5, 1);
        }
        return calendar.getTime();
    }

    public static boolean isSameMonth(Calendar calendar1, Calendar calendar2) {
        return calendar1.get(2) == calendar2.get(2);
    }

    public static boolean isSameDayOfMonth(Calendar calendar1, Calendar calendar2) {
        return calendar1.get(5) == calendar2.get(5);
    }

    public static Calendar addMonth(Calendar calendar) {
        calendar.add(2, 1);
        return calendar;
    }

    public static Calendar addDay(Calendar calendar) {
        calendar.add(5, 1);
        return calendar;
    }

    public static boolean isCurrentDate(Date date) {
        return date != null ? android.text.format.DateUtils.isToday((long)date.getTime()) : false;
    }

    public static boolean isDayInRange(Day day, Day dayStart, Day dayEnd) {
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.setTime(dayStart.getCalendar().getTime());
        DateUtils.setCalendarToStartOfDay(calendarStart);
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(dayEnd.getCalendar().getTime());
        DateUtils.setCalendarToEndOfDay(calendarEnd);
        return day.getCalendar().getTimeInMillis() >= calendarStart.getTimeInMillis() && day.getCalendar().getTimeInMillis() <= calendarEnd.getTimeInMillis();
    }

    private static void setCalendarToStartOfDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void setCalendarToEndOfDay(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 59);
    }
}

