/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.Pair;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.applikeysolutions.cosmocalendar.adapter.MonthAdapter;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.model.Month;
import com.applikeysolutions.cosmocalendar.selection.BaseSelectionManager;
import com.applikeysolutions.cosmocalendar.selection.MultipleSelectionManager;
import com.applikeysolutions.cosmocalendar.selection.OnDaySelectedListener;
import com.applikeysolutions.cosmocalendar.selection.RangeSelectionManager;
import com.applikeysolutions.cosmocalendar.selection.SingleSelectionManager;
import com.applikeysolutions.cosmocalendar.selection.selectionbar.MultipleSelectionBarAdapter;
import com.applikeysolutions.cosmocalendar.selection.selectionbar.SelectionBarItem;
import com.applikeysolutions.cosmocalendar.settings.SettingsManager;
import com.applikeysolutions.cosmocalendar.settings.appearance.AppearanceInterface;
import com.applikeysolutions.cosmocalendar.settings.date.DateInterface;
import com.applikeysolutions.cosmocalendar.settings.lists.CalendarListsInterface;
import com.applikeysolutions.cosmocalendar.settings.selection.SelectionInterface;
import com.applikeysolutions.cosmocalendar.utils.CalendarUtils;
import com.applikeysolutions.cosmocalendar.utils.snap.GravitySnapHelper;
import com.applikeysolutions.cosmocalendar.view.SlowdownRecyclerView;
import com.applikeysolutions.cosmocalendar.view.customviews.CircleAnimationTextView;
import com.applikeysolutions.cosmocalendar.view.customviews.SquareTextView;
import com.applikeysolutions.cosmocalendar.view.delegate.MonthDelegate;
import com.applikeysolutions.customizablecalendar.R;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class CalendarView
extends RelativeLayout
implements OnDaySelectedListener,
AppearanceInterface,
DateInterface,
CalendarListsInterface,
SelectionInterface,
MultipleSelectionBarAdapter.ListItemClickListener {
    private List<Day> selectedDays;
    private SlowdownRecyclerView rvMonths;
    private MonthAdapter monthAdapter;
    private FrameLayout flBottomSelectionBar;
    private RecyclerView rvMultipleSelectedList;
    private MultipleSelectionBarAdapter multipleSelectionBarAdapter;
    private LinearLayout llRangeSelection;
    private LinearLayout llDaysOfWeekTitles;
    private FrameLayout flNavigationButtons;
    private ImageView ivPrevious;
    private ImageView ivNext;
    private SettingsManager settingsManager;
    private BaseSelectionManager selectionManager;
    private GravitySnapHelper snapHelper;
    private int lastVisibleMonthPosition = 10;
    private boolean isUpdating = false;
    private final Handler dataUpdateNotifier = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            CalendarView.this.monthAdapter.notifyItemRangeInserted(msg.arg1, msg.arg2);
            CalendarView.this.isUpdating = false;
            return true;
        }
    });
    private RecyclerView.OnScrollListener pagingScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            View view = CalendarView.this.rvMonths.getLayoutManager().findViewByPosition(CalendarView.this.getFirstVisiblePosition(CalendarView.this.rvMonths.getLayoutManager()));
            if (view != null) {
                view.requestLayout();
            }
            if (CalendarView.this.getCalendarOrientation() == 0) {
                CalendarView.this.multipleSelectionBarAdapter.notifyDataSetChanged();
                boolean show = newState != 1;
                CalendarView.this.ivPrevious.setVisibility(show ? 0 : 8);
                CalendarView.this.ivNext.setVisibility(show ? 0 : 8);
            }
            super.onScrollStateChanged(recyclerView, newState);
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            RecyclerView.LayoutManager manager = CalendarView.this.rvMonths.getLayoutManager();
            int totalItemCount = manager.getItemCount();
            int firstVisibleItemPosition = CalendarView.this.getFirstVisiblePosition(manager);
            CalendarView.this.lastVisibleMonthPosition = firstVisibleItemPosition;
            if (firstVisibleItemPosition < 2) {
                CalendarView.this.loadMoreMonths(false);
            } else if (firstVisibleItemPosition >= totalItemCount - 2) {
                CalendarView.this.loadMoreMonths(true);
            }
        }
    };

    public CalendarView(Context context) {
        super(context);
        this.init();
    }

    public CalendarView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.handleAttributes(attrs, 0, 0);
    }

    public CalendarView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.handleAttributes(attrs, defStyle, 0);
    }

    @TargetApi(value=21)
    public CalendarView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.handleAttributes(attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAttributes(AttributeSet attrs, int defStyle, int defStyleRes) {
        this.settingsManager = new SettingsManager();
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.CalendarView, defStyle, defStyleRes);
        try {
            this.handleAttributes(typedArray);
            this.handleWeekendDaysAttributes(typedArray);
        }
        finally {
            typedArray.recycle();
        }
        this.init();
    }

    private void handleAttributes(TypedArray typedArray) {
        int orientation = typedArray.getInteger(R.styleable.CalendarView_orientation, 1);
        int firstDayOfWeek = typedArray.getInteger(R.styleable.CalendarView_firstDayOfTheWeek, 2);
        int selectionType = typedArray.getInteger(R.styleable.CalendarView_selectionType, 0);
        boolean showDaysOfWeekTitle = orientation != 0;
        boolean showDaysOfWeek = orientation == 0;
        int calendarBackgroundColor = typedArray.getColor(R.styleable.CalendarView_calendarBackgroundColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_calendar_background_color));
        int monthTextColor = typedArray.getColor(R.styleable.CalendarView_monthTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_month_text_color));
        int otherDayTextColor = typedArray.getColor(R.styleable.CalendarView_otherDayTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_other_day_text_color));
        int dayTextColor = typedArray.getColor(R.styleable.CalendarView_dayTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_day_text_color));
        int weekendDayTextColor = typedArray.getColor(R.styleable.CalendarView_weekendDayTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_weekend_day_text_color));
        int weekDayTitleTextColor = typedArray.getColor(R.styleable.CalendarView_weekDayTitleTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_week_day_title_text_color));
        int selectedDayTextColor = typedArray.getColor(R.styleable.CalendarView_selectedDayTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_selected_day_text_color));
        int selectedDayBackgroundColor = typedArray.getColor(R.styleable.CalendarView_selectedDayBackgroundColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_selected_day_background_color));
        int selectedDayBackgroundStartColor = typedArray.getColor(R.styleable.CalendarView_selectedDayBackgroundStartColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_selected_day_background_start_color));
        int selectedDayBackgroundEndColor = typedArray.getColor(R.styleable.CalendarView_selectedDayBackgroundEndColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_selected_day_background_end_color));
        int currentDayTextColor = typedArray.getColor(R.styleable.CalendarView_currentDayTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_day_text_color));
        int currentDayIconRes = typedArray.getResourceId(R.styleable.CalendarView_currentDayIconRes, R.drawable.ic_triangle_green);
        int currentDaySelectedIconRes = typedArray.getResourceId(R.styleable.CalendarView_currentDaySelectedIconRes, R.drawable.ic_triangle_white);
        int connectedDayTextColor = typedArray.getColor(R.styleable.CalendarView_connectedDayTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_connected_day_text_color));
        int connectedDaySelectedTextColor = typedArray.getColor(R.styleable.CalendarView_connectedDaySelectedTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_connected_day_selected_text_color));
        int disabledDayTextColor = typedArray.getColor(R.styleable.CalendarView_disabledDayTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_disabled_day_text_color));
        int selectionBarMonthTextColor = typedArray.getColor(R.styleable.CalendarView_selectionBarMonthTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_selection_bar_month_title_text_color));
        int previousMonthIconRes = typedArray.getResourceId(R.styleable.CalendarView_currentDayIconRes, R.drawable.ic_chevron_left_gray);
        int nextMonthIconRes = typedArray.getResourceId(R.styleable.CalendarView_currentDayIconRes, R.drawable.ic_chevron_right_gray);
        this.setBackgroundColor(calendarBackgroundColor);
        this.settingsManager.setCalendarBackgroundColor(calendarBackgroundColor);
        this.settingsManager.setMonthTextColor(monthTextColor);
        this.settingsManager.setOtherDayTextColor(otherDayTextColor);
        this.settingsManager.setDayTextColor(dayTextColor);
        this.settingsManager.setWeekendDayTextColor(weekendDayTextColor);
        this.settingsManager.setWeekDayTitleTextColor(weekDayTitleTextColor);
        this.settingsManager.setSelectedDayTextColor(selectedDayTextColor);
        this.settingsManager.setSelectedDayBackgroundColor(selectedDayBackgroundColor);
        this.settingsManager.setSelectedDayBackgroundStartColor(selectedDayBackgroundStartColor);
        this.settingsManager.setSelectedDayBackgroundEndColor(selectedDayBackgroundEndColor);
        this.settingsManager.setConnectedDayTextColor(connectedDayTextColor);
        this.settingsManager.setConnectedDaySelectedTextColor(connectedDaySelectedTextColor);
        this.settingsManager.setDisabledDayTextColor(disabledDayTextColor);
        this.settingsManager.setSelectionBarMonthTextColor(selectionBarMonthTextColor);
        this.settingsManager.setCurrentDayTextColor(currentDayTextColor);
        this.settingsManager.setCurrentDayIconRes(currentDayIconRes);
        this.settingsManager.setCurrentDaySelectedIconRes(currentDaySelectedIconRes);
        this.settingsManager.setCalendarOrientation(orientation);
        this.settingsManager.setFirstDayOfWeek(firstDayOfWeek);
        this.settingsManager.setShowDaysOfWeek(showDaysOfWeek);
        this.settingsManager.setShowDaysOfWeekTitle(showDaysOfWeekTitle);
        this.settingsManager.setSelectionType(selectionType);
        this.settingsManager.setPreviousMonthIconRes(previousMonthIconRes);
        this.settingsManager.setNextMonthIconRes(nextMonthIconRes);
    }

    private void handleWeekendDaysAttributes(TypedArray typedArray) {
        if (typedArray.hasValue(R.styleable.CalendarView_weekendDays)) {
            TreeSet<Long> weekendDays = new TreeSet<Long>();
            int weekdaysAttr = typedArray.getInteger(R.styleable.CalendarView_weekendDays, 64);
            if (this.containsFlag(weekdaysAttr, 1)) {
                weekendDays.add(2L);
            }
            if (this.containsFlag(weekdaysAttr, 2)) {
                weekendDays.add(3L);
            }
            if (this.containsFlag(weekdaysAttr, 4)) {
                weekendDays.add(4L);
            }
            if (this.containsFlag(weekdaysAttr, 8)) {
                weekendDays.add(5L);
            }
            if (this.containsFlag(weekdaysAttr, 16)) {
                weekendDays.add(6L);
            }
            if (this.containsFlag(weekdaysAttr, 32)) {
                weekendDays.add(7L);
            }
            if (this.containsFlag(weekdaysAttr, 64)) {
                weekendDays.add(1L);
            }
            this.settingsManager.setWeekendDays(weekendDays);
        }
    }

    private boolean containsFlag(int attr, int flag) {
        return (attr | flag) == attr;
    }

    private void init() {
        this.setDaysOfWeekTitles();
        this.setSelectionManager();
        this.createRecyclerView();
        this.createBottomSelectionBar();
        if (this.settingsManager.getCalendarOrientation() == 0) {
            this.createNavigationButtons();
        }
    }

    private void setDaysOfWeekTitles() {
        this.settingsManager.setShowDaysOfWeekTitle(this.settingsManager.getCalendarOrientation() != 0);
        this.settingsManager.setShowDaysOfWeek(this.settingsManager.getCalendarOrientation() == 0);
        if (this.llDaysOfWeekTitles == null) {
            this.createDaysOfWeekTitle();
        }
        if (this.settingsManager.isShowDaysOfWeekTitle()) {
            this.showDaysOfWeekTitle();
        } else {
            this.hideDaysOfWeekTitle();
        }
    }

    private void createDaysOfWeekTitle() {
        boolean isTitleAlreadyAdded;
        boolean bl = isTitleAlreadyAdded = this.llDaysOfWeekTitles != null;
        if (!isTitleAlreadyAdded) {
            this.llDaysOfWeekTitles = new LinearLayout(this.getContext());
            this.llDaysOfWeekTitles.setId(View.generateViewId());
            this.llDaysOfWeekTitles.setOrientation(0);
            this.llDaysOfWeekTitles.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        } else {
            this.llDaysOfWeekTitles.removeAllViews();
        }
        LinearLayout.LayoutParams textViewParam = new LinearLayout.LayoutParams(-2, -2);
        textViewParam.weight = 1.0f;
        for (String title : CalendarUtils.createWeekDayTitles(this.settingsManager.getFirstDayOfWeek())) {
            SquareTextView tvDayTitle = new SquareTextView(this.getContext());
            tvDayTitle.setText(title);
            tvDayTitle.setLayoutParams((ViewGroup.LayoutParams)textViewParam);
            tvDayTitle.setGravity(17);
            this.llDaysOfWeekTitles.addView((View)tvDayTitle);
        }
        this.llDaysOfWeekTitles.setBackgroundResource(R.drawable.border_top_bottom);
        if (!isTitleAlreadyAdded) {
            this.addView((View)this.llDaysOfWeekTitles);
        }
    }

    private void createBottomSelectionBar() {
        this.flBottomSelectionBar = new FrameLayout(this.getContext());
        this.flBottomSelectionBar.setId(View.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(3, this.rvMonths.getId());
        this.flBottomSelectionBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.flBottomSelectionBar.setBackgroundResource(R.drawable.border_top_bottom);
        this.flBottomSelectionBar.setVisibility(this.settingsManager.getCalendarOrientation() == 0 ? 0 : 8);
        this.addView((View)this.flBottomSelectionBar);
        this.createMultipleSelectionBarRecycler();
        this.createRangeSelectionLayout();
    }

    private void createMultipleSelectionBarRecycler() {
        this.rvMultipleSelectedList = new RecyclerView(this.getContext());
        this.rvMultipleSelectedList.setId(View.generateViewId());
        this.rvMultipleSelectedList.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.rvMultipleSelectedList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        this.multipleSelectionBarAdapter = new MultipleSelectionBarAdapter(this, this);
        this.rvMultipleSelectedList.setAdapter((RecyclerView.Adapter)this.multipleSelectionBarAdapter);
        this.flBottomSelectionBar.addView((View)this.rvMultipleSelectedList);
    }

    private void createRangeSelectionLayout() {
        this.llRangeSelection = (LinearLayout)((LayoutInflater)this.getContext().getSystemService("layout_inflater")).inflate(R.layout.view_selection_bar_range, null);
        this.llRangeSelection.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.llRangeSelection.setVisibility(8);
        this.flBottomSelectionBar.addView((View)this.llRangeSelection);
    }

    private void showDaysOfWeekTitle() {
        this.llDaysOfWeekTitles.setVisibility(0);
    }

    private void hideDaysOfWeekTitle() {
        this.llDaysOfWeekTitles.setVisibility(8);
    }

    private void setSelectionManager() {
        switch (this.getSelectionType()) {
            case 0: {
                this.selectionManager = new SingleSelectionManager(this);
                break;
            }
            case 1: {
                this.selectionManager = new MultipleSelectionManager(this);
                break;
            }
            case 2: {
                this.selectionManager = new RangeSelectionManager(this);
            }
        }
    }

    public void setSelectionManager(BaseSelectionManager selectionManager) {
        this.selectionManager = selectionManager;
        this.monthAdapter.setSelectionManager(selectionManager);
        this.update();
    }

    public BaseSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void update() {
        if (this.monthAdapter != null) {
            this.monthAdapter.notifyDataSetChanged();
            this.rvMonths.scrollToPosition(this.lastVisibleMonthPosition);
            this.multipleSelectionBarAdapter.notifyDataSetChanged();
        }
    }

    private void createRecyclerView() {
        this.rvMonths = new SlowdownRecyclerView(this.getContext());
        this.rvMonths.setId(View.generateViewId());
        this.rvMonths.setHasFixedSize(true);
        this.rvMonths.setNestedScrollingEnabled(false);
        ((SimpleItemAnimator)this.rvMonths.getItemAnimator()).setSupportsChangeAnimations(false);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(3, this.llDaysOfWeekTitles.getId());
        this.rvMonths.setLayoutParams((ViewGroup.LayoutParams)params);
        this.rvMonths.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 1, this.settingsManager.getCalendarOrientation(), false));
        this.monthAdapter = this.createAdapter();
        this.changeSnapHelper();
        this.rvMonths.setAdapter(this.monthAdapter);
        this.rvMonths.scrollToPosition(10);
        this.rvMonths.addOnScrollListener(this.pagingScrollListener);
        this.rvMonths.getRecycledViewPool().setMaxRecycledViews(0, 10);
        this.addView((View)this.rvMonths);
    }

    private void createNavigationButtons() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        this.flNavigationButtons = (FrameLayout)inflater.inflate(R.layout.calendar_navigation_buttons, (ViewGroup)this, false);
        this.setPreviousNavigationButton();
        this.setNextNavigationButton();
        this.addView((View)this.flNavigationButtons);
    }

    private void setPreviousNavigationButton() {
        this.ivPrevious = (ImageView)this.flNavigationButtons.findViewById(R.id.iv_previous_month);
        this.ivPrevious.setImageResource(this.settingsManager.getPreviousMonthIconRes());
        this.ivPrevious.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CalendarView.this.goToPreviousMonth();
            }
        });
    }

    private void setNextNavigationButton() {
        this.ivNext = (ImageView)this.flNavigationButtons.findViewById(R.id.iv_next_month);
        this.ivNext.setImageResource(this.settingsManager.getNextMonthIconRes());
        this.ivNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CalendarView.this.goToNextMonth();
            }
        });
    }

    private MonthAdapter createAdapter() {
        return new MonthAdapter.MonthAdapterBuilder().setMonths(CalendarUtils.createInitialMonths(this.settingsManager)).setMonthDelegate(new MonthDelegate(this.settingsManager)).setCalendarView(this).setSelectionManager(this.selectionManager).createMonthAdapter();
    }

    private int getFirstVisiblePosition(RecyclerView.LayoutManager manager) {
        if (manager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)manager).findFirstVisibleItemPosition();
        }
        throw new IllegalArgumentException("Unsupported Layout Manager");
    }

    private void loadMoreMonths(final boolean future) {
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Month month = future ? CalendarView.this.monthAdapter.getData().get(CalendarView.this.monthAdapter.getData().size() - 1) : CalendarView.this.monthAdapter.getData().get(0);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(month.getFirstDay().getCalendar().getTime());
                ArrayList<Month> result = new ArrayList<Month>();
                for (int i = 0; i < 20; ++i) {
                    calendar.add(2, future ? 1 : -1);
                    Month newMonth = CalendarUtils.createMonth(calendar.getTime(), CalendarView.this.settingsManager);
                    if (future) {
                        result.add(newMonth);
                        continue;
                    }
                    result.add(0, newMonth);
                }
                if (!result.isEmpty()) {
                    if (future) {
                        CalendarView.this.monthAdapter.getData().addAll(result);
                        CalendarView.this.dataUpdateNotifier.sendMessage(Message.obtain((Handler)CalendarView.this.dataUpdateNotifier, (int)0, (int)(CalendarView.this.monthAdapter.getData().size() - 1), (int)20));
                    } else {
                        CalendarView.this.monthAdapter.getData().addAll(0, result);
                        CalendarView.this.dataUpdateNotifier.sendMessage(Message.obtain((Handler)CalendarView.this.dataUpdateNotifier, (int)0, (int)0, (int)20));
                    }
                } else {
                    CalendarView.this.isUpdating = false;
                }
            }
        }).start();
    }

    @Override
    public Set<Long> getDisabledDays() {
        return null;
    }

    @Override
    public Set<Long> getConnectedCalendarDays() {
        return null;
    }

    @Override
    public Set<Long> getWeekendDays() {
        return null;
    }

    @Override
    public void setDisabledDays(Set<Long> disabledDays) {
        this.settingsManager.setDisabledDays(disabledDays);
        this.monthAdapter.setDisabledDays(disabledDays);
    }

    @Override
    public void setConnectedCalendarDays(Set<Long> connectedCalendarDays) {
        this.settingsManager.setConnectedCalendarDays(connectedCalendarDays);
        this.monthAdapter.setConnectedCalendarDays(connectedCalendarDays);
    }

    @Override
    public void setWeekendDays(Set<Long> weekendDays) {
        this.settingsManager.setWeekendDays(weekendDays);
        this.monthAdapter.setWeekendDays(weekendDays);
    }

    public void clearSelections() {
        this.selectionManager.clearSelections();
        if (this.selectionManager instanceof MultipleSelectionManager) {
            ((MultipleSelectionManager)this.selectionManager).clearCriteriaList();
        }
        this.multipleSelectionBarAdapter.setData(new ArrayList<SelectionBarItem>());
        this.setSelectionBarVisibility();
        this.update();
    }

    public List<Day> getSelectedDays() {
        ArrayList<Day> selectedDays = new ArrayList<Day>();
        for (Month month : this.monthAdapter.getData()) {
            for (Day day : month.getDaysWithoutTitlesAndOnlyCurrent()) {
                if (!this.selectionManager.isDaySelected(day)) continue;
                selectedDays.add(day);
            }
        }
        return selectedDays;
    }

    public List<Calendar> getSelectedDates() {
        ArrayList<Calendar> selectedDays = new ArrayList<Calendar>();
        for (Day day : this.getSelectedDays()) {
            selectedDays.add(day.getCalendar());
        }
        return selectedDays;
    }

    public void goToPreviousMonth() {
        int currentVisibleItemPosition = ((GridLayoutManager)this.rvMonths.getLayoutManager()).findFirstVisibleItemPosition();
        if (currentVisibleItemPosition != 0) {
            this.rvMonths.smoothScrollToPosition(currentVisibleItemPosition - 1);
        }
    }

    public void goToNextMonth() {
        int currentVisibleItemPosition = ((GridLayoutManager)this.rvMonths.getLayoutManager()).findFirstVisibleItemPosition();
        if (currentVisibleItemPosition != this.monthAdapter.getData().size() - 1) {
            this.rvMonths.smoothScrollToPosition(currentVisibleItemPosition + 1);
        }
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    private void recreateInitialMonth() {
        this.monthAdapter.getData().clear();
        this.monthAdapter.getData().addAll(CalendarUtils.createInitialMonths(this.settingsManager));
        this.lastVisibleMonthPosition = 10;
    }

    @Override
    public void onDaySelected() {
        this.selectedDays = this.getSelectedDays();
        this.displaySelectedDays();
    }

    private void displaySelectedDays() {
        switch (this.settingsManager.getSelectionType()) {
            case 1: {
                this.displaySelectedDaysMultiple();
                break;
            }
            case 2: {
                this.displaySelectedDaysRange();
                break;
            }
            default: {
                this.llRangeSelection.setVisibility(8);
            }
        }
    }

    private void displaySelectedDaysMultiple() {
        this.multipleSelectionBarAdapter.setData(CalendarUtils.getSelectedDayListForMultipleMode(this.selectedDays));
    }

    private void displaySelectedDaysRange() {
        if (this.selectionManager instanceof RangeSelectionManager) {
            Pair<Day, Day> days = ((RangeSelectionManager)this.selectionManager).getDays();
            if (days != null) {
                this.llRangeSelection.setVisibility(0);
                TextView tvStartRangeTitle = (TextView)this.llRangeSelection.findViewById(R.id.tv_range_start_date);
                tvStartRangeTitle.setText((CharSequence)CalendarUtils.getYearNameTitle((Day)days.first));
                tvStartRangeTitle.setTextColor(this.getSelectionBarMonthTextColor());
                TextView tvEndRangeTitle = (TextView)this.llRangeSelection.findViewById(R.id.tv_range_end_date);
                tvEndRangeTitle.setText((CharSequence)CalendarUtils.getYearNameTitle((Day)days.second));
                tvEndRangeTitle.setTextColor(this.getSelectionBarMonthTextColor());
                CircleAnimationTextView catvStart = (CircleAnimationTextView)this.llRangeSelection.findViewById(R.id.catv_start);
                catvStart.setText(String.valueOf(((Day)days.first).getDayNumber()));
                catvStart.setTextColor(this.getSelectedDayTextColor());
                catvStart.showAsStartCircle(this, true);
                CircleAnimationTextView catvEnd = (CircleAnimationTextView)this.llRangeSelection.findViewById(R.id.catv_end);
                catvEnd.setText(String.valueOf(((Day)days.second).getDayNumber()));
                catvEnd.setTextColor(this.getSelectedDayTextColor());
                catvEnd.showAsEndCircle(this, true);
                CircleAnimationTextView catvMiddle = (CircleAnimationTextView)this.llRangeSelection.findViewById(R.id.catv_middle);
                catvMiddle.showAsRange(this);
            } else {
                this.llRangeSelection.setVisibility(8);
            }
        }
    }

    private boolean needToShowSelectedDaysRange() {
        return this.getCalendarOrientation() == 0 && this.getSelectionType() == 2 && this.selectionManager instanceof RangeSelectionManager && ((RangeSelectionManager)this.selectionManager).getDays() != null;
    }

    private void setSelectionBarVisibility() {
        this.flBottomSelectionBar.setVisibility(this.getCalendarOrientation() == 0 ? 0 : 8);
        this.rvMultipleSelectedList.setVisibility(this.getCalendarOrientation() == 0 && this.getSelectionType() == 1 ? 0 : 8);
        this.llRangeSelection.setVisibility(this.needToShowSelectedDaysRange() ? 0 : 8);
    }

    @Override
    public int getSelectionType() {
        return this.settingsManager.getSelectionType();
    }

    @Override
    public void setSelectionType(int selectionType) {
        this.settingsManager.setSelectionType(selectionType);
        this.setSelectionManager();
        this.monthAdapter.setSelectionManager(this.selectionManager);
        this.setSelectionBarVisibility();
        this.multipleSelectionBarAdapter.setData(new ArrayList<SelectionBarItem>());
        this.selectionManager.clearSelections();
        if (this.selectionManager instanceof MultipleSelectionManager) {
            ((MultipleSelectionManager)this.selectionManager).clearCriteriaList();
        }
        this.update();
    }

    @Override
    public int getCalendarBackgroundColor() {
        return this.settingsManager.getCalendarBackgroundColor();
    }

    @Override
    public int getMonthTextColor() {
        return this.settingsManager.getMonthTextColor();
    }

    @Override
    public int getOtherDayTextColor() {
        return this.settingsManager.getOtherDayTextColor();
    }

    @Override
    public int getDayTextColor() {
        return this.settingsManager.getDayTextColor();
    }

    @Override
    public int getWeekendDayTextColor() {
        return this.settingsManager.getWeekendDayTextColor();
    }

    @Override
    public int getWeekDayTitleTextColor() {
        return this.settingsManager.getWeekDayTitleTextColor();
    }

    @Override
    public int getSelectedDayTextColor() {
        return this.settingsManager.getSelectedDayTextColor();
    }

    @Override
    public int getSelectedDayBackgroundColor() {
        return this.settingsManager.getSelectedDayBackgroundColor();
    }

    @Override
    public int getSelectedDayBackgroundStartColor() {
        return this.settingsManager.getSelectedDayBackgroundStartColor();
    }

    @Override
    public int getSelectedDayBackgroundEndColor() {
        return this.settingsManager.getSelectedDayBackgroundEndColor();
    }

    @Override
    public int getCurrentDayTextColor() {
        return this.settingsManager.getCurrentDayTextColor();
    }

    @Override
    public int getCurrentDayIconRes() {
        return this.settingsManager.getCurrentDayIconRes();
    }

    @Override
    public int getCurrentDaySelectedIconRes() {
        return this.settingsManager.getCurrentDaySelectedIconRes();
    }

    @Override
    public int getCalendarOrientation() {
        return this.settingsManager.getCalendarOrientation();
    }

    @Override
    public int getConnectedDayTextColor() {
        return this.settingsManager.getConnectedDayTextColor();
    }

    @Override
    public int getConnectedDaySelectedTextColor() {
        return this.settingsManager.getConnectedDaySelectedTextColor();
    }

    @Override
    public int getDisabledDayTextColor() {
        return this.settingsManager.getDisabledDayTextColor();
    }

    @Override
    public int getSelectionBarMonthTextColor() {
        return this.settingsManager.getSelectionBarMonthTextColor();
    }

    @Override
    public int getPreviousMonthIconRes() {
        return this.settingsManager.getPreviousMonthIconRes();
    }

    @Override
    public int getNextMonthIconRes() {
        return this.settingsManager.getNextMonthIconRes();
    }

    @Override
    public boolean isShowDaysOfWeek() {
        return this.settingsManager.isShowDaysOfWeek();
    }

    @Override
    public boolean isShowDaysOfWeekTitle() {
        return this.settingsManager.isShowDaysOfWeekTitle();
    }

    @Override
    public void setCalendarBackgroundColor(int calendarBackgroundColor) {
        this.settingsManager.setCalendarBackgroundColor(calendarBackgroundColor);
        this.setBackgroundColor(calendarBackgroundColor);
    }

    @Override
    public void setMonthTextColor(int monthTextColor) {
        this.settingsManager.setMonthTextColor(monthTextColor);
        this.update();
    }

    @Override
    public void setOtherDayTextColor(int otherDayTextColor) {
        this.settingsManager.setOtherDayTextColor(otherDayTextColor);
        this.update();
    }

    @Override
    public void setDayTextColor(int dayTextColor) {
        this.settingsManager.setDayTextColor(dayTextColor);
        this.update();
    }

    @Override
    public void setWeekendDayTextColor(int weekendDayTextColor) {
        this.settingsManager.setWeekendDayTextColor(weekendDayTextColor);
        this.update();
    }

    @Override
    public void setWeekDayTitleTextColor(int weekDayTitleTextColor) {
        this.settingsManager.setWeekDayTitleTextColor(weekDayTitleTextColor);
        for (int i = 0; i < this.llDaysOfWeekTitles.getChildCount(); ++i) {
            ((SquareTextView)this.llDaysOfWeekTitles.getChildAt(i)).setTextColor(weekDayTitleTextColor);
        }
        this.update();
    }

    @Override
    public void setSelectedDayTextColor(int selectedDayTextColor) {
        this.settingsManager.setSelectedDayTextColor(selectedDayTextColor);
        this.update();
    }

    @Override
    public void setSelectedDayBackgroundColor(int selectedDayBackgroundColor) {
        this.settingsManager.setSelectedDayBackgroundColor(selectedDayBackgroundColor);
        this.update();
    }

    @Override
    public void setSelectedDayBackgroundStartColor(int selectedDayBackgroundStartColor) {
        this.settingsManager.setSelectedDayBackgroundStartColor(selectedDayBackgroundStartColor);
        this.update();
    }

    @Override
    public void setSelectedDayBackgroundEndColor(int selectedDayBackgroundEndColor) {
        this.settingsManager.setSelectedDayBackgroundEndColor(selectedDayBackgroundEndColor);
        this.update();
    }

    @Override
    public void setCurrentDayTextColor(int currentDayTextColor) {
        this.settingsManager.setCurrentDayTextColor(currentDayTextColor);
        this.update();
    }

    @Override
    public void setCurrentDayIconRes(int currentDayIconRes) {
        this.settingsManager.setCurrentDayIconRes(currentDayIconRes);
        this.update();
    }

    @Override
    public void setCurrentDaySelectedIconRes(int currentDaySelectedIconRes) {
        this.settingsManager.setCurrentDaySelectedIconRes(currentDaySelectedIconRes);
        this.update();
    }

    @Override
    public void setCalendarOrientation(int calendarOrientation) {
        this.clearSelections();
        this.settingsManager.setCalendarOrientation(calendarOrientation);
        this.setDaysOfWeekTitles();
        this.recreateInitialMonth();
        this.rvMonths.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 1, this.getCalendarOrientation(), false));
        this.changeSnapHelper();
        if (this.getCalendarOrientation() == 0) {
            if (this.flNavigationButtons != null) {
                this.flNavigationButtons.setVisibility(0);
            } else {
                this.createNavigationButtons();
            }
        } else if (this.flNavigationButtons != null) {
            this.flNavigationButtons.setVisibility(8);
        }
        this.setSelectionBarVisibility();
        this.update();
    }

    @Override
    public void setConnectedDayTextColor(int connectedDayTextColor) {
        this.settingsManager.setConnectedDayTextColor(connectedDayTextColor);
        this.update();
    }

    @Override
    public void setConnectedDaySelectedTextColor(int connectedDaySelectedTextColor) {
        this.settingsManager.setConnectedDaySelectedTextColor(connectedDaySelectedTextColor);
        this.update();
    }

    @Override
    public void setDisabledDayTextColor(int disabledDayTextColor) {
        this.settingsManager.setDisabledDayTextColor(disabledDayTextColor);
        this.update();
    }

    @Override
    public void setSelectionBarMonthTextColor(int selectionBarMonthTextColor) {
        this.settingsManager.setSelectionBarMonthTextColor(selectionBarMonthTextColor);
        this.update();
    }

    @Override
    public void setPreviousMonthIconRes(int previousMonthIconRes) {
        this.settingsManager.setPreviousMonthIconRes(previousMonthIconRes);
        this.setPreviousNavigationButton();
    }

    @Override
    public void setNextMonthIconRes(int nextMonthIconRes) {
        this.settingsManager.setNextMonthIconRes(nextMonthIconRes);
        this.setNextNavigationButton();
    }

    @Override
    public void setShowDaysOfWeek(boolean showDaysOfWeek) {
        this.settingsManager.setShowDaysOfWeek(showDaysOfWeek);
        this.recreateInitialMonth();
    }

    @Override
    public void setShowDaysOfWeekTitle(boolean showDaysOfWeekTitle) {
        this.settingsManager.setShowDaysOfWeekTitle(showDaysOfWeekTitle);
        if (showDaysOfWeekTitle) {
            this.showDaysOfWeekTitle();
        } else {
            this.hideDaysOfWeekTitle();
        }
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.settingsManager.getFirstDayOfWeek();
    }

    @Override
    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek <= 0 || firstDayOfWeek >= 8) {
            throw new IllegalArgumentException("First day of week must be 1 - 7");
        }
        this.settingsManager.setFirstDayOfWeek(firstDayOfWeek);
        this.recreateInitialMonth();
        this.createDaysOfWeekTitle();
    }

    private void changeSnapHelper() {
        this.rvMonths.setOnFlingListener(null);
        if (this.snapHelper == null) {
            this.snapHelper = new GravitySnapHelper(this.settingsManager.getCalendarOrientation() == 1 ? 48 : 0x800003, true);
            this.snapHelper.attachToRecyclerView(this.rvMonths);
        } else {
            this.snapHelper.setGravity(this.settingsManager.getCalendarOrientation() == 1 ? 48 : 0x800003);
        }
    }

    @Override
    public void onMultipleSelectionListItemClick(Day day) {
        if (this.getSelectionManager() instanceof MultipleSelectionManager) {
            ((MultipleSelectionManager)this.getSelectionManager()).removeDay(day);
            this.monthAdapter.notifyDataSetChanged();
        }
    }
}

