/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.animation.Interpolator;

public class SlowdownRecyclerView
extends RecyclerView {
    private static final int POW = 2;
    private Interpolator interpolator;

    public SlowdownRecyclerView(Context context) {
        super(context);
        this.createInterpolator();
    }

    public SlowdownRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.createInterpolator();
    }

    public SlowdownRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createInterpolator();
    }

    private void createInterpolator() {
        this.interpolator = new Interpolator(){

            public float getInterpolation(float t) {
                t = Math.abs(t - 1.0f);
                return (float)(1.0 - Math.pow(t, 2.0));
            }
        };
    }

    public void smoothScrollBy(int dx, int dy) {
        super.smoothScrollBy(dx, dy, this.interpolator);
    }
}

