/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.view.customviews;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.selection.SelectionState;
import com.applikeysolutions.cosmocalendar.utils.CalendarUtils;
import com.applikeysolutions.cosmocalendar.view.CalendarView;

public class CircleAnimationTextView
extends AppCompatTextView {
    private SelectionState selectionState;
    private CalendarView calendarView;
    private int animationProgress;
    private boolean clearView;
    private boolean stateChanged;
    private Paint circlePaint;
    private Paint circleUnderPaint;
    private Day day;
    private int circleColor;
    private boolean animationStarted;
    private long animationStartTime;
    private Paint rectanglePaint;
    private Rect rectangle;
    private Paint backgroundRectanglePaint;
    private Rect backgroundRectangle;
    public static final int DEFAULT_PADDING = 10;
    public static final int MAX_PROGRESS = 100;
    public static final long SELECTION_ANIMATION_DURATION = 300L;

    public CircleAnimationTextView(Context context) {
        super(context);
    }

    public CircleAnimationTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CircleAnimationTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000) {
            super.onMeasure(widthMeasureSpec, CalendarUtils.getCircleWidth(this.getContext()) + 0x40000000);
        } else {
            super.onMeasure(widthMeasureSpec, widthMeasureSpec);
        }
    }

    public void draw(Canvas canvas) {
        if (this.clearView) {
            this.clearVariables();
        }
        if (this.selectionState != null) {
            switch (this.selectionState) {
                case START_RANGE_DAY: 
                case END_RANGE_DAY: {
                    this.drawRectangle(canvas);
                    this.drawCircleUnder(canvas);
                    this.drawCircle(canvas);
                    break;
                }
                case START_RANGE_DAY_WITHOUT_END: {
                    this.drawCircle(canvas);
                    break;
                }
                case SINGLE_DAY: {
                    boolean condition2;
                    boolean condition1 = !this.animationStarted && this.animationProgress != 100;
                    long currentTime = System.currentTimeMillis();
                    boolean bl = condition2 = this.animationStarted && currentTime > this.animationStartTime + 300L && this.animationProgress != 100;
                    if (condition1 || condition2) {
                        this.animateView();
                        break;
                    }
                    this.drawCircle(canvas);
                    break;
                }
                case RANGE_DAY: {
                    this.drawBackgroundRectangle(canvas);
                }
            }
        }
        super.draw(canvas);
    }

    private void drawCircle(Canvas canvas) {
        if (this.animationProgress == 100 && this.day != null) {
            this.day.setSelectionCircleDrawed(true);
        }
        if (this.circlePaint == null || this.stateChanged) {
            this.createCirclePaint();
        }
        int diameter = this.getWidth() - 20;
        int diameterProgress = this.animationProgress * diameter / 100;
        this.setBackgroundColor(0);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)(diameterProgress / 2), this.circlePaint);
    }

    private void drawCircleUnder(Canvas canvas) {
        if (this.circleUnderPaint == null || this.stateChanged) {
            this.createCircleUnderPaint();
        }
        int diameter = this.getWidth() - 20;
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)(diameter / 2), this.circleUnderPaint);
    }

    private void createCirclePaint() {
        this.circlePaint = new Paint();
        this.circlePaint.setColor(this.circleColor);
        this.circlePaint.setFlags(1);
    }

    private void createCircleUnderPaint() {
        this.circleUnderPaint = new Paint();
        this.circleUnderPaint.setColor(this.calendarView.getSelectedDayBackgroundColor());
        this.circleUnderPaint.setFlags(1);
    }

    private void drawRectangle(Canvas canvas) {
        if (this.rectanglePaint == null) {
            this.createRectanglePaint();
        }
        if (this.rectangle == null) {
            this.rectangle = this.getRectangleForState();
        }
        canvas.drawRect(this.rectangle, this.rectanglePaint);
    }

    private void createRectanglePaint() {
        this.rectanglePaint = new Paint();
        this.rectanglePaint.setColor(this.calendarView.getSelectedDayBackgroundColor());
        this.rectanglePaint.setFlags(1);
    }

    private void drawBackgroundRectangle(Canvas canvas) {
        if (this.backgroundRectanglePaint == null) {
            this.createBackgroundRectanglePaint();
        }
        if (this.backgroundRectangle == null) {
            this.backgroundRectangle = this.getRectangleForState();
        }
        canvas.drawRect(this.backgroundRectangle, this.backgroundRectanglePaint);
    }

    private void createBackgroundRectanglePaint() {
        this.backgroundRectanglePaint = new Paint();
        this.backgroundRectanglePaint.setColor(this.calendarView.getSelectedDayBackgroundColor());
        this.backgroundRectanglePaint.setFlags(1);
    }

    public SelectionState getSelectionState() {
        return this.selectionState;
    }

    public void setSelectionStateAndAnimate(SelectionState state, CalendarView calendarView, Day day) {
        this.isStateChanged(state);
        this.selectionState = state;
        this.calendarView = calendarView;
        day.setSelectionState(state);
        this.day = day;
        if (this.selectionState != null && calendarView != null) {
            switch (this.selectionState) {
                case START_RANGE_DAY: {
                    this.circleColor = calendarView.getSelectedDayBackgroundStartColor();
                    break;
                }
                case END_RANGE_DAY: {
                    this.circleColor = calendarView.getSelectedDayBackgroundEndColor();
                    break;
                }
                case START_RANGE_DAY_WITHOUT_END: {
                    this.setBackgroundColor(0);
                    this.circleColor = calendarView.getSelectedDayBackgroundStartColor();
                    break;
                }
                case SINGLE_DAY: {
                    this.circleColor = calendarView.getSelectedDayBackgroundColor();
                    this.setBackgroundColor(0);
                }
            }
        }
        this.animateView();
    }

    private Rect getRectangleForState() {
        switch (this.selectionState) {
            case START_RANGE_DAY: {
                return new Rect(this.getWidth() / 2, 10, this.getWidth(), this.getHeight() - 10);
            }
            case END_RANGE_DAY: {
                return new Rect(0, 10, this.getWidth() / 2, this.getHeight() - 10);
            }
            case RANGE_DAY: {
                return new Rect(0, 10, this.getWidth(), this.getHeight() - 10);
            }
        }
        return null;
    }

    private void animateView() {
        CircularFillAnimation animation = new CircularFillAnimation();
        animation.setDuration(300L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                CircleAnimationTextView.this.animationStarted = true;
                CircleAnimationTextView.this.animationStartTime = System.currentTimeMillis();
            }

            public void onAnimationEnd(Animation animation) {
                CircleAnimationTextView.this.animationStarted = false;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation(animation);
        this.invalidate();
    }

    private void isStateChanged(SelectionState newState) {
        this.stateChanged = this.selectionState == null || this.selectionState != newState;
    }

    public void setAnimationProgress(int animationProgress) {
        this.animationProgress = animationProgress;
    }

    public void clearView() {
        if (this.selectionState != null) {
            this.clearView = true;
            this.invalidate();
        }
    }

    private void clearVariables() {
        this.selectionState = null;
        this.calendarView = null;
        this.circlePaint = null;
        this.rectanglePaint = null;
        this.rectangle = null;
        this.stateChanged = false;
        this.circleColor = 0;
        this.animationProgress = 0;
        this.animationStarted = false;
        this.animationStartTime = 0L;
        this.setBackgroundColor(0);
        this.clearView = false;
    }

    public void showAsCircle(int circleColor) {
        this.circleColor = circleColor;
        this.animationProgress = 100;
        this.setWidth(CalendarUtils.getCircleWidth(this.getContext()));
        this.setHeight(CalendarUtils.getCircleWidth(this.getContext()));
        this.requestLayout();
    }

    public void showAsSingleCircle(CalendarView calendarView) {
        this.clearVariables();
        this.selectionState = SelectionState.SINGLE_DAY;
        this.showAsCircle(calendarView.getSelectedDayBackgroundColor());
    }

    public void showAsStartCircle(CalendarView calendarView, boolean animate) {
        if (animate) {
            this.clearVariables();
        }
        this.calendarView = calendarView;
        this.selectionState = SelectionState.START_RANGE_DAY;
        this.showAsCircle(calendarView.getSelectedDayBackgroundStartColor());
    }

    public void showAsStartCircleWithouEnd(CalendarView calendarView, boolean animate) {
        if (animate) {
            this.clearVariables();
        }
        this.calendarView = calendarView;
        this.selectionState = SelectionState.START_RANGE_DAY_WITHOUT_END;
        this.showAsCircle(calendarView.getSelectedDayBackgroundStartColor());
    }

    public void showAsEndCircle(CalendarView calendarView, boolean animate) {
        if (animate) {
            this.clearVariables();
        }
        this.calendarView = calendarView;
        this.selectionState = SelectionState.END_RANGE_DAY;
        this.showAsCircle(calendarView.getSelectedDayBackgroundEndColor());
    }

    public void showAsRange(CalendarView calendarView) {
        this.clearVariables();
        this.calendarView = calendarView;
        this.selectionState = SelectionState.RANGE_DAY;
        this.setWidth(CalendarUtils.getCircleWidth(this.getContext()) / 2);
        this.setHeight(CalendarUtils.getCircleWidth(this.getContext()));
        this.requestLayout();
    }

    class CircularFillAnimation
    extends Animation {
        CircularFillAnimation() {
        }

        protected void applyTransformation(float interpolatedTime, Transformation transformation) {
            int progress = (int)(interpolatedTime * 100.0f);
            CircleAnimationTextView.this.setAnimationProgress(progress);
            CircleAnimationTextView.this.requestLayout();
        }
    }
}

