/*
 * Decompiled with CFR 0.152.
 */
package com.applikeysolutions.cosmocalendar.view.delegate;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.applikeysolutions.cosmocalendar.adapter.MonthAdapter;
import com.applikeysolutions.cosmocalendar.adapter.viewholder.DayHolder;
import com.applikeysolutions.cosmocalendar.model.Day;
import com.applikeysolutions.cosmocalendar.selection.BaseSelectionManager;
import com.applikeysolutions.cosmocalendar.selection.MultipleSelectionManager;
import com.applikeysolutions.cosmocalendar.view.CalendarView;
import com.applikeysolutions.cosmocalendar.view.delegate.BaseDelegate;
import com.applikeysolutions.customizablecalendar.R;

public class DayDelegate
extends BaseDelegate {
    private MonthAdapter monthAdapter;

    public DayDelegate(CalendarView calendarView, MonthAdapter monthAdapter) {
        this.calendarView = calendarView;
        this.monthAdapter = monthAdapter;
    }

    public DayHolder onCreateDayHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.view_day, parent, false);
        return new DayHolder(view, this.calendarView);
    }

    public void onBindDayHolder(final RecyclerView.Adapter daysAdapter, final Day day, DayHolder holder, final int position) {
        final BaseSelectionManager selectionManager = this.monthAdapter.getSelectionManager();
        holder.bind(day, selectionManager);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!day.isDisabled()) {
                    selectionManager.toggleDay(day);
                    if (selectionManager instanceof MultipleSelectionManager) {
                        daysAdapter.notifyItemChanged(position);
                    } else {
                        DayDelegate.this.monthAdapter.notifyDataSetChanged();
                    }
                }
            }
        });
    }
}

