/*
 * Decompiled with CFR 0.152.
 */
package com.github.arcizon.spark.filetransfer.util;

import java.io.File;
import java.io.IOException;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class Cleanup$
implements Logging {
    public static Cleanup$ MODULE$;
    private final HashSet<String> shutdownDeletePaths;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Cleanup$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public HashSet<String> shutdownDeletePaths() {
        return this.shutdownDeletePaths;
    }

    public void shutDownCleanUp() {
        this.shutdownDeletePaths().foreach((Function1 & java.io.Serializable & Serializable)dirPath -> {
            Cleanup$.MODULE$.cleanupPath(dirPath);
            return BoxedUnit.UNIT;
        });
    }

    public void registerShutdownDeleteDir(File file) {
        String path = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            this.shutdownDeletePaths().$plus$eq((Object)path);
        }
    }

    private void cleanupPath(String dirPath) {
        try {
            this.deleteRecursively(new File(dirPath));
        }
        catch (Exception exception) {
            this.log().warn("Exception during cleanup !!");
        }
    }

    private void deleteRecursively(File file) throws IOException {
        block9: {
            if (file != null) {
                try {
                    if (!file.isDirectory() || this.isSymlink(file)) break block9;
                    ObjectRef savedIOException = ObjectRef.create(null);
                    this.listFilesSafely(file).foreach((Function1 & java.io.Serializable & Serializable)child -> {
                        Cleanup$.$anonfun$deleteRecursively$1(savedIOException, child);
                        return BoxedUnit.UNIT;
                    });
                    if ((IOException)savedIOException.elem != null) {
                        throw (IOException)savedIOException.elem;
                    }
                    HashSet<String> hashSet = this.shutdownDeletePaths();
                    synchronized (hashSet) {
                        this.shutdownDeletePaths().remove((Object)file.getAbsolutePath());
                    }
                }
                finally {
                    if (!file.delete() && file.exists()) {
                        throw new IOException(new StringBuilder(18).append("Failed to delete: ").append(file.getAbsolutePath()).toString());
                    }
                }
            }
        }
    }

    private boolean isSymlink(File file) {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        File fileInCanonicalDir = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    private Seq<File> listFilesSafely(File file) {
        Nil$ nil$;
        if (file.exists()) {
            File[] files = file.listFiles();
            if (files == null) {
                throw new IOException(new StringBuilder(30).append("Failed to list files for dir: ").append(file).toString());
            }
            nil$ = Predef$.MODULE$.wrapRefArray((Object[])files);
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public static final /* synthetic */ void $anonfun$deleteRecursively$1(ObjectRef savedIOException$1, File child) {
        try {
            MODULE$.deleteRecursively(child);
        }
        catch (IOException ioe) {
            savedIOException$1.elem = ioe;
        }
    }

    private Cleanup$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.shutdownDeletePaths = new HashSet();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Cleanup$.MODULE$.shutDownCleanUp();
            }
        });
    }
}

