/*
 * Decompiled with CFR 0.152.
 */
package com.github.arcizon.spark.filetransfer.util;

import com.github.arcizon.spark.filetransfer.util.Cleanup$;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.Try$;

public final class FileUtils$ {
    public static FileUtils$ MODULE$;

    static {
        new FileUtils$();
    }

    public void touch(String path) {
        File destPath = new File(path);
        if (destPath.exists()) {
            throw package$.MODULE$.error(new StringBuilder(24).append("Path '").append(path).append("' already exists!!").toString());
        }
        File parentPath = destPath.getCanonicalFile();
        Object object = !parentPath.exists() ? BoxesRunTime.boxToBoolean((boolean)parentPath.mkdirs()) : BoxedUnit.UNIT;
        destPath.createNewFile();
    }

    public String collectUploadFiles(String path, String prefix) {
        File srcPath = new File(path);
        File[] files = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])srcPath.listFiles())).filter((Function1 & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)FileUtils$.$anonfun$collectUploadFiles$1(x)));
        File headFile = (File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).head();
        String ext = this.getFileExt(headFile);
        File partsDir = new File(srcPath, "parts");
        partsDir.mkdir();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).indices().foreach((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)i -> files[i].renameTo(new File(partsDir, new StringBuilder(2).append(prefix).append("-").append(i).append(".").append(ext).toString())));
        return partsDir.getCanonicalPath();
    }

    /*
     * WARNING - void declaration
     */
    public File createTempDir(String root) {
        void var2_2;
        File dir = this.createTempDirectory(root);
        Cleanup$.MODULE$.registerShutdownDeleteDir(dir);
        return var2_2;
    }

    private File createTempDirectory(String root) {
        int attempts = 0;
        int maxAttempts = 10;
        File dir = null;
        while (dir == null) {
            if (++attempts > maxAttempts) {
                throw new IOException(new StringBuilder(49).append("Failed to create a temp directory (under ").append(root).append(") after ").append(maxAttempts).toString());
            }
            try {
                dir = new File(root, new StringBuilder(19).append("spark-filetransfer-").append(UUID.randomUUID().toString()).toString());
                if (!dir.exists() && dir.mkdirs()) continue;
                dir = null;
            }
            catch (SecurityException securityException) {
                dir = null;
            }
        }
        return dir;
    }

    public String getFileExt(File file) throws RuntimeException {
        return (String)Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> file.getName().split("\\.", 2)[1]).getOrElse((Function0 & java.io.Serializable & Serializable)() -> package$.MODULE$.error("Unable to extract the extension of the file to be uploaded!!"));
    }

    public static final /* synthetic */ boolean $anonfun$collectUploadFiles$1(File x) {
        return !x.isDirectory() && !x.getName().contains("SUCCESS") && !x.isHidden() && !x.getName().contains(".crc") && !x.getName().contains("_committed_") && !x.getName().contains("_started_");
    }

    private FileUtils$() {
        MODULE$ = this;
    }
}

