/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalScrollButton;

public class PgsScrollBarButton
extends MetalScrollButton {
    private static Color shadowColor;
    private static Color highlightColor;
    private boolean isFreeStanding = false;

    public PgsScrollBarButton(int direction, int width, boolean freeStanding) {
        super(direction, width, freeStanding);
        shadowColor = UIManager.getColor("ScrollBar.darkShadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.isFreeStanding = freeStanding;
        this.putClientProperty("rolloverBackground", UIManager.getColor("Button.rolloverBackground"));
        this.putClientProperty("pgs.isFlat", UIManager.get("Button.isFlat"));
        this.putClientProperty("gradientStart", UIManager.get("Button.gradientStart"));
        this.putClientProperty("gradientEnd", UIManager.get("Button.gradientEnd"));
        this.putClientProperty("rollover.gradientStart", UIManager.get("Button.rolloverGradientStart"));
        this.putClientProperty("rollover.gradientEnd", UIManager.get("Button.rolloverGradientEnd"));
        this.setBorder(null);
    }

    public void setFreeStanding(boolean freeStanding) {
        super.setFreeStanding(freeStanding);
        this.isFreeStanding = freeStanding;
    }

    public void paint(Graphics g) {
        int startY;
        int startX;
        int startX2;
        int startY2;
        boolean leftToRight = PgsUtils.isLeftToRight(this);
        boolean isEnabled = this.getParent().isEnabled();
        boolean isPressed = this.getModel().isPressed();
        ColorUIResource arrowColor = isEnabled ? PgsLookAndFeel.getPrimaryControlDarkShadow() : PgsLookAndFeel.getControlDisabled();
        int width = this.getWidth();
        int height = this.getHeight();
        int arrowHeight = height + 1 >> 2;
        if (isPressed) {
            PgsUtils.drawGradient(g, -1, 0, this.getWidth(), this.getHeight(), UIManager.getColor("Button.select"), UIManager.getColor("Button.select").brighter());
        } else {
            PgsUtils.drawGradient(g, this);
        }
        Graphics2D gfx = (Graphics2D)g;
        Stroke s = gfx.getStroke();
        gfx.setStroke(new BasicStroke(1.3f, 1, 1));
        g.setColor(arrowColor);
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getDirection() == 1) {
            startY2 = (height + 2 - arrowHeight) / 2 - 1;
            startX2 = (width + 1) / 2 - 1;
            gfx.drawLine(startX2, startY2, startX2 - 3, startY2 + 3);
            gfx.drawLine(startX2, startY2, startX2 + 3, startY2 + 3);
        } else if (this.getDirection() == 5) {
            startY2 = (height + 2 - arrowHeight) / 2 - 1;
            startX2 = (width + 1) / 2 - 1;
            gfx.drawLine(startX2 - 3, startY2, startX2, startY2 + 3);
            gfx.drawLine(startX2 + 3, startY2, startX2, startY2 + 3);
        } else if (this.getDirection() == 3) {
            startX = (width + 1 - arrowHeight) / 2;
            startY = height / 2;
            gfx.drawLine(startX, startY - 3, startX + 3, startY);
            gfx.drawLine(startX, startY + 3, startX + 3, startY);
        } else if (this.getDirection() == 7) {
            startX = (width + 1 - arrowHeight) / 2 - 1;
            startY = height / 2;
            gfx.drawLine(startX, startY, startX + 3, startY - 3);
            gfx.drawLine(startX, startY, startX + 3, startY + 3);
        }
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        gfx.setStroke(s);
        if (this.getModel().isEnabled() && this.getModel().isRollover() && !UIManager.getBoolean("Button.rolloverVistaStyle")) {
            s = gfx.getStroke();
            gfx.setStroke(new BasicStroke(2.4f, 2, 0));
            g.setColor(PgsLookAndFeel.getGlow());
            if (this.getDirection() == 1) {
                g.drawRect(2, 1, width - 3, height - 3);
            } else if (this.getDirection() == 5) {
                g.drawRect(2, 2, width - 3, height - 3);
            } else if (this.getDirection() == 3) {
                g.drawRect(2, 2, width - 4, height - 3);
            } else if (this.getDirection() == 7) {
                g.drawRect(1, 2, width - 3, height - 3);
            }
            gfx.setStroke(s);
        }
        g.setColor(isEnabled ? shadowColor : PgsLookAndFeel.getControlShadow());
        if (this.getDirection() == 1) {
            JScrollPane sc;
            if (PgsUtils.isLeftToRight(this.getParent())) {
                g.drawLine(0, 0, 0, height - 1);
            } else {
                g.drawLine(width - 1, 0, width - 1, height - 1);
            }
            g.drawLine(0, height - 1, width - 1, height - 1);
            Container c = this.getParent().getParent();
            if (c instanceof JScrollPane && (sc = (JScrollPane)c).getColumnHeader() != null) {
                g.drawLine(0, 0, width - 1, 0);
            }
        } else if (this.getDirection() == 5) {
            g.drawLine(0, 0, width - 1, 0);
            if (PgsUtils.isLeftToRight(this.getParent())) {
                g.drawLine(0, 0, 0, height - 1);
            } else {
                g.drawLine(width - 1, 0, width - 1, height - 1);
            }
            Container c = this.getParent().getParent();
            if (c instanceof JScrollPane) {
                JScrollPane sc = (JScrollPane)c;
                if (sc.getHorizontalScrollBar() != null && sc.getHorizontalScrollBar().isVisible()) {
                    g.drawLine(0, height - 1, width - 1, height - 1);
                }
            } else {
                g.drawLine(0, height - 1, width - 1, height - 1);
            }
        } else if (this.getDirection() == 3) {
            g.drawLine(0, 0, width - 1, 0);
            g.drawLine(0, 0, 0, height - 1);
            Container c = this.getParent().getParent();
            if (c instanceof JScrollPane) {
                JScrollPane sc = (JScrollPane)c;
                if (sc.getVerticalScrollBar() != null && sc.getVerticalScrollBar().isVisible()) {
                    g.drawLine(width - 1, 0, width - 1, height - 1);
                }
            } else {
                g.drawLine(width - 1, 0, width - 1, height - 1);
            }
        } else if (this.getDirection() == 7) {
            g.drawLine(0, 0, width - 1, 0);
            g.drawLine(width - 1, 0, width - 1, height - 1);
        }
    }

    protected void paintBorder(Graphics g) {
    }
}

