/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.RolloverButtonListener;
import com.pagosoft.plaf.ToolBarToggleButtonUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class PgsToggleButtonUI
extends MetalToggleButtonUI {
    private static PgsToggleButtonUI INSTANCE = new PgsToggleButtonUI();

    public static ComponentUI createUI(JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            return ToolBarToggleButtonUI.createUI(c);
        }
        return INSTANCE;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setFocusPainted(false);
        b.putClientProperty("rolloverBackground", UIManager.getColor("ToggleButton.rolloverBackground"));
        b.putClientProperty("pgs.isFlat", UIManager.get("ToggleButton.isFlat"));
        b.putClientProperty("gradientStart", UIManager.get("ToggleButton.gradientStart"));
        b.putClientProperty("gradientEnd", UIManager.get("ToggleButton.gradientEnd"));
        b.putClientProperty("rollover.gradientStart", UIManager.get("ToggleButton.rolloverGradientStart"));
        b.putClientProperty("rollover.gradientEnd", UIManager.get("ToggleButton.rolloverGradientEnd"));
        b.putClientProperty("selected.gradientStart", UIManager.get("ToggleButton.selectedGradientStart"));
        b.putClientProperty("selected.gradientEnd", UIManager.get("ToggleButton.selectedGradientEnd"));
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        int topLeftInset = 3;
        int width = b.getWidth() - topLeftInset * 2;
        int height = b.getHeight() - topLeftInset * 2;
        g.setColor(this.getFocusColor());
        PgsUtils.drawRoundRect(g, topLeftInset, topLeftInset, width - 1, height - 1, 3, 3);
    }

    public void update(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (c.isOpaque() && b.isContentAreaFilled()) {
            if (Boolean.TRUE.equals(c.getClientProperty("pgs.isFlat")) || !b.isEnabled()) {
                g.setColor(c.isEnabled() && b.getModel().isRollover() ? (Color)c.getClientProperty("rolloverBackground") : c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            } else if (c.isEnabled() && b.getModel().isRollover()) {
                PgsUtils.drawGradient(g, c, "rollover");
            } else {
                PgsUtils.drawGradient(g, c);
            }
        }
        super.paint(g, c);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            if (Boolean.TRUE.equals(b.getClientProperty("pgs.isFlat"))) {
                g.setColor(this.getSelectColor());
                g.fillRect(0, 0, b.getWidth(), b.getHeight());
            } else {
                PgsUtils.drawGradient(g, b, "selected");
            }
        }
    }
}

