/*
 * Decompiled with CFR 0.152.
 */
package com.github.arteam.simplejsonrpc.server;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.github.arteam.simplejsonrpc.core.annotation.JsonRpcError;
import com.github.arteam.simplejsonrpc.core.domain.ErrorMessage;
import com.github.arteam.simplejsonrpc.core.domain.ErrorResponse;
import com.github.arteam.simplejsonrpc.core.domain.Request;
import com.github.arteam.simplejsonrpc.core.domain.Response;
import com.github.arteam.simplejsonrpc.core.domain.SuccessResponse;
import com.github.arteam.simplejsonrpc.server.Reflections;
import com.github.arteam.simplejsonrpc.server.metadata.ClassMetadata;
import com.github.arteam.simplejsonrpc.server.metadata.ErrorDataResolver;
import com.github.arteam.simplejsonrpc.server.metadata.MethodMetadata;
import com.github.arteam.simplejsonrpc.server.metadata.ParameterMetadata;
import com.google.common.base.Defaults;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcServer {
    private static final ErrorMessage PARSE_ERROR = new ErrorMessage(-32700, "Parse error", null);
    private static final ErrorMessage METHOD_NOT_FOUND = new ErrorMessage(-32601, "Method not found", null);
    private static final ErrorMessage INVALID_REQUEST = new ErrorMessage(-32600, "Invalid Request", null);
    private static final ErrorMessage INVALID_PARAMS = new ErrorMessage(-32602, "Invalid params", null);
    private static final ErrorMessage INTERNAL_ERROR = new ErrorMessage(-32603, "Internal error", null);
    private static final Logger log = LoggerFactory.getLogger(JsonRpcServer.class);
    private static final String VERSION = "2.0";
    private final ObjectMapper mapper;
    private static final CacheBuilderSpec DEFAULT_SPEC = CacheBuilderSpec.parse((String)"expireAfterWrite=1h");
    private final LoadingCache<Class<?>, ClassMetadata> classesMetadata;
    private final LoadingCache<Class<? extends Throwable>, ErrorDataResolver> dataResolvers;

    public JsonRpcServer(ObjectMapper mapper, CacheBuilderSpec cacheBuilderSpec) {
        this.mapper = mapper;
        this.classesMetadata = CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec).build(new CacheLoader<Class<?>, ClassMetadata>(){

            @NotNull
            public ClassMetadata load(@NotNull Class<?> clazz) throws Exception {
                return Reflections.getClassMetadata(clazz);
            }
        });
        this.dataResolvers = CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec).build((CacheLoader)new CacheLoader<Class<? extends Throwable>, ErrorDataResolver>(){

            @NotNull
            public ErrorDataResolver load(@NotNull Class<? extends Throwable> clazz) throws Exception {
                return Reflections.buildErrorDataResolver(clazz);
            }
        });
    }

    public JsonRpcServer() {
        this(new ObjectMapper(), DEFAULT_SPEC);
    }

    public static JsonRpcServer withMapper(ObjectMapper mapper) {
        return new JsonRpcServer(mapper, DEFAULT_SPEC);
    }

    public static JsonRpcServer withCacheSpec(CacheBuilderSpec cacheSpec) {
        return new JsonRpcServer(new ObjectMapper(), cacheSpec);
    }

    public String handle(String textRequest, Object service) {
        return this.handle(service, () -> this.mapper.readTree(textRequest), this::toJson, () -> "");
    }

    public byte[] handle(byte[] byteRequest, Object service) {
        return this.handle(service, () -> this.mapper.readTree(byteRequest), this::toJsonByteArray, () -> new byte[0]);
    }

    public OutputStream handle(InputStream requestInputStream, OutputStream responseOutputStream, Object service) {
        return this.handle(service, () -> this.mapper.readTree(requestInputStream), v -> this.toJsonOutputStream(v, responseOutputStream), ByteArrayOutputStream::new);
    }

    private <T> T handle(Object service, JsonNodeSupplier rootRequestSupplier, Function<Object, T> jsonConverter, Supplier<T> emptyResponse) {
        JsonNode rootRequest;
        try {
            rootRequest = rootRequestSupplier.get();
            if (log.isDebugEnabled()) {
                log.debug("Request : {}", (Object)this.mapper.writeValueAsString((Object)rootRequest));
            }
        }
        catch (IOException e) {
            log.error("Bad json request", (Throwable)e);
            return jsonConverter.apply(new ErrorResponse(PARSE_ERROR));
        }
        if (rootRequest.isObject()) {
            Response response = this.handleWrapper(rootRequest, service);
            return this.isNotification(rootRequest, response) ? emptyResponse.get() : jsonConverter.apply(response);
        }
        if (rootRequest.isArray() && rootRequest.size() > 0) {
            ArrayNode responses = this.mapper.createArrayNode();
            for (JsonNode request : rootRequest) {
                Response response;
                if (this.isNotification(request, response = this.handleWrapper(request, service))) continue;
                responses.add((JsonNode)this.mapper.convertValue((Object)response, ObjectNode.class));
            }
            return responses.size() > 0 ? jsonConverter.apply(responses) : emptyResponse.get();
        }
        log.error("Invalid JSON-RPC request: " + rootRequest);
        return jsonConverter.apply(new ErrorResponse(INVALID_REQUEST));
    }

    private boolean isNotification(JsonNode requestNode, Response response) {
        if (requestNode.get("id") == null) {
            int errorCode;
            if (response instanceof SuccessResponse) {
                return true;
            }
            if (response instanceof ErrorResponse && (errorCode = ((ErrorResponse)response).getError().getCode()) != PARSE_ERROR.getCode() && errorCode != INVALID_REQUEST.getCode()) {
                return true;
            }
        }
        return false;
    }

    private Response handleWrapper(JsonNode requestNode, Object service) {
        Request request;
        try {
            request = (Request)this.mapper.convertValue((Object)requestNode, Request.class);
        }
        catch (Exception e) {
            log.error("Invalid JSON-RPC request: " + requestNode, (Throwable)e);
            return new ErrorResponse(INVALID_REQUEST);
        }
        try {
            return this.handleSingle(request, service);
        }
        catch (Exception e) {
            Throwable realException = e instanceof InvocationTargetException ? e.getCause() : e;
            log.error("Error while processing: " + request, realException);
            return this.handleError(request, e);
        }
    }

    private ErrorResponse handleError(Request request, Exception e) {
        JsonNode data;
        String message;
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        Annotation[] annotations = rootCause.getClass().getAnnotations();
        JsonRpcError jsonRpcErrorAnnotation = Reflections.getAnnotation(annotations, JsonRpcError.class);
        if (jsonRpcErrorAnnotation == null) {
            return new ErrorResponse(request.getId(), INTERNAL_ERROR);
        }
        int code = jsonRpcErrorAnnotation.code();
        String string = message = Strings.isNullOrEmpty((String)jsonRpcErrorAnnotation.message()) ? rootCause.getMessage() : jsonRpcErrorAnnotation.message();
        if (Strings.isNullOrEmpty((String)message)) {
            log.warn("Error message should not be empty");
            return new ErrorResponse(request.getId(), INTERNAL_ERROR);
        }
        try {
            data = ((ErrorDataResolver)this.dataResolvers.get(rootCause.getClass())).resolveData(rootCause).map(arg_0 -> ((ObjectMapper)this.mapper).valueToTree(arg_0)).orElse(null);
        }
        catch (Exception e1) {
            log.error("Error while processing error data: ", (Throwable)e1);
            return new ErrorResponse(request.getId(), INTERNAL_ERROR);
        }
        return new ErrorResponse(request.getId(), new ErrorMessage(code, message, data));
    }

    private Response handleSingle(Request request, Object service) throws Exception {
        Object result;
        Object[] methodParams;
        String requestMethod = request.getMethod();
        String jsonrpc = request.getJsonrpc();
        ValueNode id = request.getId();
        if (jsonrpc == null || requestMethod == null) {
            log.error("Not a JSON-RPC request: " + request);
            return new ErrorResponse(id, INVALID_REQUEST);
        }
        if (!jsonrpc.equals(VERSION)) {
            log.error("Not a JSON_RPC 2.0 request: " + request);
            return new ErrorResponse(id, INVALID_REQUEST);
        }
        JsonNode params = request.getParams();
        if (!(params.isObject() || params.isArray() || params.isNull())) {
            log.error("Params of request: '" + request + "' should be an object, an array or null");
            return new ErrorResponse(id, INVALID_REQUEST);
        }
        ClassMetadata classMetadata = (ClassMetadata)this.classesMetadata.get(service.getClass());
        if (!classMetadata.isService()) {
            log.warn(service.getClass() + " is not available as a JSON-RPC 2.0 service");
            return new ErrorResponse(id, METHOD_NOT_FOUND);
        }
        MethodMetadata method = (MethodMetadata)classMetadata.getMethods().get((Object)requestMethod);
        if (method == null) {
            log.error("Unable find a method: '" + requestMethod + "' in a " + service.getClass());
            return new ErrorResponse(id, METHOD_NOT_FOUND);
        }
        ContainerNode notNullParams = !params.isNull() ? (ContainerNode)params : this.mapper.createObjectNode();
        try {
            methodParams = this.convertToMethodParams(notNullParams, method);
        }
        catch (IllegalArgumentException e) {
            log.error("Bad params: " + notNullParams + " of a method '" + method.getName() + "'", (Throwable)e);
            return new ErrorResponse(id, INVALID_PARAMS);
        }
        try {
            result = method.getMethodHandle().bindTo(service).invokeWithArguments(methodParams);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return new SuccessResponse(id, result);
    }

    private Object[] convertToMethodParams(ContainerNode<?> params, MethodMetadata method) {
        int methodParamsSize = method.getParams().size();
        int jsonParamsSize = params.size();
        if (jsonParamsSize > methodParamsSize) {
            throw new IllegalArgumentException("Wrong amount arguments: " + jsonParamsSize + " for a method '" + method.getName() + "'. Actual amount: " + methodParamsSize);
        }
        Object[] methodParams = new Object[methodParamsSize];
        int processed = 0;
        for (ParameterMetadata param : method.getParams().values()) {
            JsonNode jsonNode;
            Class<?> parameterType = param.getType();
            int index = param.getIndex();
            String name = param.getName();
            JsonNode jsonNode2 = jsonNode = params.isObject() ? params.get(name) : params.get(index);
            if (jsonNode == null || jsonNode.isNull()) {
                if (param.isOptional()) {
                    methodParams[index] = this.getDefaultValue(parameterType);
                    if (jsonNode == null) continue;
                    ++processed;
                    continue;
                }
                throw new IllegalArgumentException("Mandatory parameter '" + name + "' of a method '" + method.getName() + "' is not set");
            }
            try {
                JsonParser jsonParser = this.mapper.treeAsTokens((TreeNode)jsonNode);
                JavaType javaType = this.mapper.getTypeFactory().constructType(param.getGenericType());
                methodParams[index] = this.mapper.readValue(jsonParser, javaType);
                ++processed;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Wrong param: " + jsonNode + ". Expected type: '" + param, e);
            }
        }
        if (processed < jsonParamsSize) {
            throw new IllegalArgumentException("Some unspecified parameters in " + params + " are passed to a method '" + method.getName() + "'");
        }
        return methodParams;
    }

    @Nullable
    private Object getDefaultValue(Class<?> type) {
        if (type == com.google.common.base.Optional.class) {
            return com.google.common.base.Optional.absent();
        }
        if (type == Optional.class) {
            return Optional.empty();
        }
        if (type.isPrimitive()) {
            return Defaults.defaultValue(type);
        }
        return null;
    }

    private String toJson(Object value) {
        try {
            String response = this.mapper.writeValueAsString(value);
            if (log.isDebugEnabled()) {
                log.debug("Response: {}", (Object)response);
            }
            return response;
        }
        catch (JsonProcessingException e) {
            log.error("Unable write json: " + value, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private byte[] toJsonByteArray(Object value) {
        try {
            byte[] response = this.mapper.writeValueAsBytes(value);
            if (log.isDebugEnabled()) {
                log.debug("Response: {}", (Object)Arrays.toString(response));
            }
            return response;
        }
        catch (JsonProcessingException e) {
            log.error("Unable write json: " + value, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private OutputStream toJsonOutputStream(Object value, OutputStream outputStream) {
        try {
            this.mapper.writeValue(outputStream, value);
            return outputStream;
        }
        catch (IOException e) {
            log.error("Unable write json: " + value, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @FunctionalInterface
    private static interface JsonNodeSupplier {
        public JsonNode get() throws IOException;
    }
}

